/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.graphics.control;

import app.tuxguitar.graphics.control.TGLayout;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.graphics.control.TGNotation;
import app.tuxguitar.graphics.control.TGNoteImpl;
import app.tuxguitar.graphics.control.TGVoiceImpl;
import app.tuxguitar.song.models.TGVoice;
import java.util.ArrayList;
import java.util.List;

public class TGBeatGroup {
    public static final int DIRECTION_NOT_SET = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    private static final int UP_OFFSET = 28;
    private static final int DOWN_OFFSET = 35;
    private int voice;
    private int direction;
    private List<TGVoice> voices;
    private TGNoteImpl firstMinNote;
    private TGNoteImpl firstMaxNote;
    private TGNoteImpl lastMinNote;
    private TGNoteImpl lastMaxNote;
    private TGNoteImpl maxNote;
    private TGNoteImpl minNote;

    public TGBeatGroup(int voice) {
        this.voice = voice;
        this.voices = new ArrayList<TGVoice>();
        this.direction = 0;
        this.firstMinNote = null;
        this.firstMaxNote = null;
        this.lastMinNote = null;
        this.lastMaxNote = null;
        this.maxNote = null;
        this.minNote = null;
    }

    public void check(TGLayout layout, TGVoiceImpl voice) {
        this.check(layout, voice.getMaxNote());
        this.check(layout, voice.getMinNote());
        this.voices.add(voice);
        if (voice.getDirection() != 0) {
            if (voice.getDirection() == 1) {
                this.direction = 1;
            } else if (voice.getDirection() == 2) {
                this.direction = 2;
            }
        }
    }

    private void check(TGLayout layout, TGNoteImpl note) {
        int value = TGNotation.computePosition(layout, note);
        if (this.firstMinNote == null || note.getVoice().getBeat().getStart() < this.firstMinNote.getVoice().getBeat().getStart()) {
            this.firstMinNote = note;
        } else if (note.getVoice().getBeat().getStart() == this.firstMinNote.getVoice().getBeat().getStart() && value < TGNotation.computePosition(layout, this.firstMinNote)) {
            this.firstMinNote = note;
        }
        if (this.firstMaxNote == null || note.getVoice().getBeat().getStart() < this.firstMaxNote.getVoice().getBeat().getStart()) {
            this.firstMaxNote = note;
        } else if (note.getVoice().getBeat().getStart() == this.firstMaxNote.getVoice().getBeat().getStart() && value > TGNotation.computePosition(layout, this.firstMaxNote)) {
            this.firstMaxNote = note;
        }
        if (this.lastMinNote == null || note.getVoice().getBeat().getStart() > this.lastMinNote.getVoice().getBeat().getStart()) {
            this.lastMinNote = note;
        } else if (note.getVoice().getBeat().getStart() == this.lastMinNote.getVoice().getBeat().getStart() && value < TGNotation.computePosition(layout, this.lastMinNote)) {
            this.lastMinNote = note;
        }
        if (this.lastMaxNote == null || note.getVoice().getBeat().getStart() > this.lastMaxNote.getVoice().getBeat().getStart()) {
            this.lastMaxNote = note;
        } else if (note.getVoice().getBeat().getStart() == this.lastMaxNote.getVoice().getBeat().getStart() && value > TGNotation.computePosition(layout, this.lastMaxNote)) {
            this.lastMaxNote = note;
        }
        if (this.maxNote == null || value > TGNotation.computePosition(layout, this.maxNote)) {
            this.maxNote = note;
        }
        if (this.minNote == null || value < TGNotation.computePosition(layout, this.minNote)) {
            this.minNote = note;
        }
    }

    public void finish(TGLayout layout, TGMeasureImpl measure) {
        if (this.direction == 0) {
            if (measure.getNotEmptyVoices() > 1) {
                this.direction = this.voice == 0 ? 1 : 2;
            } else if ((layout.getStyle() & 4) == 0) {
                this.direction = 2;
            } else {
                int minPosition = TGNotation.computePosition(layout, this.minNote);
                int maxPosition = TGNotation.computePosition(layout, this.maxNote);
                int middlePosition = maxPosition > minPosition ? minPosition + (maxPosition - minPosition) / 2 : minPosition;
                this.direction = middlePosition > 3 ? 1 : 2;
            }
        }
    }

    public List<TGVoice> getVoices() {
        return this.voices;
    }

    public float getY1(TGLayout layout, TGNoteImpl note) {
        float scale = layout.getScoreLineSpacing() / 2.0f;
        float scoreLineY = (float)TGNotation.computePosition(layout, note) * scale;
        return scoreLineY;
    }

    public float getY2(TGLayout layout, float x) {
        float y2;
        float maxDistance = 10.0f * layout.getScale();
        float upOffset = TGBeatGroup.getUpOffset(layout);
        float downOffset = TGBeatGroup.getDownOffset(layout);
        if (this.direction == 2) {
            float y22;
            if (this.maxNote != this.firstMaxNote && this.maxNote != this.lastMaxNote) {
                return this.getY1(layout, this.maxNote) + downOffset;
            }
            float y = 0.0f;
            float x1 = this.firstMaxNote.getPosX() + this.firstMaxNote.getBeatImpl().getSpacing(layout);
            float x2 = this.lastMaxNote.getPosX() + this.lastMaxNote.getBeatImpl().getSpacing(layout);
            float y1 = this.getY1(layout, this.firstMaxNote) + downOffset;
            if (y1 > (y22 = this.getY1(layout, this.lastMaxNote) + downOffset) && y1 - y22 > maxDistance) {
                y22 = y1 - maxDistance;
            }
            if (y22 > y1 && y22 - y1 > maxDistance) {
                y1 = y22 - maxDistance;
            }
            if (y1 - y22 != 0.0f && x1 - x2 != 0.0f && x1 - x != 0.0f) {
                y = (y1 - y22) / (x1 - x2) * (x1 - x);
            }
            return y1 - y;
        }
        if (this.minNote != this.firstMinNote && this.minNote != this.lastMinNote) {
            return this.getY1(layout, this.minNote) - upOffset;
        }
        float y = 0.0f;
        float x1 = this.firstMinNote.getPosX() + this.firstMinNote.getBeatImpl().getSpacing(layout);
        float x2 = this.lastMinNote.getPosX() + this.lastMinNote.getBeatImpl().getSpacing(layout);
        float y1 = this.getY1(layout, this.firstMinNote) - upOffset;
        if (y1 < (y2 = this.getY1(layout, this.lastMinNote) - upOffset) && y2 - y1 > maxDistance) {
            y2 = y1 + maxDistance;
        }
        if (y2 < y1 && y1 - y2 > maxDistance) {
            y1 = y2 + maxDistance;
        }
        if (y1 - y2 != 0.0f && x1 - x2 != 0.0f && x1 - x != 0.0f) {
            y = (y1 - y2) / (x1 - x2) * (x1 - x);
        }
        return y1 - y;
    }

    public int getDirection() {
        return this.direction;
    }

    public TGNoteImpl getMinNote() {
        return this.minNote;
    }

    public TGNoteImpl getMaxNote() {
        return this.maxNote;
    }

    public static float getUpOffset(TGLayout layout) {
        float scale = layout.getScoreLineSpacing() / 8.0f;
        return 28.0f * scale;
    }

    public static float getDownOffset(TGLayout layout) {
        float scale = layout.getScoreLineSpacing() / 8.0f;
        return 35.0f * scale;
    }
}

