/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.graphics.control;

import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.graphics.control.TGLayout;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.song.models.TGLyric;
import app.tuxguitar.ui.resource.UIPainter;

public class TGLyricImpl
extends TGLyric {
    private int height = 0;
    private int nextIndex = 0;

    @Override
    public void setFrom(int from) {
        super.setFrom(from);
        this.update();
    }

    @Override
    public void setLyrics(String lyrics) {
        super.setLyrics(lyrics);
        this.update();
    }

    private void update() {
        this.height = this.isEmpty() ? 0 : 10;
    }

    public void start() {
        this.start(0);
    }

    public void start(int index) {
        this.nextIndex = index;
    }

    public void setCurrentMeasure(TGMeasureImpl measure) {
        if (measure.getNumber() >= this.getFrom()) {
            measure.setLyricBeatIndex(this.nextIndex);
            this.nextIndex += measure.getNotEmptyBeats();
        } else {
            measure.setLyricBeatIndex(-1);
            this.start();
        }
    }

    public void paintCurrentNoteBeats(UIPainter painter, TGLayout layout, TGMeasureImpl currentMeasure, float fromX, float fromY) {
        int from = currentMeasure.getLyricBeatIndex();
        String[] beats = this.getLyricBeats();
        if (beats != null && from >= 0 && from < beats.length) {
            int beatIndex = 0;
            for (int i = 0; i < currentMeasure.countBeats(); ++i) {
                String str;
                TGBeatImpl beat = (TGBeatImpl)currentMeasure.getBeat(i);
                if (beat.isRestBeat()) continue;
                if (from + beatIndex < beats.length && (str = beats[from + beatIndex].trim()).length() > 0) {
                    float x = fromX + beat.getPosX() + beat.getSpacing(layout) + 2.0f;
                    layout.setLyricStyle(painter, layout.isPlayModeEnabled() && beat.isPlaying(layout));
                    painter.drawString(str, x + 13.0f, fromY + currentMeasure.getTs().getPosition(16));
                }
                ++beatIndex;
            }
        }
    }

    public int getHeight() {
        return this.height;
    }
}

