/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.tg;

import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatException;
import app.tuxguitar.io.base.TGSongWriter;
import app.tuxguitar.io.base.TGSongWriterHandle;
import app.tuxguitar.io.tg.TGStream;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGChannelParameter;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.song.models.TGDivisionType;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGNoteEffect;
import app.tuxguitar.song.models.TGPickStroke;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGStroke;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.song.models.effects.TGEffectBend;
import app.tuxguitar.song.models.effects.TGEffectGrace;
import app.tuxguitar.song.models.effects.TGEffectTremoloBar;
import app.tuxguitar.util.TGVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TGSongWriterImpl
extends TGStream
implements TGSongWriter {
    private Document document;

    @Override
    public TGFileFormat getFileFormat() {
        return TG_FORMAT;
    }

    @Override
    public void write(TGSongWriterHandle handle) throws TGFileFormatException {
        this.writeXMLDocument(handle);
        try {
            ArchiveOutputStream outputStream = new ArchiveStreamFactory().createArchiveOutputStream("zip", handle.getOutputStream());
            ZipArchiveEntry zaeVersion = new ZipArchiveEntry("version.txt");
            outputStream.putArchiveEntry((ArchiveEntry)zaeVersion);
            this.addVersion((OutputStream)outputStream);
            outputStream.closeArchiveEntry();
            ZipArchiveEntry zaeContent = new ZipArchiveEntry("content.xml");
            outputStream.putArchiveEntry((ArchiveEntry)zaeContent);
            this.saveDocument((OutputStream)outputStream);
            outputStream.closeArchiveEntry();
            outputStream.close();
        }
        catch (IOException | ArchiveException e) {
            e.printStackTrace();
            throw new TGFileFormatException(e);
        }
    }

    public void writeContent(TGSongWriterHandle handle) throws TGFileFormatException {
        this.writeXMLDocument(handle);
        this.saveDocument(handle.getOutputStream());
    }

    private void writeXMLDocument(TGSongWriterHandle handle) throws TGFileFormatException {
        try {
            this.document = this.newDocument();
            Node nodeRoot = this.addNode(this.document, "TuxGuitarFile");
            Node nodeVersion = this.addNode(nodeRoot, "TGVersion");
            this.addAttributeInt(nodeVersion, "major", TGVersion.CURRENT.getMajor());
            this.addAttributeInt(nodeVersion, "minor", TGVersion.CURRENT.getMinor());
            this.addAttributeInt(nodeVersion, "revision", TGVersion.CURRENT.getRevision());
            this.writeSong(handle.getSong(), this.addNode(nodeRoot, "TGSong"));
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private void writeSong(TGSong song, Node nodeSong) throws IOException {
        this.addNode(nodeSong, "name", song.getName());
        this.addNode(nodeSong, "artist", song.getArtist());
        this.addNode(nodeSong, "album", song.getAlbum());
        this.addNode(nodeSong, "author", song.getAuthor());
        this.addNode(nodeSong, "date", song.getDate());
        this.addNode(nodeSong, "copyright", song.getCopyright());
        this.addNode(nodeSong, "writer", song.getWriter());
        this.addNode(nodeSong, "transcriber", song.getTranscriber());
        this.addNode(nodeSong, "comments", song.getComments());
        Iterator<TGChannel> channels = song.getChannels();
        while (channels.hasNext()) {
            this.writeChannel(channels.next(), this.addNode(nodeSong, "TGChannel"));
        }
        Iterator<TGMeasureHeader> headers = song.getMeasureHeaders();
        while (headers.hasNext()) {
            this.writeMeasureHeader(headers.next(), this.addNode(nodeSong, "TGMeasureHeader"));
        }
        Iterator<TGTrack> tracks = song.getTracks();
        while (tracks.hasNext()) {
            this.writeTrack(tracks.next(), this.addNode(nodeSong, "TGTrack"));
        }
    }

    private void writeChannel(TGChannel channel, Node nodeChannel) {
        this.addNodeInt(nodeChannel, "id", channel.getChannelId());
        this.addNodeInt(nodeChannel, "bank", channel.getBank());
        this.addNodeInt(nodeChannel, "program", channel.getProgram());
        this.addNodeInt(nodeChannel, "volume", channel.getVolume());
        this.addNodeInt(nodeChannel, "balance", channel.getBalance());
        this.addNodeInt(nodeChannel, "chorus", channel.getChorus());
        this.addNodeInt(nodeChannel, "reverb", channel.getReverb());
        this.addNodeInt(nodeChannel, "phaser", channel.getPhaser());
        this.addNodeInt(nodeChannel, "tremolo", channel.getTremolo());
        this.addNode(nodeChannel, "name", channel.getName());
        Iterator<TGChannelParameter> parameters = channel.getParameters();
        while (parameters.hasNext()) {
            TGChannelParameter parameter = parameters.next();
            Node nodeParameter = this.addNode(nodeChannel, "TGChannelParameter");
            this.addAttribute(nodeParameter, "key", parameter.getKey());
            this.addAttribute(nodeParameter, "value", parameter.getValue());
        }
    }

    private void writeMeasureHeader(TGMeasureHeader header, Node nodeMeasureHeader) {
        Node node = this.addNode(nodeMeasureHeader, "timeSignature");
        this.addAttributeInt(node, "numerator", header.getTimeSignature().getNumerator());
        this.addAttributeInt(node, "denominator", header.getTimeSignature().getDenominator().getValue());
        Node nodeTempo = this.addNodeInt(nodeMeasureHeader, "tempo", header.getTempo().getRawValue());
        if (header.getTempo().getBase() != 4) {
            this.addAttributeInt(nodeTempo, "base", header.getTempo().getBase());
        }
        if (header.getTempo().isDotted()) {
            this.addAttribute(nodeTempo, "dotted", "true");
        }
        if (header.isRepeatOpen()) {
            this.addNode(nodeMeasureHeader, "repeatOpen");
        }
        if (header.getRepeatClose() != 0) {
            this.addNodeInt(nodeMeasureHeader, "repeatClose", header.getRepeatClose());
        }
        if (header.getRepeatAlternative() != 0) {
            node = this.addNode(nodeMeasureHeader, "repeatAlternative");
            int flag = header.getRepeatAlternative();
            int alternative = 1;
            while (flag != 0) {
                if ((flag & 1) != 0) {
                    this.addNodeInt(node, "alternative", alternative);
                }
                flag >>= 1;
                ++alternative;
            }
        }
        if (header.hasMarker()) {
            Node nodeMarker = this.addNode(nodeMeasureHeader, "marker", header.getMarker().getTitle());
            this.addAttributeInt(nodeMarker, "R", header.getMarker().getColor().getR());
            this.addAttributeInt(nodeMarker, "G", header.getMarker().getColor().getG());
            this.addAttributeInt(nodeMarker, "B", header.getMarker().getColor().getB());
        }
        if (header.getTripletFeel() != 1) {
            this.addNode(nodeMeasureHeader, "tripletFeel", (String)this.tripletsWriteMap.get(header.getTripletFeel()));
        }
        if (header.isLineBreak()) {
            this.addNode(nodeMeasureHeader, "lineBreak");
        }
    }

    private void writeTrack(TGTrack track, Node nodeTrack) {
        this.addNode(nodeTrack, "name", track.getName());
        if (!track.isPercussion()) {
            this.addAttributeInt(nodeTrack, "maxFret", track.getMaxFret());
        }
        if (track.isMute()) {
            this.addNode(nodeTrack, "soloMute", "mute");
        } else if (track.isSolo()) {
            this.addNode(nodeTrack, "soloMute", "solo");
        }
        this.addNodeInt(nodeTrack, "channelId", track.getChannelId());
        if (track.getOffset() != 0) {
            this.addNodeInt(nodeTrack, "offset", track.getOffset());
        }
        Node nodeColor = this.addNode(nodeTrack, "color");
        this.addAttributeInt(nodeColor, "R", track.getColor().getR());
        this.addAttributeInt(nodeColor, "G", track.getColor().getG());
        this.addAttributeInt(nodeColor, "B", track.getColor().getB());
        for (TGString string : track.getStrings()) {
            this.addNodeInt(nodeTrack, "TGString", string.getValue());
        }
        Node nodeLyric = this.addNode(nodeTrack, "TGLyric", track.getLyrics().getLyrics());
        this.addAttributeInt(nodeLyric, "from", track.getLyrics().getFrom());
        this.writeMeasures(track.getMeasures(), nodeTrack);
    }

    private void writeMeasures(Iterator<TGMeasure> measures, Node nodeTrack) {
        TGMeasure precedingMeasure = null;
        while (measures.hasNext()) {
            TGMeasure measure = measures.next();
            Node nodeMeasure = this.addNode(nodeTrack, "TGMeasure");
            if (precedingMeasure == null || precedingMeasure.getClef() != measure.getClef()) {
                this.addNode(nodeMeasure, "clef", (String)this.mapWriteClefs.get(measure.getClef()));
            }
            if (precedingMeasure == null || precedingMeasure.getKeySignature() != measure.getKeySignature()) {
                this.addNodeInt(nodeMeasure, "keySignature", measure.getKeySignature());
            }
            List<TGBeat> beats = measure.getBeats();
            for (TGBeat beat : beats) {
                this.writeBeat(beat, this.addNode(nodeMeasure, "TGBeat"));
            }
            precedingMeasure = measure;
        }
    }

    private void writeBeat(TGBeat beat, Node nodeBeat) {
        TGChord chord;
        TGPickStroke pickStroke;
        this.addNodeLong(nodeBeat, "preciseStart", beat.getPreciseStart());
        TGStroke stroke = beat.getStroke();
        if (stroke.getDirection() != 0) {
            Node nodeStroke = this.addNode(nodeBeat, "stroke");
            this.addAttribute(nodeStroke, "direction", (String)this.mapWriteStroke.get(stroke.getDirection()));
            this.addAttributeInt(nodeStroke, "value", stroke.getValue());
        }
        if ((pickStroke = beat.getPickStroke()).getDirection() != 0) {
            this.addNode(nodeBeat, "pickStroke", (String)this.mapWritePickStroke.get(pickStroke.getDirection()));
        }
        if ((chord = beat.getChord()) != null) {
            Node nodeChord = this.addNode(nodeBeat, "chord");
            this.addNode(nodeChord, "name", chord.getName());
            this.addNodeInt(nodeChord, "firstFret", chord.getFirstFret());
            for (int string : chord.getStrings()) {
                if (string >= 0) {
                    this.addNodeInt(nodeChord, "string", string);
                    continue;
                }
                this.addNode(nodeChord, "string");
            }
        }
        if (beat.getText() != null && !beat.getText().getValue().equals("")) {
            this.addNode(nodeBeat, "text", beat.getText().getValue());
        }
        for (int i = 0; i < 2; ++i) {
            this.writeVoice(beat.getVoice(i), this.addNode(nodeBeat, "voice"));
        }
    }

    private void writeVoice(TGVoice voice, Node nodeVoice) {
        Node nodeDuration = this.addNode(nodeVoice, "duration");
        TGDivisionType divisionType = voice.getDuration().getDivision();
        if (divisionType != TGDivisionType.NORMAL) {
            Node nodeDivisionType = this.addNode(nodeDuration, "divisionType");
            this.addAttributeInt(nodeDivisionType, "enters", divisionType.getEnters());
            this.addAttributeInt(nodeDivisionType, "times", divisionType.getTimes());
        }
        this.addAttributeInt(nodeDuration, "value", voice.getDuration().getValue());
        if (voice.getDuration().isDotted()) {
            this.addAttribute(nodeDuration, "dotted", "dotted");
        } else if (voice.getDuration().isDoubleDotted()) {
            this.addAttribute(nodeDuration, "dotted", "doubleDotted");
        }
        TGNote previousNote = null;
        for (TGNote note : voice.getNotes()) {
            this.writeNote(note, previousNote, this.addNode(nodeVoice, "note"));
            previousNote = note;
        }
        if (voice.getNotes().size() == 0) {
            this.addAttributeBool(nodeVoice, "empty", voice.isEmpty());
        }
        if (voice.getDirection() != 0) {
            this.addAttribute(nodeVoice, "direction", (String)this.mapWriteDirection.get(voice.getDirection()));
        }
    }

    private void writeNote(TGNote note, TGNote previousNote, Node nodeNote) {
        Node nodePoint;
        TGNoteEffect effect = note.getEffect();
        if (effect.isVibrato()) {
            this.addNode(nodeNote, "vibrato");
        }
        if (effect.isDeadNote()) {
            this.addNode(nodeNote, "deadNote");
        }
        if (effect.isSlide()) {
            this.addNode(nodeNote, "slide");
        }
        if (effect.isHammer()) {
            this.addNode(nodeNote, "hammer");
        }
        if (effect.isGhostNote()) {
            this.addNode(nodeNote, "ghostNote");
        }
        if (effect.isAccentuatedNote()) {
            this.addNode(nodeNote, "accentuatedNote");
        }
        if (effect.isHeavyAccentuatedNote()) {
            this.addNode(nodeNote, "heavyAccentuatedNote");
        }
        if (effect.isPalmMute()) {
            this.addNode(nodeNote, "palmMute");
        }
        if (effect.isStaccato()) {
            this.addNode(nodeNote, "staccato");
        }
        if (effect.isTapping()) {
            this.addNode(nodeNote, "tapping");
        }
        if (effect.isSlapping()) {
            this.addNode(nodeNote, "slapping");
        }
        if (effect.isPopping()) {
            this.addNode(nodeNote, "popping");
        }
        if (effect.isFadeIn()) {
            this.addNode(nodeNote, "fadeIn");
        }
        if (effect.isLetRing()) {
            this.addNode(nodeNote, "letRing");
        }
        if (effect.isBend()) {
            Node nodeBend = this.addNode(nodeNote, "bend");
            for (TGEffectBend.BendPoint bendPoint : effect.getBend().getPoints()) {
                nodePoint = this.addNode(nodeBend, "point");
                this.addAttributeInt(nodePoint, "position", bendPoint.getPosition());
                this.addAttributeInt(nodePoint, "value", bendPoint.getValue());
            }
        }
        if (effect.isTremoloBar()) {
            Node nodeTremoloBar = this.addNode(nodeNote, "tremoloBar");
            for (TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint : effect.getTremoloBar().getPoints()) {
                nodePoint = this.addNode(nodeTremoloBar, "point");
                this.addAttributeInt(nodePoint, "position", tremoloBarPoint.getPosition());
                this.addAttributeInt(nodePoint, "value", tremoloBarPoint.getValue());
            }
        }
        if (effect.isHarmonic()) {
            Node nodeHarmonic = this.addNode(nodeNote, "harmonic");
            this.addAttribute(nodeHarmonic, "type", (String)this.harmonicWritedMap.get(effect.getHarmonic().getType()));
            this.addAttributeInt(nodeHarmonic, "data", effect.getHarmonic().getData());
        }
        if (effect.isGrace()) {
            TGEffectGrace grace = effect.getGrace();
            Node nodeGrace = this.addNode(nodeNote, "grace");
            this.addAttributeInt(nodeGrace, "fret", grace.getFret());
            this.addAttributeInt(nodeGrace, "duration", (Integer)this.mapWriteGraceDuration.get(grace.getDuration()));
            this.addAttributeInt(nodeGrace, "dynamic", grace.getDynamic());
            this.addAttribute(nodeGrace, "transition", (String)this.mapWriteTransition.get(grace.getTransition()));
            this.addAttributeBool(nodeGrace, "onBeat", grace.isOnBeat());
            this.addAttributeBool(nodeGrace, "dead", grace.isDead());
        }
        if (effect.isTrill()) {
            Node nodeTrill = this.addNode(nodeNote, "trill");
            this.addAttributeInt(nodeTrill, "fret", effect.getTrill().getFret());
            this.addAttributeInt(nodeTrill, "duration", effect.getTrill().getDuration().getValue());
        }
        if (effect.isTremoloPicking()) {
            Node nodeTremoloPicking = this.addNode(nodeNote, "tremoloPicking");
            this.addAttributeInt(nodeTremoloPicking, "duration", effect.getTremoloPicking().getDuration().getValue());
        }
        if (note.isAltEnharmonic()) {
            this.addNode(nodeNote, "alternativeEnharmonic");
        }
        this.addAttributeInt(nodeNote, "value", note.getValue());
        this.addAttributeInt(nodeNote, "string", note.getString());
        if (note.isTiedNote()) {
            this.addAttributeBool(nodeNote, "tiedNote", true);
        }
        if (previousNote == null || previousNote.getVelocity() != note.getVelocity()) {
            this.addAttributeInt(nodeNote, "velocity", note.getVelocity());
        }
    }

    private void addVersion(OutputStream stream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
        writer.write("TuxGuitar_file_format " + FILE_FORMAT_TGVERSION.toString());
        writer.flush();
    }

    private void saveDocument(OutputStream stream) {
        try {
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            DOMSource input = new DOMSource(this.document);
            StreamResult output = new StreamResult(stream);
            idTransform.setOutputProperty("indent", "no");
            idTransform.transform(input, output);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private Node addAttribute(Node node, String name, String content) {
        Attr attribute = this.document.createAttribute(name);
        attribute.setNodeValue(content);
        node.getAttributes().setNamedItem(attribute);
        return node;
    }

    private Node addAttributeInt(Node node, String name, int value) {
        return this.addAttribute(node, name, String.valueOf(value));
    }

    private Node addAttributeBool(Node node, String name, boolean value) {
        return this.addAttribute(node, name, value ? "true" : "false");
    }

    private Node addNode(Node parent, String name) {
        Element node = this.document.createElement(name);
        parent.appendChild(node);
        return node;
    }

    private Node addNode(Node parent, String name, String content) {
        Node node = this.addNode(parent, name);
        node.setTextContent(content);
        return node;
    }

    private Node addNodeInt(Node parent, String name, int value) {
        return this.addNode(parent, name, String.valueOf(value));
    }

    private Node addNodeLong(Node parent, String name, long value) {
        return this.addNode(parent, name, String.valueOf(value));
    }

    private Document newDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            return document;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }
}

