/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.sequencer;

import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.base.MidiSequenceHandler;
import app.tuxguitar.player.base.MidiSequencer;
import app.tuxguitar.player.base.MidiTransmitter;
import app.tuxguitar.player.impl.sequencer.MidiEvent;
import app.tuxguitar.player.impl.sequencer.MidiEventDispacher;
import app.tuxguitar.player.impl.sequencer.MidiEventPlayer;
import app.tuxguitar.player.impl.sequencer.MidiSequenceHandlerImpl;
import app.tuxguitar.player.impl.sequencer.MidiTickPlayer;
import app.tuxguitar.player.impl.sequencer.MidiTrackController;
import app.tuxguitar.thread.TGThreadHandler;
import app.tuxguitar.thread.TGThreadLoop;
import app.tuxguitar.thread.TGThreadManager;
import app.tuxguitar.thread.TGThreadPriority;
import app.tuxguitar.util.TGContext;

public class MidiSequencerImpl
implements MidiSequencer {
    private boolean reset;
    private boolean running = false;
    private boolean stopped = true;
    private Object lock;
    private TGContext context;
    private MidiTransmitter transmitter;
    private MidiTickPlayer midiTickPlayer;
    private MidiEventPlayer midiEventPlayer;
    private MidiEventDispacher midiEventDispacher;
    private MidiTrackController midiTrackController;

    public MidiSequencerImpl(TGContext context) {
        this.context = context;
        this.lock = new Object();
        this.midiTickPlayer = new MidiTickPlayer();
        this.midiEventPlayer = new MidiEventPlayer(this);
        this.midiEventDispacher = new MidiEventDispacher(this);
        this.midiTrackController = new MidiTrackController(this);
    }

    @Override
    public MidiSequenceHandler createSequence(int tracks) throws MidiPlayerException {
        return new MidiSequenceHandlerImpl(this, tracks);
    }

    @Override
    public void check() {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() throws MidiPlayerException {
        if (this.isRunning()) {
            this.stop();
        }
    }

    @Override
    public void stop() throws MidiPlayerException {
        this.setRunning(false);
    }

    @Override
    public void start() throws MidiPlayerException {
        this.setRunning(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            this.getTransmitter().sendAllNotesOff();
            this.getTransmitter().sendPitchBendReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(MidiEvent event) throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.reset) {
                this.midiEventDispacher.dispatch(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(MidiEvent event) {
        Object object = this.lock;
        synchronized (object) {
            this.midiEventPlayer.addEvent(event);
            this.midiTickPlayer.notifyTick(event.getTick());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process() throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            boolean running = this.isRunning();
            if (running) {
                if (this.reset) {
                    this.reset();
                    this.reset = false;
                    this.midiEventPlayer.reset();
                }
                this.stopped = false;
                this.midiTickPlayer.process();
                this.midiEventPlayer.process();
                if (this.getTickPosition() > this.getTickLength()) {
                    this.stop();
                }
            } else if (!this.stopped) {
                this.stopped = true;
                this.midiEventPlayer.clearEvents();
                this.midiTickPlayer.clearTick();
                this.reset();
            }
            return running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean running) throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            this.running = running;
            if (this.running) {
                this.setTempo(120);
                this.setTickPosition(this.getTickPosition());
                new MidiTimer(this).start();
            } else {
                this.process();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTempo(int tempo) {
        Object object = this.lock;
        synchronized (object) {
            this.midiTickPlayer.setTempo(tempo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTickPosition(long tickPosition) {
        Object object = this.lock;
        synchronized (object) {
            this.reset = true;
            this.midiTickPlayer.setTick(tickPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSolo(int index, boolean solo) throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            this.getMidiTrackController().setSolo(index, solo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMute(int index, boolean mute) throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            this.getMidiTrackController().setMute(index, mute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransmitter(MidiTransmitter transmitter) {
        Object object = this.lock;
        synchronized (object) {
            this.transmitter = transmitter;
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public MidiTrackController getMidiTrackController() {
        return this.midiTrackController;
    }

    @Override
    public long getTickPosition() {
        return this.midiTickPlayer.getTick();
    }

    @Override
    public long getTickLength() {
        return this.midiTickPlayer.getTickLength();
    }

    public MidiTransmitter getTransmitter() {
        return this.transmitter;
    }

    @Override
    public String getKey() {
        return "tuxguitar.sequencer";
    }

    @Override
    public String getName() {
        return "TuxGuitar Sequencer";
    }

    public TGContext getContext() {
        return this.context;
    }

    private class MidiTimer
    implements Runnable {
        private static final long TIMER_DELAY = 10L;
        private MidiSequencerImpl sequencer;
        private TGThreadHandler threadHandler;

        public MidiTimer(MidiSequencerImpl sequencer) {
            this.sequencer = sequencer;
            this.threadHandler = TGThreadManager.getInstance(this.sequencer.getContext());
        }

        @Override
        public void run() {
            this.threadHandler.loop(new TGThreadLoop(){

                @Override
                public Long process() {
                    return MidiTimer.this.processLoop() ? 10L : BREAK;
                }
            });
        }

        public boolean processLoop() {
            try {
                return this.sequencer.process();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return false;
            }
        }

        public void start() {
            this.threadHandler.start(TGThreadPriority.HIGH, this);
        }
    }
}

