/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.helpers;

import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;

public class TGMeasureError {
    public static final int OK = 0;
    public static final int TYPE_VOICE_DURATION_ERROR = 1;
    public static final int VOICE_DISCONTINUOUS = 1;
    public static final int VOICE_OVERLAP = 2;
    public static final int VOICE_EARLY_START = 4;
    public static final int VOICE_TOO_SHORT = 8;
    public static final int VOICE_TOO_LONG = 16;
    public static final int TYPE_TIED_NOTE_ERROR = 2;
    private int errorType;
    private TGMeasure measure;
    private int voiceIndex;
    private int errCode;
    private TGNote invalidTiedNote;

    public TGMeasureError(TGMeasure measure, int voiceIndex, int errCode) {
        this.errorType = 1;
        this.measure = measure;
        this.voiceIndex = voiceIndex;
        this.errCode = errCode;
    }

    public TGMeasureError(TGMeasure measure, TGNote invalidTiedNote) {
        this.errorType = 2;
        this.measure = measure;
        this.invalidTiedNote = invalidTiedNote;
        this.voiceIndex = invalidTiedNote.getVoice().getIndex();
    }

    public int getErrorType() {
        return this.errorType;
    }

    public TGMeasure getMeasure() {
        return this.measure;
    }

    public int getVoiceIndex() {
        return this.voiceIndex;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public TGNote getInvalidTiedNote() {
        return this.invalidTiedNote;
    }

    public boolean isEqualTo(TGMeasureError err) {
        if (err == null) {
            return false;
        }
        return this.measure.equals(err.getMeasure()) && this.voiceIndex == err.getVoiceIndex() && this.errCode == err.getErrCode();
    }

    public boolean canBeFixed() {
        if (this.errorType == 2) {
            return true;
        }
        int code = this.errCode;
        return (code ^= code & 0x1A) == 0;
    }
}

