/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.managers;

import app.tuxguitar.graphics.control.TGDrumMap;
import app.tuxguitar.song.helpers.TGMeasureError;
import app.tuxguitar.song.managers.TGMeasureManager;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGColor;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TGTrackManager {
    private TGSongManager songManager;

    public TGTrackManager(TGSongManager songManager) {
        this.songManager = songManager;
    }

    public TGSongManager getSongManager() {
        return this.songManager;
    }

    public TGMeasure getFirstMeasure(TGTrack track) {
        TGMeasure firstMeasure = null;
        Iterator<TGMeasure> measures = track.getMeasures();
        while (measures.hasNext()) {
            TGMeasure currMeasure = measures.next();
            if (firstMeasure != null && currMeasure.getStart() >= firstMeasure.getStart()) continue;
            firstMeasure = currMeasure;
        }
        return firstMeasure;
    }

    public TGMeasure getLastMeasure(TGTrack track) {
        return track.getMeasure(track.countMeasures() - 1);
    }

    public TGMeasure getPrevMeasure(TGMeasure measure) {
        return measure.getTrack().getMeasure(measure.getNumber() - 2);
    }

    public TGMeasure getNextMeasure(TGMeasure measure) {
        return measure.getTrack().getMeasure(measure.getNumber());
    }

    public TGNote getNextTiedNote(TGNote note) {
        TGVoice nextVoice = this.getSongManager().getMeasureManager().getNextVoice(note.getVoice().getBeat().getMeasure().getBeats(), note.getVoice().getBeat(), note.getVoice().getIndex());
        if (nextVoice == null) {
            TGMeasure nextMeasure = this.getNextMeasure(note.getVoice().getBeat().getMeasure());
            if (nextMeasure == null) {
                return null;
            }
            nextVoice = this.getSongManager().getMeasureManager().getFirstVoice(nextMeasure.getBeats(), note.getVoice().getIndex());
        }
        if (nextVoice == null) {
            return null;
        }
        TGNote nextTiedNote = null;
        for (TGNote nextNote : nextVoice.getNotes()) {
            if (!nextNote.isTiedNote() || nextNote.getString() != note.getString() || nextNote.getValue() != note.getValue()) continue;
            nextTiedNote = nextNote;
            break;
        }
        return nextTiedNote;
    }

    public TGNote getPreviousNoteForTie(TGNote note) {
        return this.getPreviousNoteForTie(note.getVoice(), note.getString(), note.getValue());
    }

    public TGNote getPreviousNoteForTie(TGVoice voice, int string, Integer value) {
        TGVoice previousVoice = this.getSongManager().getMeasureManager().getPreviousVoice(voice.getBeat().getMeasure().getBeats(), voice.getBeat(), voice.getIndex());
        if (previousVoice == null) {
            TGMeasure previousMeasure = this.getPrevMeasure(voice.getBeat().getMeasure());
            if (previousMeasure == null) {
                return null;
            }
            previousVoice = this.getSongManager().getMeasureManager().getLastVoice(previousMeasure.getBeats(), voice.getIndex());
        }
        if (previousVoice == null) {
            return null;
        }
        TGNote previousNoteForTie = null;
        for (TGNote previousNote : previousVoice.getNotes()) {
            if (previousNote.getString() != string || value != null && previousNote.getValue() != value.intValue()) continue;
            previousNoteForTie = previousNote;
            break;
        }
        return previousNoteForTie;
    }

    public boolean isAnyTiedTo(TGNote note) {
        return this.getNextTiedNote(note) != null;
    }

    public TGMeasure getMeasureAt(TGTrack track, long start) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            long measureStart = measure.getStart();
            long measureLength = measure.getLength();
            if (start < measureStart || start >= measureStart + measureLength) continue;
            return measure;
        }
        return null;
    }

    public TGMeasure getMeasureAtPreciseStart(TGTrack track, long preciseStart) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            long measurePreciseStart = measure.getPreciseStart();
            long measurePreciseLength = measure.getPreciseLength();
            if (preciseStart < measurePreciseStart || preciseStart >= measurePreciseStart + measurePreciseLength) continue;
            return measure;
        }
        return null;
    }

    public TGMeasure getMeasure(TGTrack track, int number) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            if (measure.getNumber() != number) continue;
            return measure;
        }
        return null;
    }

    public List<TGMeasure> getMeasuresBeforeEnd(TGTrack track, long fromStart) {
        ArrayList<TGMeasure> measures = new ArrayList<TGMeasure>();
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure currMeasure = it.next();
            if (currMeasure.getStart() < fromStart) continue;
            measures.add(currMeasure);
        }
        return measures;
    }

    public List<TGMeasure> getMeasuresFrom(TGTrack track, long fromStart) {
        return this.getMeasuresBetween(track, fromStart, Long.MAX_VALUE);
    }

    public List<TGMeasure> getMeasuresBetween(TGTrack track, long p1, long p2) {
        ArrayList<TGMeasure> measures = new ArrayList<TGMeasure>();
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            if (measure.getStart() + measure.getLength() <= p1 || measure.getStart() >= p2) continue;
            measures.add(measure);
        }
        return measures;
    }

    public void addNewMeasureBeforeEnd(TGTrack track, TGMeasureHeader header) {
        this.addNewMeasureAfter(track, header, this.getLastMeasure(track));
    }

    public void addNewMeasureAfter(TGTrack track, TGMeasureHeader header, TGMeasure measure) {
        TGMeasure newMeasure = this.getSongManager().getFactory().newMeasure(header);
        newMeasure.setClef(measure.getClef());
        newMeasure.setKeySignature(measure.getKeySignature());
        this.addMeasure(track, newMeasure);
    }

    public void addNewMeasure(TGTrack track, TGMeasureHeader header) {
        TGMeasure previous = this.getMeasure(track, header.getNumber() == 1 ? header.getNumber() + 1 : header.getNumber() - 1);
        TGMeasure newMeasure = this.getSongManager().getFactory().newMeasure(header);
        this.getSongManager().getMeasureManager().autoCompleteSilences(newMeasure);
        newMeasure.setTrack(track);
        newMeasure.setClef(previous.getClef());
        newMeasure.setKeySignature(previous.getKeySignature());
        this.addMeasure(track, header.getNumber() - 1, newMeasure);
    }

    public void addMeasure(TGTrack track, TGMeasure measure) {
        track.addMeasure(measure);
    }

    public void addMeasure(TGTrack track, int index, TGMeasure measure) {
        track.addMeasure(index, measure);
    }

    public void removeMeasure(TGTrack track, long start) {
        this.removeMeasure(this.getMeasureAt(track, start));
    }

    public void removeMeasure(TGMeasure measure) {
        measure.getTrack().removeMeasure(measure.getNumber() - 1);
    }

    public void copyMeasureFrom(TGMeasure measure, TGMeasure from) {
        measure.copyFrom(this.getSongManager().getFactory(), from);
    }

    public TGMeasure replaceMeasure(TGTrack track, TGMeasure newMeasure) {
        TGMeasure tgMeasure = this.getMeasureAt(track, newMeasure.getStart());
        this.copyMeasureFrom(tgMeasure, newMeasure);
        return tgMeasure;
    }

    public void moveMeasure(TGMeasure measure, long theMove) {
        this.getSongManager().getMeasureManager().moveAllBeats(measure, theMove);
    }

    public void moveOutOfBoundsBeatsToNewMeasure(TGTrack track, long start) {
        for (TGMeasure measure : this.getMeasuresFrom(track, start)) {
            this.getSongManager().getMeasureManager().moveOutOfBoundsBeatsToNewMeasure(measure);
        }
    }

    public void moveTrackBeats(TGTrack track, long measureStart, long moveStart, long theMove) {
        TGMeasure measure;
        int i;
        List<TGMeasure> measures = this.getMeasuresBeforeEnd(track, measureStart);
        for (i = 0; i < measures.size(); ++i) {
            measure = measures.get(i);
            if (moveStart + theMove < moveStart) {
                this.getSongManager().getMeasureManager().removeBeatsBetween(measure, moveStart, moveStart + Math.abs(theMove));
            }
            this.getSongManager().getMeasureManager().moveBeats(measure, moveStart, theMove);
        }
        for (i = 0; i < measures.size(); ++i) {
            measure = measures.get(i);
            this.getSongManager().getMeasureManager().moveOutOfBoundsBeatsToNewMeasure(measure, false);
        }
    }

    public List<TGBeat> replaceBeats(TGTrack track, List<TGBeat> beatsToInsert, long preciseStart) {
        ArrayList<TGBeat> updatedBeats = new ArrayList<TGBeat>();
        TGMeasureManager measureManager = this.getSongManager().getMeasureManager();
        Long nextUpdatePreciseStart = preciseStart;
        for (TGBeat beatToInsert : beatsToInsert) {
            TGBeat updatedBeat = null;
            TGMeasure updatedMeasure = null;
            if (nextUpdatePreciseStart == null) continue;
            TGMeasure startMeasure = this.getMeasureAtPreciseStart(track, nextUpdatePreciseStart);
            long updatePreciseStart = nextUpdatePreciseStart;
            nextUpdatePreciseStart = null;
            long clearedTime = 0L;
            long neededClearTime = measureManager.getMaximumDuration(beatToInsert).getPreciseTime();
            boolean enoughRoomAvailable = false;
            for (TGMeasure measure : this.getMeasuresBeforeEnd(track, startMeasure.getStart())) {
                if (enoughRoomAvailable) continue;
                for (TGBeat beat : measureManager.getBeatsBeforeEndPrecise(measure.getBeats(), updatePreciseStart)) {
                    if (enoughRoomAvailable) continue;
                    if (updatedBeat == null) {
                        updatedBeat = beat;
                        updatedMeasure = measure;
                    }
                    for (int i = 0; i < beat.countVoices(); ++i) {
                        beat.getVoice(i).clearNotes();
                    }
                    enoughRoomAvailable = (clearedTime += measureManager.getMinimumDuration(beat).getPreciseTime()) >= neededClearTime;
                }
            }
            if (!enoughRoomAvailable) continue;
            for (int i = 0; i < beatToInsert.countVoices(); ++i) {
                if (beatToInsert.getVoice(i).isEmpty()) continue;
                measureManager.changeDuration(updatedMeasure, updatedBeat, beatToInsert.getVoice(i).getDuration(), i, true);
            }
            long updatedPreciseStart = updatedBeat.getPreciseStart();
            updatedBeat.copyFrom(beatToInsert, this.songManager.getFactory());
            updatedBeat.setPreciseStart(updatedPreciseStart);
            measureManager.removeOverlappingRestBeats(updatedMeasure);
            measureManager.moveOutOfBoundsBeatsToNewMeasure(updatedMeasure);
            updatedBeats.add(updatedBeat);
            startMeasure = this.getMeasureAtPreciseStart(track, updatedBeat.getPreciseStart());
            long expectedPreciseStart = updatedBeat.getPreciseStart() + measureManager.getMinimumDuration(beatToInsert).getPreciseTime();
            boolean found = false;
            block5: for (TGMeasure measure : this.getMeasuresBeforeEnd(track, startMeasure.getStart())) {
                measureManager.autoCompleteSilences(measure);
                measureManager.removeOverlappingRestBeats(measure);
                if (found) continue;
                for (TGBeat beat : measureManager.getBeatsBeforeEndPrecise(measure.getBeats(), updatedBeat.getPreciseStart())) {
                    if (beat.getPreciseStart() < expectedPreciseStart) continue;
                    nextUpdatePreciseStart = beat.getPreciseStart();
                    found = true;
                    continue block5;
                }
            }
        }
        return updatedBeats;
    }

    public void changeKeySignature(TGTrack track, TGMeasure measure, int keySignature, boolean toEnd) {
        measure.setKeySignature(keySignature);
        measure.resetAltEnharmonic();
        if (toEnd) {
            List<TGMeasure> measures = this.getMeasuresBeforeEnd(track, measure.getStart() + 1L);
            for (TGMeasure nextMeasure : measures) {
                nextMeasure.setKeySignature(keySignature);
                nextMeasure.resetAltEnharmonic();
            }
        }
    }

    public void changeKeySignature(TGTrack track, List<TGMeasure> measures, int keySignature) {
        for (TGMeasure measure : measures) {
            measure.setKeySignature(keySignature);
            measure.resetAltEnharmonic();
        }
    }

    public void changeClef(TGTrack track, TGMeasure measure, int clef, boolean toEnd) {
        measure.setClef(clef);
        if (toEnd) {
            List<TGMeasure> measures = this.getMeasuresBeforeEnd(track, measure.getStart() + 1L);
            for (TGMeasure nextMeasure : measures) {
                nextMeasure.setClef(clef);
            }
        }
    }

    public void changeSolo(TGTrack track, boolean solo) {
        track.setSolo(solo);
        track.setMute(track.isSolo() ? false : track.isMute());
    }

    public void changeMute(TGTrack track, boolean mute) {
        track.setMute(mute);
        track.setSolo(track.isMute() ? false : track.isSolo());
    }

    public void changeInfo(TGTrack track, String name, TGColor color, int offset, int maxFret) {
        this.changeInfo(track, name, color, offset);
        this.removeNotesAfterFret(track, maxFret);
        track.setMaxFret(maxFret);
    }

    public void changeInfo(TGTrack track, String name, TGColor color, int offset) {
        track.setName(name);
        track.setOffset(offset);
        track.getColor().copyFrom(color);
    }

    public void changeOffset(TGTrack track, int offset) {
        track.setOffset(offset);
    }

    public void changeStringCount(TGTrack track, int count) {
        if (track.stringCount() != count) {
            if (count < track.getStrings().size()) {
                this.removeNotesAfterString(track, count);
            }
            if (track.isPercussion()) {
                track.setStrings(this.getSongManager().createPercussionStrings(count));
            } else {
                track.setStrings(this.getSongManager().createDefaultInstrumentStrings(count));
            }
        }
    }

    public void removeNotesAfterString(TGTrack track, int string) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.getSongManager().getMeasureManager().removeNotesAfterString(measure, string);
        }
    }

    public void removeNotesAfterFret(TGTrack track, int fret) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.getSongManager().getMeasureManager().removeNotesAfterFret(measure, fret);
        }
    }

    public void changeChannel(TGTrack track, TGChannel channel) {
        boolean newPercussion;
        TGChannel oldChannel = this.getSongManager().getChannel(track.getSong(), track.getChannelId());
        track.setChannelId(channel != null ? channel.getChannelId() : -1);
        boolean oldPercussion = oldChannel != null && oldChannel.isPercussionChannel();
        boolean bl = newPercussion = channel != null && channel.isPercussionChannel();
        if (oldPercussion != newPercussion) {
            if (newPercussion) {
                track.setStrings(this.getSongManager().createPercussionStrings(track.stringCount()));
            } else {
                track.setStrings(this.getSongManager().createDefaultInstrumentStrings(track.stringCount()));
            }
        }
    }

    public void autoCompleteSilences(TGTrack track) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.songManager.getMeasureManager().autoCompleteSilences(measure);
        }
    }

    public void orderBeats(TGTrack track) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.songManager.getMeasureManager().orderBeats(measure);
        }
    }

    public void allocateNotesToStrings(List<Integer> fromStringValues, TGTrack track, List<TGString> toStrings) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            this.allocateMeasureNotesToStrings(fromStringValues, it.next(), toStrings, track.getMaxFret());
        }
    }

    public void allocateMeasureNotesToStrings(List<Integer> fromStringValues, List<TGMeasure> measures, List<TGString> toStrings, int maxFret) {
        ArrayList<TGBeat> beats = new ArrayList<TGBeat>();
        for (TGMeasure measure : measures) {
            beats.addAll(measure.getBeats());
        }
        this.allocateNotesToStrings(fromStringValues, beats, toStrings, maxFret);
    }

    public void allocateMeasureNotesToStrings(List<Integer> fromStringValues, TGMeasure measure, List<TGString> toStrings, int maxFret) {
        this.allocateNotesToStrings(fromStringValues, measure.getBeats(), toStrings, maxFret);
    }

    public void allocateNotesToStrings(List<Integer> fromStringValues, List<TGBeat> beats, List<TGString> toStrings, int maxFret) {
        if (fromStringValues == null || fromStringValues.isEmpty() || beats == null || beats.isEmpty() || toStrings == null || toStrings.isEmpty()) {
            return;
        }
        if (!this.tuningChanged(fromStringValues, toStrings)) {
            return;
        }
        for (TGBeat beat : beats) {
            beat.removeChord();
            this.allocateNotesToStrings(fromStringValues, beat, toStrings, maxFret);
        }
    }

    private void allocateNotesToStrings(List<Integer> fromStringValues, TGBeat beat, List<TGString> toStrings, int maxFret) {
        if (!this.allocateNotesToClosestString(fromStringValues, beat, toStrings, maxFret)) {
            this.allocateNotesToLowestFret(fromStringValues, beat, toStrings, maxFret);
        }
    }

    private boolean allocateNotesToClosestString(List<Integer> fromStringValues, TGBeat beat, List<TGString> toStrings, int maxFret) {
        int voiceIndex;
        boolean oldTuningIsValid = true;
        for (int stringValue : fromStringValues) {
            oldTuningIsValid &= stringValue != 0;
        }
        if (!oldTuningIsValid) {
            return false;
        }
        ArrayList<TGString> freeStrings = new ArrayList<TGString>(toStrings);
        TGBeat newBeat = beat.clone(this.getSongManager().getFactory());
        boolean ok = true;
        block1: for (voiceIndex = 0; voiceIndex < newBeat.countVoices(); ++voiceIndex) {
            TGVoice voice = newBeat.getVoice(voiceIndex);
            if (!ok) continue;
            for (TGNote note : voice.getNotes()) {
                int noteStringValue = fromStringValues.get(note.getString() - 1);
                int minDistance = -1;
                TGString closestString = null;
                for (TGString string : toStrings) {
                    int distance = Math.abs(noteStringValue - string.getValue());
                    if (minDistance >= 0 && distance >= minDistance) continue;
                    closestString = string;
                    minDistance = distance;
                }
                if (freeStrings.contains(closestString)) {
                    int newFret = noteStringValue + note.getValue() - closestString.getValue();
                    boolean canMove = newFret >= 0 && newFret <= maxFret;
                    int newGraceFret = 0;
                    if (note.getEffect().isGrace()) {
                        newGraceFret = noteStringValue + note.getEffect().getGrace().getFret() - closestString.getValue();
                        canMove &= newGraceFret >= 0 && newGraceFret <= maxFret;
                    }
                    if (canMove) {
                        note.setValue(newFret);
                        note.setString(closestString.getNumber());
                        if (note.getEffect().isGrace()) {
                            note.getEffect().getGrace().setFret(newGraceFret);
                        }
                        freeStrings.remove(closestString);
                        continue;
                    }
                    ok = false;
                    continue block1;
                }
                ok = false;
                continue block1;
            }
        }
        if (ok) {
            for (voiceIndex = 0; voiceIndex < newBeat.countVoices(); ++voiceIndex) {
                beat.setVoice(voiceIndex, newBeat.getVoice(voiceIndex));
            }
        }
        return ok;
    }

    private void allocateNotesToLowestFret(List<Integer> fromStringValues, TGBeat beat, List<TGString> toStrings, int maxFret) {
        ArrayList<TGString> freeStrings = new ArrayList<TGString>(toStrings);
        for (int i = 0; i < beat.countVoices(); ++i) {
            TGVoice voice = beat.getVoice(i);
            List<TGNote> listNotes = voice.getNotes();
            this.moveNotesToStringZero(fromStringValues, listNotes);
            Collections.sort(listNotes);
            Collections.reverse(listNotes);
            for (TGNote note : listNotes) {
                int minFret = -1;
                TGString newString = null;
                for (TGString string : freeStrings) {
                    boolean canMove;
                    int fret = note.getValue() - string.getValue();
                    boolean bl = canMove = fret >= 0 && fret <= maxFret;
                    if (note.getEffect().isGrace()) {
                        int graceFret = note.getEffect().getGrace().getFret() - string.getValue();
                        canMove &= graceFret >= 0 & graceFret <= maxFret;
                    }
                    if (!canMove || minFret >= 0 && fret >= minFret) continue;
                    newString = string;
                    minFret = fret;
                }
                if (newString == null) continue;
                note.setValue(note.getValue() - newString.getValue());
                note.setString(newString.getNumber());
                if (note.getEffect().isGrace()) {
                    note.getEffect().getGrace().setFret(note.getEffect().getGrace().getFret() - newString.getValue());
                }
                freeStrings.remove(newString);
            }
            this.removeUnallocatedNotes(voice);
        }
    }

    public void allocatePercussionNotesToStrings(List<Integer> fromStringValues, List<TGBeat> beats, List<TGString> toStrings) {
        TGDrumMap drumMap = new TGDrumMap();
        for (TGBeat beat : beats) {
            ArrayList<TGString> freeStrings = new ArrayList<TGString>(toStrings);
            for (int i = 0; i < beat.countVoices(); ++i) {
                TGVoice voice = beat.getVoice(i);
                List<TGNote> listNotes = voice.getNotes();
                Collections.sort(listNotes, (a, b) -> drumMap.getPreferredStringNumber(a.getValue()) - drumMap.getPreferredStringNumber(b.getValue()));
                this.moveNotesToStringZero(fromStringValues, listNotes);
                for (TGNote note : listNotes) {
                    int preferred = drumMap.getPreferredStringNumber(note.getValue());
                    TGString newString = null;
                    for (TGString string : freeStrings) {
                        if (string.getNumber() != preferred) continue;
                        newString = string;
                        note.setString(preferred);
                        freeStrings.remove(newString);
                        break;
                    }
                    if (newString != null) continue;
                    int minDistance = -1;
                    for (TGString string : freeStrings) {
                        int distance = Math.abs(string.getNumber() - preferred);
                        if (distance > minDistance && minDistance >= 0) continue;
                        newString = string;
                        minDistance = distance;
                    }
                    if (newString == null) continue;
                    note.setString(newString.getNumber());
                    freeStrings.remove(newString);
                }
                this.removeUnallocatedNotes(voice);
            }
        }
    }

    private void moveNotesToStringZero(List<Integer> fromStringValues, List<TGNote> listNotes) {
        for (TGNote note : listNotes) {
            note.setValue(fromStringValues.get(note.getString() - 1) + note.getValue());
            if (note.getEffect().isGrace()) {
                note.getEffect().getGrace().setFret(fromStringValues.get(note.getString() - 1) + note.getEffect().getGrace().getFret());
            }
            note.setString(0);
        }
    }

    private void removeUnallocatedNotes(TGVoice voice) {
        ArrayList<TGNote> toRemove = new ArrayList<TGNote>();
        for (TGNote note : voice.getNotes()) {
            if (note.getString() != 0) continue;
            toRemove.add(note);
        }
        while (toRemove.size() > 0) {
            voice.removeNote((TGNote)toRemove.get(0));
            toRemove.remove(0);
        }
    }

    private boolean tuningChanged(List<Integer> fromStringValues, List<TGString> toStrings) {
        if (fromStringValues == null != (toStrings == null)) {
            return true;
        }
        if (fromStringValues == null) {
            return false;
        }
        if (fromStringValues.size() != toStrings.size()) {
            return true;
        }
        for (int i = 0; i < fromStringValues.size(); ++i) {
            if (toStrings.get(i).getNumber() != i + 1) {
                return true;
            }
            if (toStrings.get(i).getValue() == fromStringValues.get(i).intValue()) continue;
            return true;
        }
        return false;
    }

    public void transposeNotes(TGTrack track, int transposition, boolean tryKeepString, boolean applyToChords, int applyToString) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.songManager.getMeasureManager().transposeNotes(measure, transposition, tryKeepString, applyToChords, applyToString);
        }
    }

    public void transposeNotes(TGTrack track, int[] transpositionStrings, boolean tryKeepString, boolean applyToChords) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.songManager.getMeasureManager().transposeNotes(measure, transpositionStrings, tryKeepString, applyToChords);
        }
    }

    public boolean isFirstMeasure(TGMeasure measure) {
        return measure.getNumber() == 1;
    }

    public boolean isLastMeasure(TGMeasure measure) {
        return measure.getTrack().getSong().countMeasureHeaders() == measure.getNumber();
    }

    public boolean hasMeasureDurationError(TGTrack track) {
        TGMeasureManager measureManager = this.getSongManager().getMeasureManager();
        Iterator<TGMeasure> itMeasure = track.getMeasures();
        while (itMeasure.hasNext()) {
            for (TGMeasureError err : measureManager.getMeasureErrors(itMeasure.next())) {
                if (err.getErrorType() != 1) continue;
                return true;
            }
        }
        return false;
    }
}

