/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.models;

import app.tuxguitar.song.factory.TGFactory;

public abstract class TGDivisionType {
    public static final TGDivisionType[] DIVISION_TYPES = new TGDivisionType[]{TGDivisionType.newDivisionType(1, 1), TGDivisionType.newDivisionType(3, 2), TGDivisionType.newDivisionType(5, 4), TGDivisionType.newDivisionType(6, 4), TGDivisionType.newDivisionType(7, 4), TGDivisionType.newDivisionType(9, 8), TGDivisionType.newDivisionType(10, 8), TGDivisionType.newDivisionType(11, 8), TGDivisionType.newDivisionType(12, 8), TGDivisionType.newDivisionType(13, 8)};
    public static final TGDivisionType NORMAL = DIVISION_TYPES[0];
    private int enters = 1;
    private int times = 1;

    public int getEnters() {
        return this.enters;
    }

    public void setEnters(int enters) {
        this.enters = enters;
    }

    public int getTimes() {
        return this.times;
    }

    public void setTimes(int times) {
        this.times = times;
    }

    public long convertTime(long time) {
        return time * (long)this.times / (long)this.enters;
    }

    public boolean isEqual(TGDivisionType divisionType) {
        return divisionType.getEnters() == this.getEnters() && divisionType.getTimes() == this.getTimes();
    }

    public TGDivisionType clone(TGFactory factory) {
        TGDivisionType tgDivisionType = factory.newDivisionType();
        tgDivisionType.copyFrom(this);
        return tgDivisionType;
    }

    public void copyFrom(TGDivisionType divisionType) {
        this.setEnters(divisionType.getEnters());
        this.setTimes(divisionType.getTimes());
    }

    private static TGDivisionType newDivisionType(int enters, int times) {
        TGDivisionType divisionType = new TGFactory().newDivisionType();
        divisionType.setEnters(enters);
        divisionType.setTimes(times);
        return divisionType;
    }
}

