/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.models;

import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.effects.TGEffectBend;
import app.tuxguitar.song.models.effects.TGEffectGrace;
import app.tuxguitar.song.models.effects.TGEffectHarmonic;
import app.tuxguitar.song.models.effects.TGEffectTremoloBar;
import app.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import app.tuxguitar.song.models.effects.TGEffectTrill;

public abstract class TGNoteEffect {
    private TGEffectBend bend = null;
    private TGEffectTremoloBar tremoloBar = null;
    private TGEffectHarmonic harmonic = null;
    private TGEffectGrace grace = null;
    private TGEffectTrill trill = null;
    private TGEffectTremoloPicking tremoloPicking = null;
    private boolean vibrato = false;
    private boolean deadNote = false;
    private boolean slide = false;
    private boolean hammer = false;
    private boolean ghostNote = false;
    private boolean accentuatedNote = false;
    private boolean heavyAccentuatedNote = false;
    private boolean palmMute = false;
    private boolean staccato = false;
    private boolean tapping = false;
    private boolean slapping = false;
    private boolean popping = false;
    private boolean fadeIn = false;
    private boolean letRing = false;

    public boolean isDeadNote() {
        return this.deadNote;
    }

    public void setDeadNote(boolean deadNote) {
        this.deadNote = deadNote;
        if (this.isDeadNote()) {
            this.bend = null;
            this.trill = null;
            this.slide = false;
            this.hammer = false;
            this.tremoloBar = null;
            this.tremoloPicking = null;
        }
    }

    public boolean isVibrato() {
        return this.vibrato;
    }

    public void setVibrato(boolean vibrato) {
        this.vibrato = vibrato;
        if (this.isVibrato()) {
            this.trill = null;
            this.tremoloPicking = null;
        }
    }

    public TGEffectBend getBend() {
        return this.bend;
    }

    public void setBend(TGEffectBend bend) {
        this.bend = bend;
        if (this.isBend()) {
            this.trill = null;
            this.deadNote = false;
            this.slide = false;
            this.hammer = false;
            this.tremoloBar = null;
            this.tremoloPicking = null;
        }
    }

    public boolean isBend() {
        return this.bend != null && !this.bend.getPoints().isEmpty();
    }

    public TGEffectTremoloBar getTremoloBar() {
        return this.tremoloBar;
    }

    public void setTremoloBar(TGEffectTremoloBar tremoloBar) {
        this.tremoloBar = tremoloBar;
        if (this.isTremoloBar()) {
            this.bend = null;
            this.trill = null;
            this.deadNote = false;
            this.slide = false;
            this.hammer = false;
            this.tremoloPicking = null;
        }
    }

    public boolean isTremoloBar() {
        return this.tremoloBar != null;
    }

    public TGEffectTrill getTrill() {
        return this.trill;
    }

    public void setTrill(TGEffectTrill trill) {
        this.trill = trill;
        if (this.isTrill()) {
            this.bend = null;
            this.tremoloBar = null;
            this.tremoloPicking = null;
            this.slide = false;
            this.hammer = false;
            this.deadNote = false;
            this.vibrato = false;
        }
    }

    public boolean isTrill() {
        return this.trill != null;
    }

    public TGEffectTremoloPicking getTremoloPicking() {
        return this.tremoloPicking;
    }

    public void setTremoloPicking(TGEffectTremoloPicking tremoloPicking) {
        this.tremoloPicking = tremoloPicking;
        if (this.isTremoloPicking()) {
            this.trill = null;
            this.bend = null;
            this.tremoloBar = null;
            this.slide = false;
            this.hammer = false;
            this.deadNote = false;
            this.vibrato = false;
        }
    }

    public boolean isTremoloPicking() {
        return this.tremoloPicking != null;
    }

    public boolean isHammer() {
        return this.hammer;
    }

    public void setHammer(boolean hammer) {
        this.hammer = hammer;
        if (this.isHammer()) {
            this.trill = null;
            this.bend = null;
            this.deadNote = false;
            this.slide = false;
            this.tremoloBar = null;
            this.tremoloPicking = null;
        }
    }

    public boolean isSlide() {
        return this.slide;
    }

    public void setSlide(boolean slide) {
        this.slide = slide;
        if (this.isSlide()) {
            this.trill = null;
            this.bend = null;
            this.deadNote = false;
            this.hammer = false;
            this.tremoloBar = null;
            this.tremoloPicking = null;
        }
    }

    public boolean isGhostNote() {
        return this.ghostNote;
    }

    public void setGhostNote(boolean ghostNote) {
        this.ghostNote = ghostNote;
        if (this.isGhostNote()) {
            this.accentuatedNote = false;
            this.heavyAccentuatedNote = false;
        }
    }

    public boolean isAccentuatedNote() {
        return this.accentuatedNote;
    }

    public void setAccentuatedNote(boolean accentuatedNote) {
        this.accentuatedNote = accentuatedNote;
        if (this.isAccentuatedNote()) {
            this.ghostNote = false;
            this.heavyAccentuatedNote = false;
        }
    }

    public boolean isHeavyAccentuatedNote() {
        return this.heavyAccentuatedNote;
    }

    public void setHeavyAccentuatedNote(boolean heavyAccentuatedNote) {
        this.heavyAccentuatedNote = heavyAccentuatedNote;
        if (this.isHeavyAccentuatedNote()) {
            this.ghostNote = false;
            this.accentuatedNote = false;
        }
    }

    public void setHarmonic(TGEffectHarmonic harmonic) {
        this.harmonic = harmonic;
    }

    public TGEffectHarmonic getHarmonic() {
        return this.harmonic;
    }

    public boolean isHarmonic() {
        return this.harmonic != null;
    }

    public TGEffectGrace getGrace() {
        return this.grace;
    }

    public void setGrace(TGEffectGrace grace) {
        this.grace = grace;
    }

    public boolean isGrace() {
        return this.grace != null;
    }

    public boolean isPalmMute() {
        return this.palmMute;
    }

    public void setPalmMute(boolean palmMute) {
        this.palmMute = palmMute;
        if (this.isPalmMute()) {
            this.staccato = false;
            this.letRing = false;
        }
    }

    public boolean isStaccato() {
        return this.staccato;
    }

    public void setStaccato(boolean staccato) {
        this.staccato = staccato;
        if (this.isStaccato()) {
            this.palmMute = false;
            this.letRing = false;
        }
    }

    public boolean isLetRing() {
        return this.letRing;
    }

    public void setLetRing(boolean letRing) {
        this.letRing = letRing;
        if (this.isLetRing()) {
            this.staccato = false;
            this.palmMute = false;
        }
    }

    public boolean isPopping() {
        return this.popping;
    }

    public void setPopping(boolean popping) {
        this.popping = popping;
        if (this.isPopping()) {
            this.tapping = false;
            this.slapping = false;
        }
    }

    public boolean isSlapping() {
        return this.slapping;
    }

    public void setSlapping(boolean slapping) {
        this.slapping = slapping;
        if (this.isSlapping()) {
            this.tapping = false;
            this.popping = false;
        }
    }

    public boolean isTapping() {
        return this.tapping;
    }

    public void setTapping(boolean tapping) {
        this.tapping = tapping;
        if (this.isTapping()) {
            this.slapping = false;
            this.popping = false;
        }
    }

    public boolean isFadeIn() {
        return this.fadeIn;
    }

    public void setFadeIn(boolean fadeIn) {
        this.fadeIn = fadeIn;
    }

    public boolean hasAnyEffect() {
        return this.isBend() || this.isTremoloBar() || this.isHarmonic() || this.isGrace() || this.isTrill() || this.isTremoloPicking() || this.isVibrato() || this.isDeadNote() || this.isSlide() || this.isHammer() || this.isGhostNote() || this.isAccentuatedNote() || this.isHeavyAccentuatedNote() || this.isPalmMute() || this.isLetRing() || this.isStaccato() || this.isTapping() || this.isSlapping() || this.isPopping() || this.isFadeIn();
    }

    public TGNoteEffect clone(TGFactory factory) {
        TGNoteEffect effect = factory.newEffect();
        effect.setVibrato(this.isVibrato());
        effect.setDeadNote(this.isDeadNote());
        effect.setSlide(this.isSlide());
        effect.setHammer(this.isHammer());
        effect.setGhostNote(this.isGhostNote());
        effect.setAccentuatedNote(this.isAccentuatedNote());
        effect.setHeavyAccentuatedNote(this.isHeavyAccentuatedNote());
        effect.setPalmMute(this.isPalmMute());
        effect.setLetRing(this.isLetRing());
        effect.setStaccato(this.isStaccato());
        effect.setTapping(this.isTapping());
        effect.setSlapping(this.isSlapping());
        effect.setPopping(this.isPopping());
        effect.setFadeIn(this.isFadeIn());
        effect.setBend(this.isBend() ? this.bend.clone(factory) : null);
        effect.setTremoloBar(this.isTremoloBar() ? this.tremoloBar.clone(factory) : null);
        effect.setHarmonic(this.isHarmonic() ? this.harmonic.clone(factory) : null);
        effect.setGrace(this.isGrace() ? this.grace.clone(factory) : null);
        effect.setTrill(this.isTrill() ? this.trill.clone(factory) : null);
        effect.setTremoloPicking(this.isTremoloPicking() ? this.tremoloPicking.clone(factory) : null);
        return effect;
    }
}

