/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.models;

import app.tuxguitar.song.factory.TGFactory;

public abstract class TGTempo {
    private static final int SECOND_IN_MILLIS = 1000;
    private int quarterValue;
    private int rawValue;
    private int base;
    private boolean dotted;

    public TGTempo() {
        this.rawValue = this.quarterValue = 120;
        this.base = 4;
        this.dotted = false;
    }

    public int getQuarterValue() {
        return this.quarterValue;
    }

    public void setQuarterValue(int value) {
        this.setValueBase(value, 4, false);
    }

    public void setValueBase(int rawValue, int base, boolean dotted) {
        this.quarterValue = rawValue * 4 / base;
        if (dotted) {
            this.quarterValue = 3 * this.quarterValue / 2;
        }
        this.rawValue = rawValue;
        this.base = base;
        this.dotted = dotted;
    }

    public int getRawValue() {
        return this.rawValue;
    }

    public int getBase() {
        return this.base;
    }

    public boolean isDotted() {
        return this.dotted;
    }

    public long getInMillis() {
        double millis = 60.0 / (double)this.getQuarterValue() * 1000.0;
        return (long)millis;
    }

    public long getTicksInMillis(long ticks) {
        return 60000L * ticks / 960L / (long)this.getQuarterValue();
    }

    public long getInUSQ() {
        double usq = 60.0 / (double)this.getQuarterValue() * 1000.0 * 1000.0;
        return (long)usq;
    }

    public static TGTempo fromUSQ(TGFactory factory, int usq) {
        double value = 60000.0 / ((double)usq / 1000.0);
        TGTempo tempo = factory.newTempo();
        tempo.setValueBase((int)value, 4, false);
        return tempo;
    }

    public TGTempo clone(TGFactory factory) {
        TGTempo tgTempo = factory.newTempo();
        tgTempo.copyFrom(this);
        return tgTempo;
    }

    public void copyFrom(TGTempo tempo) {
        this.setValueBase(tempo.getRawValue(), tempo.getBase(), tempo.isDotted());
    }

    public boolean isEqual(TGTempo other) {
        return other.rawValue == this.rawValue && other.base == this.base && other.dotted == this.dotted;
    }
}

