/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.thread;

import app.tuxguitar.thread.TGThreadHandler;
import app.tuxguitar.thread.TGThreadLoop;
import app.tuxguitar.thread.TGThreadPriority;
import app.tuxguitar.util.TGException;

public class TGExclusiveThreadHandler
implements TGThreadHandler {
    @Override
    public void start(TGThreadPriority priority, Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setPriority(priority == TGThreadPriority.HIGH ? 10 : 5);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void loop(TGThreadLoop loop) {
        try {
            Object mutex = new Object();
            while (true) {
                Long timeout;
                if (TGThreadLoop.BREAK.equals(timeout = loop.process())) {
                    return;
                }
                if (timeout == null || timeout <= 0L) continue;
                Object object = mutex;
                synchronized (object) {
                    mutex.wait(timeout);
                }
            }
        }
        catch (InterruptedException e) {
            throw new TGException(e.getMessage(), e);
        }
    }

    @Override
    public void yield() {
        Thread.yield();
    }

    @Override
    public Object getThreadId() {
        return Thread.currentThread().getId();
    }

    @Override
    public void dispose() {
    }
}

