/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.util.error;

import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.error.TGErrorHandler;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.ArrayList;
import java.util.List;

public class TGErrorManager {
    private List<TGErrorHandler> errorHandlers = new ArrayList<TGErrorHandler>();

    private TGErrorManager() {
    }

    public void handleError(Throwable throwable) {
        for (TGErrorHandler tgErrorHandler : this.errorHandlers) {
            tgErrorHandler.handleError(throwable);
        }
    }

    public void addErrorHandler(TGErrorHandler errorHandler) {
        if (!this.errorHandlers.contains(errorHandler)) {
            this.errorHandlers.add(errorHandler);
        }
    }

    public void removeErrorHandler(TGErrorHandler errorHandler) {
        if (this.errorHandlers.contains(errorHandler)) {
            this.errorHandlers.remove(errorHandler);
        }
    }

    public List<TGErrorHandler> getErrorHandlers() {
        return this.errorHandlers;
    }

    public void clear() {
        this.errorHandlers.clear();
    }

    public static TGErrorManager getInstance(TGContext context) {
        return TGSingletonUtil.getInstance(context, TGErrorManager.class.getName(), new TGSingletonFactory<TGErrorManager>(){

            @Override
            public TGErrorManager createInstance(TGContext context) {
                return new TGErrorManager();
            }
        });
    }
}

