/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.tef3;

import app.tuxguitar.io.tef3.TGSongAdjuster;
import app.tuxguitar.io.tef3.base.TEChordDefinition;
import app.tuxguitar.io.tef3.base.TEComponentBase;
import app.tuxguitar.io.tef3.base.TEComponentChord;
import app.tuxguitar.io.tef3.base.TEComponentEnding;
import app.tuxguitar.io.tef3.base.TEComponentGraceNoteMetadata;
import app.tuxguitar.io.tef3.base.TEComponentNote;
import app.tuxguitar.io.tef3.base.TEComponentRest;
import app.tuxguitar.io.tef3.base.TEComponentTempoChange;
import app.tuxguitar.io.tef3.base.TEComponentTextEvent;
import app.tuxguitar.io.tef3.base.TELyrics;
import app.tuxguitar.io.tef3.base.TEMeasure;
import app.tuxguitar.io.tef3.base.TEPosition;
import app.tuxguitar.io.tef3.base.TESong;
import app.tuxguitar.io.tef3.base.TETimeSignature;
import app.tuxguitar.io.tef3.base.TETrack;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGLyric;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGNoteEffect;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTempo;
import app.tuxguitar.song.models.TGText;
import app.tuxguitar.song.models.TGTimeSignature;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.song.models.effects.TGEffectBend;
import app.tuxguitar.song.models.effects.TGEffectGrace;
import app.tuxguitar.song.models.effects.TGEffectHarmonic;
import app.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TESongParser {
    private static final int[][] PERCUSSION_TUNINGS = new int[][]{{49, 41, 32}, {49, 51, 42, 50}, {49, 42, 50, 37, 32}, {49, 51, 42, 50, 45, 37}, {49, 51, 42, 50, 45, 37, 41}};
    private TGSongManager manager;

    public TESongParser(TGFactory factory) {
        this.manager = new TGSongManager(factory);
    }

    public TGSong parseSong(TESong teSong) {
        TGSong tgSong = this.manager.newSong();
        this.addSongHeader(tgSong, teSong);
        this.addTracks(tgSong, teSong);
        this.addMeasures(tgSong, teSong);
        this.sortComponents(teSong);
        this.addComponents(tgSong, teSong);
        return new TGSongAdjuster(this.manager, tgSong).process();
    }

    private void addSongHeader(TGSong tgSong, TESong teSong) {
        tgSong.setName(teSong.getSongMetadata().getSongTitle());
        tgSong.setAuthor(teSong.getSongMetadata().getAuthorName());
        tgSong.setComments(teSong.getSongMetadata().getComments());
        tgSong.setCopyright(teSong.getSongMetadata().getCopyright());
    }

    private void addTracks(TGSong tgSong, TESong teSong) {
        int totalTeTracks = teSong.getTracks().size();
        while (tgSong.countTracks() < totalTeTracks) {
            this.manager.addTrack(tgSong);
        }
        this.manager.removeAllChannels(tgSong);
        for (int i = 0; i < totalTeTracks; ++i) {
            TGTrack tgTrack = tgSong.getTrack(i);
            TETrack teTrack = teSong.getTracks().get(i);
            TGChannel tgChannel = this.manager.addChannel(tgSong);
            tgChannel.setVolume((short)((15 - teTrack.getVolume()) * 127 / 15));
            tgChannel.setBalance((short)(teTrack.getPan() * 127 / 15));
            tgChannel.setProgram((short)teTrack.getMidiInstrument());
            tgChannel.setBank(teTrack.getIsPercussion() ? (short)128 : 0);
            tgChannel.setName(this.manager.createChannelNameFromProgram(tgSong, tgChannel));
            tgChannel.setChorus((short)(teSong.getFileMetadata().getToneChorus() << 8));
            tgChannel.setReverb((short)(teSong.getFileMetadata().getToneReverb() << 8));
            tgTrack.setChannelId(tgChannel.getChannelId());
            tgTrack.setOffset(teTrack.getCapo());
            tgTrack.setName(teTrack.getTrackName());
            for (TELyrics teLyrics : teSong.getSongMetadata().getLyrics()) {
                if (teLyrics.getTrackNumber() != i) continue;
                TGLyric tgLyrics = this.manager.getFactory().newLyric();
                tgLyrics.setFrom(1);
                tgLyrics.setLyrics(teLyrics.getLyrics());
                tgTrack.setLyrics(tgLyrics);
            }
            tgTrack.getStrings().clear();
            byte[] tuning = teTrack.getTuning();
            for (int stringIdx = 0; stringIdx < tuning.length && stringIdx < 7; ++stringIdx) {
                TGString string = this.manager.getFactory().newString();
                string.setNumber(stringIdx + 1);
                string.setValue(teTrack.getIsPercussion() ? 0 : 96 - tuning[stringIdx]);
                tgTrack.getStrings().add(string);
            }
        }
    }

    private void addMeasures(TGSong tgSong, TESong teSong) {
        int teTotalMeasures = teSong.getMeasures().size();
        this.manager.getFirstMeasureHeader(tgSong).getTempo().setQuarterValue(teSong.getFileMetadata().getInitialBpm());
        while (tgSong.countMeasureHeaders() < teTotalMeasures) {
            this.manager.addNewMeasureBeforeEnd(tgSong);
        }
        int tgTotalTracks = tgSong.countTracks();
        for (int measureIndex = 0; measureIndex < teTotalMeasures; ++measureIndex) {
            TGMeasureHeader tgMeasureHeader = tgSong.getMeasureHeader(measureIndex);
            TEMeasure teMeasure = teSong.getMeasures().get(measureIndex);
            TETimeSignature teTimeSignature = teMeasure.getTimeSignature();
            TGTimeSignature tgTimeSignature = this.manager.getFactory().newTimeSignature();
            tgTimeSignature.setNumerator(teTimeSignature.getNumerator());
            tgTimeSignature.getDenominator().setValue(teTimeSignature.getDenominator());
            this.manager.changeTimeSignature(tgSong, tgMeasureHeader, tgTimeSignature, false);
            block8: for (int trackIndex = 0; trackIndex < tgTotalTracks; ++trackIndex) {
                TGTrack tgTrack = tgSong.getTrack(trackIndex);
                TETrack teTrack = teSong.getTracks().get(trackIndex);
                TGMeasure tgMeasure = tgTrack.getMeasure(measureIndex);
                int teKeySignature = teMeasure.getKeySignature();
                if (teKeySignature < 0) {
                    teKeySignature = 7 - teKeySignature;
                }
                tgMeasure.setKeySignature(teKeySignature);
                switch (teTrack.getClef()) {
                    case TrebleClef: {
                        tgMeasure.setClef(1);
                        continue block8;
                    }
                    case BassClef: {
                        tgMeasure.setClef(2);
                        continue block8;
                    }
                    case TenorClef: {
                        tgMeasure.setClef(3);
                        continue block8;
                    }
                    case AltoClef: {
                        tgMeasure.setClef(4);
                        continue block8;
                    }
                    default: {
                        tgMeasure.setClef(1);
                    }
                }
            }
        }
    }

    private void addComponents(TGSong tgSong, TESong teSong) {
        List<TETrack> teTracks = teSong.getTracks();
        Iterator<TEComponentBase> it = teSong.getComponents().iterator();
        ArrayList<Object[]> lastNoteOnStrings = new ArrayList<Object[]>();
        for (int i = 0; i < teTracks.size(); ++i) {
            int stringCount = teTracks.get(i).getStringCount();
            Object[] noteList = new TGNote[stringCount];
            Arrays.fill(noteList, null);
            lastNoteOnStrings.add(noteList);
        }
        while (it.hasNext()) {
            int componentTrackIndex;
            TEComponentBase component = it.next();
            int measure = component.getPosition().getMeasure();
            if (measure < 0 || measure >= tgSong.countMeasureHeaders() || (componentTrackIndex = component.getPosition().getTrackIndex()) < 0 || componentTrackIndex >= teTracks.size()) continue;
            TGNote[] previousNotes = (TGNote[])lastNoteOnStrings.get(componentTrackIndex);
            TETrack teTrack = teTracks.get(componentTrackIndex);
            TGTrack tgTrack = tgSong.getTrack(componentTrackIndex);
            TGMeasure tgMeasure = tgTrack.getMeasure(measure);
            TGBeat tgBeat = this.getBeat(tgMeasure, this.getGridPosition(tgMeasure, component.getPosition()));
            if (component instanceof TEComponentNote) {
                TGNote tgNote;
                previousNotes[component.getPosition().getString()] = tgNote = this.addNote(teTrack, (TEComponentNote)component, tgBeat);
                continue;
            }
            if (component instanceof TEComponentChord) {
                this.addChord(teSong.getChordDefinitions(), (TEComponentChord)component, tgTrack, tgBeat);
                continue;
            }
            if (component instanceof TEComponentGraceNoteMetadata) {
                TGNote previousTgNote = previousNotes[component.getPosition().getString()];
                this.addGraceNoteMetadata(previousTgNote, (TEComponentGraceNoteMetadata)component);
                continue;
            }
            if (component instanceof TEComponentRest) {
                this.addRest((TEComponentRest)component, tgBeat);
                continue;
            }
            if (component instanceof TEComponentTextEvent) {
                this.addTextEvent(teSong, (TEComponentTextEvent)component, tgBeat);
                continue;
            }
            if (component instanceof TEComponentTempoChange) {
                this.addTempoChange((TEComponentTempoChange)component, tgSong, tgMeasure);
                continue;
            }
            if (!(component instanceof TEComponentEnding)) continue;
            this.addEnding((TEComponentEnding)component, tgMeasure);
        }
    }

    public void sortComponents(TESong song) {
        Collections.sort(song.getComponents(), new Comparator<TEComponentBase>(){

            @Override
            public int compare(TEComponentBase lhs, TEComponentBase rhs) {
                if (lhs == null || rhs == null) {
                    return 0;
                }
                if (lhs.getPosition().getMeasure() < rhs.getPosition().getMeasure()) {
                    return -1;
                }
                if (lhs.getPosition().getMeasure() > rhs.getPosition().getMeasure()) {
                    return 1;
                }
                if (lhs.getPosition().getPositionInMeasure() < rhs.getPosition().getPositionInMeasure()) {
                    return -1;
                }
                if (lhs.getPosition().getPositionInMeasure() > rhs.getPosition().getPositionInMeasure()) {
                    return 1;
                }
                if (lhs.getSortOrder() < rhs.getSortOrder()) {
                    return -1;
                }
                if (lhs.getSortOrder() > rhs.getSortOrder()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private TGBeat getBeat(TGMeasure measure, long start) {
        TGBeat beat = this.manager.getMeasureManager().getBeat(measure, start);
        if (beat == null) {
            beat = this.manager.getFactory().newBeat();
            beat.setStart(start);
            measure.addBeat(beat);
        }
        return beat;
    }

    private long getGridPosition(TGMeasure measure, TEPosition position) {
        long measureStart = measure.getStart();
        int positionInMeasure = position.getPositionInMeasure();
        float durationOfSixteenthNote = 0.25f;
        float sizePerGridPosition = 960.0f * durationOfSixteenthNote;
        long gridPosition = (long)((float)measureStart + sizePerGridPosition * (float)positionInMeasure);
        return gridPosition;
    }

    private TGDuration getDuration(int duration) {
        boolean isDoubleDotted;
        TGDuration tgDuration = this.manager.getFactory().newDuration();
        switch (duration) {
            case 20: 
            case 23: 
            case 26: 
            case 29: {
                tgDuration.setValue(16);
                return tgDuration;
            }
            case 21: 
            case 24: 
            case 27: 
            case 30: {
                tgDuration.setValue(64);
                return tgDuration;
            }
            case 31: {
                tgDuration.setValue(1);
                tgDuration.setDotted(true);
                return tgDuration;
            }
        }
        int durationOfSixtyFourthNote = 18;
        boolean bl = isDoubleDotted = duration > durationOfSixtyFourthNote;
        if (isDoubleDotted) {
            duration -= durationOfSixtyFourthNote;
            tgDuration.setDoubleDotted(true);
        }
        int value = 1;
        for (int i = 0; i < duration / 3; ++i) {
            value *= 2;
        }
        if (duration % 3 == 1) {
            value *= 2;
            if (!isDoubleDotted) {
                tgDuration.setDotted(true);
            }
        } else if (duration % 3 == 2) {
            tgDuration.getDivision().setEnters(3);
            tgDuration.getDivision().setTimes(2);
        }
        tgDuration.setValue(value);
        return tgDuration;
    }

    private int getVelocityFromDynamic(TEComponentNote.TEComponentNoteDynamics dynamic) {
        switch (dynamic) {
            case FFF: {
                return 127;
            }
            case FF: {
                return 111;
            }
            case F: {
                return 95;
            }
            case MF: {
                return 79;
            }
            case MP: {
                return 63;
            }
            case P: {
                return 47;
            }
            case PP: {
                return 31;
            }
            case PPP: {
                return 15;
            }
        }
        return 95;
    }

    private TGNote addNote(TETrack track, TEComponentNote teNote, TGBeat tgBeat) {
        int value = teNote.getFret();
        int string = teNote.getPosition().getString();
        if (track.getIsPercussion()) {
            int tuning = Math.min(track.getStringCount() - 2, PERCUSSION_TUNINGS.length) - 1;
            if (string >= 0 && string < PERCUSSION_TUNINGS[tuning].length) {
                value += PERCUSSION_TUNINGS[tuning][string];
            }
        }
        TGNote tgNote = this.manager.getFactory().newNote();
        tgNote.setString(string + 1);
        tgNote.setValue(value);
        tgNote.setVelocity(this.getVelocityFromDynamic(teNote.getDynamics()));
        this.addNoteEffects(tgNote, teNote);
        int voiceIndex = 0;
        switch (teNote.getAttributes()) {
            case UpperVoice: {
                voiceIndex = 0;
                break;
            }
            case LowerVoice: {
                voiceIndex = 1;
                break;
            }
        }
        TGDuration tgDuration = this.getDuration(teNote.getDuration().getValue());
        TGVoice tgVoice = tgBeat.getVoice(voiceIndex);
        switch (teNote.getStroke()) {
            case UpStroke: {
                tgBeat.getStroke().setDirection(1);
                tgBeat.getStroke().setValue(16);
                break;
            }
            case DownStroke: {
                tgBeat.getStroke().setDirection(-1);
                tgBeat.getStroke().setValue(16);
                break;
            }
        }
        tgVoice.getDuration().copyFrom(tgDuration);
        tgVoice.addNote(tgNote);
        return tgNote;
    }

    private void addNoteEffects(TGNote tgNote, TEComponentNote teNote) {
        TGEffectHarmonic harmonic;
        TGNoteEffect tgNoteEffect = tgNote.getEffect();
        if (teNote.getIsGraceNote()) {
            TGEffectGrace grace = this.manager.getFactory().newEffectGrace();
            grace.setFret(teNote.getGraceNoteFret());
            grace.setDynamic(this.getVelocityFromDynamic(teNote.getDynamics()));
            switch (teNote.getGraceNoteEffect()) {
                case GraceHammerOn: {
                    grace.setTransition(3);
                    break;
                }
                case GraceSlide: {
                    grace.setTransition(1);
                    break;
                }
                case GraceBendRelease: {
                    grace.setTransition(2);
                    break;
                }
                case GraceMordent: {
                    break;
                }
                case GraceDouble: {
                    break;
                }
                case GraceGruppetto: {
                    break;
                }
                case GraceTrill: {
                    break;
                }
            }
            tgNoteEffect.setGrace(grace);
        }
        switch (teNote.getEffect1()) {
            case HammerOn: 
            case PullOff: {
                tgNoteEffect.setHammer(true);
                break;
            }
            case Slide: {
                tgNoteEffect.setSlide(true);
                break;
            }
            case Choke: {
                break;
            }
            case Brush: {
                break;
            }
            case NaturalHarmonic: {
                harmonic = this.manager.getFactory().newEffectHarmonic();
                harmonic.setType(1);
                tgNoteEffect.setHarmonic(harmonic);
                break;
            }
            case ArtificialHarmonic: {
                harmonic = this.manager.getFactory().newEffectHarmonic();
                harmonic.setType(2);
                tgNoteEffect.setHarmonic(harmonic);
                break;
            }
            case PalmMute: {
                tgNoteEffect.setPalmMute(true);
                break;
            }
            case Tap: {
                tgNoteEffect.setTapping(true);
                break;
            }
            case Vibrato: {
                tgNoteEffect.setVibrato(true);
                break;
            }
            case Tremolo: {
                TGEffectTremoloPicking tremPicking = this.manager.getFactory().newEffectTremoloPicking();
                tgNoteEffect.setTremoloPicking(tremPicking);
                break;
            }
            case Bend: {
                TGEffectBend bend = this.manager.getFactory().newEffectBend();
                bend.addPoint(0, 0);
                bend.addPoint(6, 2);
                bend.addPoint(12, 2);
                tgNoteEffect.setBend(bend);
                break;
            }
            case BendRelease: {
                TGEffectBend bend = this.manager.getFactory().newEffectBend();
                bend.addPoint(0, 0);
                bend.addPoint(3, 2);
                bend.addPoint(6, 2);
                bend.addPoint(9, 0);
                bend.addPoint(12, 0);
                tgNote.getEffect().setBend(bend);
                break;
            }
            case Roll: {
                break;
            }
            case DeadNote: {
                tgNoteEffect.setDeadNote(true);
                break;
            }
        }
        switch (teNote.getEffect2()) {
            case LetRing: {
                tgNoteEffect.setLetRing(true);
                break;
            }
            case Slap: {
                tgNoteEffect.setSlapping(true);
                break;
            }
            case Rasgueado: {
                break;
            }
            case GhostNote: {
                tgNoteEffect.setGhostNote(true);
                break;
            }
            case TremUpOrDown: {
                break;
            }
            case TremDiveReturn: {
                break;
            }
            case Staccato: {
                tgNoteEffect.setStaccato(true);
                break;
            }
            case FadeIn: {
                tgNoteEffect.setFadeIn(true);
                break;
            }
            case FadeOut: {
                break;
            }
            case HideInNotation: {
                break;
            }
        }
        switch (teNote.getEffect3()) {
            case HammerOn: 
            case PullOff: {
                tgNoteEffect.setHammer(true);
                break;
            }
            case Roll: {
                break;
            }
            case Choke: {
                break;
            }
            case Brush: {
                break;
            }
            case NaturalHarmonic: {
                harmonic = this.manager.getFactory().newEffectHarmonic();
                harmonic.setType(1);
                tgNoteEffect.setHarmonic(harmonic);
                break;
            }
            case ArtificialHarmonic: {
                harmonic = this.manager.getFactory().newEffectHarmonic();
                harmonic.setType(2);
                tgNoteEffect.setHarmonic(harmonic);
                break;
            }
            case LetRing: {
                tgNoteEffect.setLetRing(true);
                break;
            }
            case GhostNote: {
                tgNoteEffect.setGhostNote(true);
                break;
            }
            case DeadNote: {
                tgNoteEffect.setDeadNote(true);
                break;
            }
            case Variation: {
                break;
            }
        }
        if (teNote.getIsTieUpward() || teNote.getIsTieDownward()) {
            tgNote.setTiedNote(true);
        }
        if (teNote.getDynamics() == TEComponentNote.TEComponentNoteDynamics.PPP) {
            tgNote.setTiedNote(true);
        }
    }

    private void addChord(List<TEChordDefinition> teChordDefinitions, TEComponentChord teChord, TGTrack tgTrack, TGBeat tgBeat) {
        int chordIndex = teChord.getChordIndex();
        if (chordIndex < 0 || chordIndex >= teChordDefinitions.size()) {
            return;
        }
        TEChordDefinition teChordDefinition = teChordDefinitions.get(chordIndex);
        int[] strings = teChordDefinition.getFrets();
        TGChord tgChord = this.manager.getFactory().newChord(tgTrack.stringCount());
        tgChord.setName(teChordDefinition.getName());
        for (int i = 0; i < tgChord.countStrings(); ++i) {
            int fret = strings[i];
            int value = i < strings.length ? fret : -1;
            tgChord.addFretValue(i, value);
        }
        if (tgChord.countNotes() <= 0) {
            return;
        }
        tgBeat.setChord(tgChord);
    }

    private void addGraceNoteMetadata(TGNote tgNote, TEComponentGraceNoteMetadata graceNoteMetadata) {
        TGEffectGrace graceEffect = tgNote.getEffect().getGrace();
        if (graceEffect == null) {
            graceEffect = this.manager.getFactory().newEffectGrace();
            tgNote.getEffect().setGrace(graceEffect);
        }
        if (graceNoteMetadata.getDoubleNoteOne() > 0) {
            graceEffect.setFret(graceNoteMetadata.getDoubleNoteOne());
        }
        switch (graceNoteMetadata.getDuration()) {
            case GraceThirtySecond: {
                graceEffect.setDuration(2);
                break;
            }
            case GraceSixteenth: {
                graceEffect.setDuration(3);
                break;
            }
            case GraceEighth: 
            case GraceQuarter: 
            case GraceHalf: {
                graceEffect.setDuration(3);
                break;
            }
        }
    }

    private void addRest(TEComponentRest teRest, TGBeat tgBeat) {
        int voiceIndex = 0;
        if (teRest.getIsLowerVoice()) {
            voiceIndex = 1;
        }
        TGVoice tgVoice = tgBeat.getVoice(voiceIndex);
        tgVoice.clearNotes();
    }

    private void addTextEvent(TESong teSong, TEComponentTextEvent teTextEvent, TGBeat tgBeat) {
        TGText tgText = this.manager.getFactory().newText();
        tgText.setBeat(tgBeat);
        int textIndex = teTextEvent.getTextIndex();
        List<String> textEvents = teSong.getSongMetadata().getTextEvents();
        if (textIndex < 0 || textIndex >= textEvents.size()) {
            return;
        }
        String teTextEventText = textEvents.get(textIndex);
        tgText.setValue(teTextEventText);
        tgBeat.setText(tgText);
    }

    private void addTempoChange(TEComponentTempoChange teTempoChange, TGSong tgSong, TGMeasure tgMeasure) {
        TGTempo newTempoEvent = this.manager.getFactory().newTempo();
        newTempoEvent.copyFrom(tgMeasure.getTempo());
        newTempoEvent.setQuarterValue(teTempoChange.getBpm());
        this.manager.changeTempos(tgSong, tgMeasure.getHeader(), newTempoEvent, true);
    }

    private void addEnding(TEComponentEnding teEnding, TGMeasure tgMeasure) {
        TGMeasureHeader measureHeader = tgMeasure.getHeader();
        if (teEnding.getIsOpenBracket()) {
            measureHeader.setRepeatOpen(true);
        }
        int endingNumber = teEnding.getEndingNumber();
        if (teEnding.getIsCloseBracket() && endingNumber >= 2) {
            measureHeader.setRepeatClose(endingNumber - 1);
        } else if (measureHeader.getRepeatClose() == 0 && endingNumber != 0) {
            measureHeader.setRepeatAlternative(1 << endingNumber - 1);
        }
    }
}

