/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.jsa.sequencer;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.base.MidiSequenceHandler;
import app.tuxguitar.player.base.MidiSequencer;
import app.tuxguitar.player.base.MidiTransmitter;
import app.tuxguitar.player.impl.jsa.sequencer.MidiReceiverImpl;
import app.tuxguitar.player.impl.jsa.sequencer.MidiSequenceHandlerImpl;
import app.tuxguitar.player.impl.jsa.sequencer.MidiSequenceLoader;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;

public class MidiSequencerImpl
implements MidiSequencer,
MidiSequenceLoader {
    private static final int TICK_MOVE = 1;
    private Object lock = new Object();
    private Sequencer sequencer;
    private Transmitter sequencerTransmitter;
    private MidiTransmitter transmitter;

    public MidiSequencerImpl(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    public synchronized void open() {
        try {
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
                this.closeTransmitter();
                this.openTransmitter();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void close() {
        try {
            if (this.sequencer.isOpen()) {
                this.sequencer.close();
                this.closeTransmitter();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void openTransmitter() {
        try {
            this.sequencerTransmitter = this.getSequencer().getTransmitter();
            this.sequencerTransmitter.setReceiver(new MidiReceiverImpl(this));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void closeTransmitter() {
        try {
            if (this.sequencerTransmitter != null) {
                this.sequencerTransmitter.close();
                this.sequencerTransmitter = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected Sequencer getSequencer(boolean open) {
        if (open) {
            this.open();
        }
        return this.sequencer;
    }

    protected Sequencer getSequencer() {
        return this.getSequencer(true);
    }

    public MidiSequenceHandler createSequence(int tracks) {
        this.resetTracks();
        return new MidiSequenceHandlerImpl(this, tracks);
    }

    public synchronized MidiTransmitter getTransmitter() {
        return this.transmitter;
    }

    public synchronized void setTransmitter(MidiTransmitter transmitter) {
        this.transmitter = transmitter;
    }

    public long getTickLength() {
        try {
            return this.getSequencer().getTickLength();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    public long getTickPosition() {
        try {
            return this.getSequencer().getTickPosition() + 1L;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    public void setTickPosition(long tickPosition) {
        try {
            this.getSequencer().setTickPosition(tickPosition - 1L);
            this.reset();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setMute(int index, boolean mute) {
        try {
            this.getSequencer().setTrackMute(index, mute);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSolo(int index, boolean solo) {
        try {
            this.getSequencer().setTrackSolo(index, solo);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setSequence(Sequence sequence) {
        try {
            this.getSequencer().setSequence(sequence);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void start() {
        try {
            this.setRunning(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.setRunning(false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isRunning() {
        try {
            return this.getSequencer(false) != null && this.getSequencer(false).isRunning();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean running) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (running && !this.isRunning()) {
                    this.getSequencer().start();
                } else if (!running && this.isRunning()) {
                    this.getSequencer().stop();
                    this.reset();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void reset() {
        try {
            this.getTransmitter().sendAllNotesOff();
            this.getTransmitter().sendPitchBendReset();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void resetTracks() {
        try {
            Track[] tracks;
            Sequence sequence = this.getSequencer().getSequence();
            if (sequence != null && (tracks = sequence.getTracks()) != null) {
                int count = tracks.length;
                for (int i = 0; i < count; ++i) {
                    this.setSolo(i, false);
                    this.setMute(i, false);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getKey() {
        return this.sequencer.getDeviceInfo().getName();
    }

    public String getName() {
        return this.sequencer.getDeviceInfo().getName();
    }

    public void check() throws MidiPlayerException {
        this.getSequencer(true);
        if (this.sequencer == null || !this.sequencer.isOpen()) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.midi.unavailable"));
        }
    }
}

