/*
 * Decompiled with CFR 0.152.
 */
package media.sound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import media.sound.ModelInstrumentComparator;
import media.sound.ModelPatch;

public class SimpleSoundbank
implements Soundbank {
    String name = "";
    String version = "";
    String vendor = "";
    String description = "";
    List<SoundbankResource> resources = new ArrayList<SoundbankResource>();
    List<Instrument> instruments = new ArrayList<Instrument>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public SoundbankResource[] getResources() {
        return this.resources.toArray(new SoundbankResource[this.resources.size()]);
    }

    @Override
    public Instrument[] getInstruments() {
        Instrument[] inslist_array = this.instruments.toArray(new Instrument[this.resources.size()]);
        Arrays.sort(inslist_array, new ModelInstrumentComparator());
        return inslist_array;
    }

    @Override
    public Instrument getInstrument(Patch patch) {
        int program = patch.getProgram();
        int bank = patch.getBank();
        boolean percussion = false;
        if (patch instanceof ModelPatch) {
            percussion = ((ModelPatch)patch).isPercussion();
        }
        for (Instrument instrument : this.instruments) {
            Patch patch2 = instrument.getPatch();
            int program2 = patch2.getProgram();
            int bank2 = patch2.getBank();
            if (program != program2 || bank != bank2) continue;
            boolean percussion2 = false;
            if (patch2 instanceof ModelPatch) {
                percussion2 = ((ModelPatch)patch2).isPercussion();
            }
            if (percussion != percussion2) continue;
            return instrument;
        }
        return null;
    }

    public void addResource(SoundbankResource resource) {
        if (resource instanceof Instrument) {
            this.instruments.add((Instrument)resource);
        } else {
            this.resources.add(resource);
        }
    }

    public void removeResource(SoundbankResource resource) {
        if (resource instanceof Instrument) {
            this.instruments.remove((Instrument)resource);
        } else {
            this.resources.remove(resource);
        }
    }

    public void addInstrument(Instrument resource) {
        this.instruments.add(resource);
    }

    public void removeInstrument(Instrument resource) {
        this.instruments.remove(resource);
    }

    public void addAllInstruments(Soundbank soundbank) {
        for (Instrument ins : soundbank.getInstruments()) {
            this.addInstrument(ins);
        }
    }

    public void removeAllInstruments(Soundbank soundbank) {
        for (Instrument ins : soundbank.getInstruments()) {
            this.removeInstrument(ins);
        }
    }
}

