/*
 * Decompiled with CFR 0.152.
 */
package media.sound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import media.sound.ModelConnectionBlock;
import media.sound.ModelDestination;
import media.sound.ModelIdentifier;
import media.sound.ModelOscillator;
import media.sound.ModelPerformer;
import media.sound.ModelSource;
import media.sound.ModelStandardTransform;
import media.sound.ModelTransform;

public class SoftPerformer {
    static ModelConnectionBlock[] defaultconnections = new ModelConnectionBlock[42];
    public int keyFrom = 0;
    public int keyTo = 127;
    public int velFrom = 0;
    public int velTo = 127;
    public int exclusiveClass = 0;
    public boolean selfNonExclusive = false;
    public boolean forcedVelocity = false;
    public boolean forcedKeynumber = false;
    public ModelPerformer performer;
    public ModelConnectionBlock[] connections;
    public ModelOscillator[] oscillators;
    public Map<Integer, int[]> midi_rpn_connections = new HashMap<Integer, int[]>();
    public Map<Integer, int[]> midi_nrpn_connections = new HashMap<Integer, int[]>();
    public int[][] midi_ctrl_connections;
    public int[][] midi_connections;
    public int[] ctrl_connections;
    private List<Integer> ctrl_connections_list = new ArrayList<Integer>();
    private static KeySortComparator keySortComparator;

    private String extractKeys(ModelConnectionBlock conn) {
        StringBuffer sb = new StringBuffer();
        if (conn.getSources() != null) {
            int i;
            sb.append("[");
            ModelSource[] srcs = conn.getSources();
            ModelSource[] srcs2 = new ModelSource[srcs.length];
            for (i = 0; i < srcs.length; ++i) {
                srcs2[i] = srcs[i];
            }
            Arrays.sort(srcs2, keySortComparator);
            for (i = 0; i < srcs.length; ++i) {
                sb.append(srcs[i].getIdentifier());
                sb.append(";");
            }
            sb.append("]");
        }
        sb.append(";");
        if (conn.getDestination() != null) {
            sb.append(conn.getDestination().getIdentifier());
        }
        sb.append(";");
        return sb.toString();
    }

    private void processSource(ModelSource src, int ix) {
        ModelIdentifier id = src.getIdentifier();
        String o = id.getObject();
        if (o.equals("midi_cc")) {
            this.processMidiControlSource(src, ix);
        } else if (o.equals("midi_rpn")) {
            this.processMidiRpnSource(src, ix);
        } else if (o.equals("midi_nrpn")) {
            this.processMidiNrpnSource(src, ix);
        } else if (o.equals("midi")) {
            this.processMidiSource(src, ix);
        } else if (o.equals("noteon")) {
            this.processNoteOnSource(src, ix);
        } else {
            if (o.equals("osc")) {
                return;
            }
            if (o.equals("mixer")) {
                return;
            }
            this.ctrl_connections_list.add(ix);
        }
    }

    private void processMidiControlSource(ModelSource src, int ix) {
        String v = src.getIdentifier().getVariable();
        if (v == null) {
            return;
        }
        int c = Integer.parseInt(v);
        if (this.midi_ctrl_connections[c] == null) {
            this.midi_ctrl_connections[c] = new int[]{ix};
        } else {
            int[] olda = this.midi_ctrl_connections[c];
            int[] newa = new int[olda.length + 1];
            for (int i = 0; i < olda.length; ++i) {
                newa[i] = olda[i];
            }
            newa[newa.length - 1] = ix;
            this.midi_ctrl_connections[c] = newa;
        }
    }

    private void processNoteOnSource(ModelSource src, int ix) {
        String v = src.getIdentifier().getVariable();
        int c = -1;
        if (v.equals("on")) {
            c = 3;
        }
        if (v.equals("keynumber")) {
            c = 4;
        }
        if (c == -1) {
            return;
        }
        if (this.midi_connections[c] == null) {
            this.midi_connections[c] = new int[]{ix};
        } else {
            int[] olda = this.midi_connections[c];
            int[] newa = new int[olda.length + 1];
            for (int i = 0; i < olda.length; ++i) {
                newa[i] = olda[i];
            }
            newa[newa.length - 1] = ix;
            this.midi_connections[c] = newa;
        }
    }

    private void processMidiSource(ModelSource src, int ix) {
        String v = src.getIdentifier().getVariable();
        int c = -1;
        if (v.equals("pitch")) {
            c = 0;
        }
        if (v.equals("channel_pressure")) {
            c = 1;
        }
        if (v.equals("poly_pressure")) {
            c = 2;
        }
        if (c == -1) {
            return;
        }
        if (this.midi_connections[c] == null) {
            this.midi_connections[c] = new int[]{ix};
        } else {
            int[] olda = this.midi_connections[c];
            int[] newa = new int[olda.length + 1];
            for (int i = 0; i < olda.length; ++i) {
                newa[i] = olda[i];
            }
            newa[newa.length - 1] = ix;
            this.midi_connections[c] = newa;
        }
    }

    private void processMidiRpnSource(ModelSource src, int ix) {
        String v = src.getIdentifier().getVariable();
        if (v == null) {
            return;
        }
        int c = Integer.parseInt(v);
        if (this.midi_rpn_connections.get(c) == null) {
            this.midi_rpn_connections.put(c, new int[]{ix});
        } else {
            int[] olda = this.midi_rpn_connections.get(c);
            int[] newa = new int[olda.length + 1];
            for (int i = 0; i < olda.length; ++i) {
                newa[i] = olda[i];
            }
            newa[newa.length - 1] = ix;
            this.midi_rpn_connections.put(c, newa);
        }
    }

    private void processMidiNrpnSource(ModelSource src, int ix) {
        String v = src.getIdentifier().getVariable();
        if (v == null) {
            return;
        }
        int c = Integer.parseInt(v);
        if (this.midi_nrpn_connections.get(c) == null) {
            this.midi_nrpn_connections.put(c, new int[]{ix});
        } else {
            int[] olda = this.midi_nrpn_connections.get(c);
            int[] newa = new int[olda.length + 1];
            for (int i = 0; i < olda.length; ++i) {
                newa[i] = olda[i];
            }
            newa[newa.length - 1] = ix;
            this.midi_nrpn_connections.put(c, newa);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SoftPerformer(ModelPerformer performer) {
        void var7_21;
        int i;
        this.performer = performer;
        this.keyFrom = performer.getKeyFrom();
        this.keyTo = performer.getKeyTo();
        this.velFrom = performer.getVelFrom();
        this.velTo = performer.getVelTo();
        this.exclusiveClass = performer.getExclusiveClass();
        this.selfNonExclusive = performer.isSelfNonExclusive();
        HashMap<String, ModelConnectionBlock> connmap = new HashMap<String, ModelConnectionBlock>();
        ArrayList<ModelConnectionBlock> performer_connections = new ArrayList<ModelConnectionBlock>();
        performer_connections.addAll(performer.getConnectionBlocks());
        if (performer.isDefaultConnectionsEnabled()) {
            void var7_14;
            boolean isModulationWheelConectionFound = false;
            for (int j = 0; j < performer_connections.size(); ++j) {
                ModelConnectionBlock connection2 = (ModelConnectionBlock)performer_connections.get(j);
                ModelSource[] modelSourceArray = connection2.getSources();
                ModelDestination dest = connection2.getDestination();
                boolean isModulationWheelConection = false;
                if (dest != null && modelSourceArray != null && modelSourceArray.length > 1) {
                    for (int i2 = 0; i2 < modelSourceArray.length; ++i2) {
                        if (!modelSourceArray[i2].getIdentifier().getObject().equals("midi_cc") || !modelSourceArray[i2].getIdentifier().getVariable().equals("1")) continue;
                        isModulationWheelConection = true;
                        isModulationWheelConectionFound = true;
                        break;
                    }
                }
                if (!isModulationWheelConection) continue;
                ModelConnectionBlock newconnection = new ModelConnectionBlock();
                newconnection.setSources(connection2.getSources());
                newconnection.setDestination(connection2.getDestination());
                newconnection.addSource(new ModelSource(new ModelIdentifier("midi_rpn", "5")));
                newconnection.setScale(connection2.getScale() * 256.0);
                performer_connections.set(j, newconnection);
            }
            if (!isModulationWheelConectionFound) {
                ModelConnectionBlock conn = new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO1, false, true, 0), new ModelSource(new ModelIdentifier("midi_cc", "1", 0), false, false, 0), 50.0, new ModelDestination(ModelDestination.DESTINATION_PITCH));
                conn.addSource(new ModelSource(new ModelIdentifier("midi_rpn", "5")));
                conn.setScale(conn.getScale() * 256.0);
                performer_connections.add(conn);
            }
            int channel_pressure_set = 0;
            int poly_pressure = 0;
            Object var7_13 = null;
            int mod_cc_1_connection_src_ix = 0;
            for (ModelConnectionBlock connection3 : performer_connections) {
                ModelSource[] sources = connection3.getSources();
                ModelDestination dest = connection3.getDestination();
                if (dest == null || sources == null) continue;
                for (int i3 = 0; i3 < sources.length; ++i3) {
                    ModelIdentifier srcid = sources[i3].getIdentifier();
                    if (srcid.getObject().equals("midi_cc") && srcid.getVariable().equals("1")) {
                        ModelConnectionBlock modelConnectionBlock = connection3;
                        mod_cc_1_connection_src_ix = i3;
                    }
                    if (!srcid.getObject().equals("midi")) continue;
                    if (srcid.getVariable().equals("channel_pressure")) {
                        channel_pressure_set = 1;
                    }
                    if (!srcid.getVariable().equals("poly_pressure")) continue;
                    poly_pressure = 1;
                }
            }
            if (var7_14 != null) {
                ModelSource[] src_list_new;
                ModelConnectionBlock mc;
                if (channel_pressure_set == 0) {
                    mc = new ModelConnectionBlock();
                    mc.setDestination(var7_14.getDestination());
                    mc.setScale(var7_14.getScale());
                    ModelSource[] src_list = var7_14.getSources();
                    src_list_new = new ModelSource[src_list.length];
                    for (int i4 = 0; i4 < src_list_new.length; ++i4) {
                        src_list_new[i4] = src_list[i4];
                    }
                    src_list_new[mod_cc_1_connection_src_ix] = new ModelSource(new ModelIdentifier("midi", "channel_pressure"));
                    mc.setSources(src_list_new);
                    connmap.put(this.extractKeys(mc), mc);
                }
                if (poly_pressure == 0) {
                    mc = new ModelConnectionBlock();
                    mc.setDestination(var7_14.getDestination());
                    mc.setScale(var7_14.getScale());
                    ModelSource[] src_list = var7_14.getSources();
                    src_list_new = new ModelSource[src_list.length];
                    for (int i5 = 0; i5 < src_list_new.length; ++i5) {
                        src_list_new[i5] = src_list[i5];
                    }
                    src_list_new[mod_cc_1_connection_src_ix] = new ModelSource(new ModelIdentifier("midi", "poly_pressure"));
                    mc.setSources(src_list_new);
                    connmap.put(this.extractKeys(mc), mc);
                }
            }
            ModelConnectionBlock found_vib_connection = null;
            for (ModelConnectionBlock connection4 : performer_connections) {
                ModelSource[] sources = connection4.getSources();
                if (sources.length == 0 || !sources[0].getIdentifier().getObject().equals("lfo") || !connection4.getDestination().getIdentifier().equals(ModelDestination.DESTINATION_PITCH)) continue;
                if (found_vib_connection == null) {
                    found_vib_connection = connection4;
                    continue;
                }
                if (found_vib_connection.getSources().length > sources.length) {
                    found_vib_connection = connection4;
                    continue;
                }
                if (found_vib_connection.getSources()[0].getIdentifier().getInstance() >= 1 || found_vib_connection.getSources()[0].getIdentifier().getInstance() <= sources[0].getIdentifier().getInstance()) continue;
                found_vib_connection = connection4;
            }
            int instance = 1;
            if (found_vib_connection != null) {
                instance = found_vib_connection.getSources()[0].getIdentifier().getInstance();
            }
            ModelConnectionBlock connection = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "78"), false, true, 0), 2000.0, new ModelDestination(new ModelIdentifier("lfo", "delay2", instance)));
            connmap.put(this.extractKeys(connection), connection);
            final double scale = found_vib_connection == null ? 0.0 : found_vib_connection.getScale();
            connection = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("lfo", instance)), new ModelSource(new ModelIdentifier("midi_cc", "77"), new ModelTransform(){
                double s;
                {
                    this.s = scale;
                }

                @Override
                public double transform(double value) {
                    value = value * 2.0 - 1.0;
                    value *= 600.0;
                    if (this.s == 0.0) {
                        return value;
                    }
                    if (this.s > 0.0) {
                        if (value < -this.s) {
                            value = -this.s;
                        }
                        return value;
                    }
                    if (value < this.s) {
                        value = -this.s;
                    }
                    return -value;
                }
            }), new ModelDestination(ModelDestination.DESTINATION_PITCH));
            connmap.put(this.extractKeys(connection), connection);
            connection = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "76"), false, true, 0), 2400.0, new ModelDestination(new ModelIdentifier("lfo", "freq", instance)));
            connmap.put(this.extractKeys(connection), connection);
        }
        if (performer.isDefaultConnectionsEnabled()) {
            for (ModelConnectionBlock modelConnectionBlock : defaultconnections) {
                connmap.put(this.extractKeys(modelConnectionBlock), modelConnectionBlock);
            }
        }
        for (ModelConnectionBlock connection : performer_connections) {
            connmap.put(this.extractKeys(connection), connection);
        }
        ArrayList<ModelConnectionBlock> connections = new ArrayList<ModelConnectionBlock>();
        this.midi_ctrl_connections = new int[128][];
        for (i = 0; i < this.midi_ctrl_connections.length; ++i) {
            this.midi_ctrl_connections[i] = null;
        }
        this.midi_connections = new int[5][];
        for (i = 0; i < this.midi_connections.length; ++i) {
            this.midi_connections[i] = null;
        }
        int ix = 0;
        boolean mustBeOnTop = false;
        for (ModelConnectionBlock connection : connmap.values()) {
            ModelDestination dest;
            ModelIdentifier id;
            if (connection.getDestination() != null && (id = (dest = connection.getDestination()).getIdentifier()).getObject().equals("noteon")) {
                mustBeOnTop = true;
                if (id.getVariable().equals("keynumber")) {
                    this.forcedKeynumber = true;
                }
                if (id.getVariable().equals("velocity")) {
                    this.forcedVelocity = true;
                }
            }
            if (mustBeOnTop) {
                connections.add(0, connection);
                mustBeOnTop = false;
                continue;
            }
            connections.add(connection);
        }
        for (ModelConnectionBlock connection : connections) {
            if (connection.getSources() != null) {
                ModelSource[] srcs = connection.getSources();
                for (int i6 = 0; i6 < srcs.length; ++i6) {
                    this.processSource(srcs[i6], ix);
                }
            }
            ++ix;
        }
        this.connections = new ModelConnectionBlock[connections.size()];
        connections.toArray(this.connections);
        this.ctrl_connections = new int[this.ctrl_connections_list.size()];
        boolean bl = false;
        while (var7_21 < this.ctrl_connections.length) {
            this.ctrl_connections[var7_21] = this.ctrl_connections_list.get((int)var7_21);
            ++var7_21;
        }
        this.oscillators = new ModelOscillator[performer.getOscillators().size()];
        performer.getOscillators().toArray(this.oscillators);
        for (ModelConnectionBlock conn : connections) {
            if (conn.getDestination() != null && SoftPerformer.isUnnecessaryTransform(conn.getDestination().getTransform())) {
                conn.getDestination().setTransform(null);
            }
            if (conn.getSources() == null) continue;
            for (ModelSource src : conn.getSources()) {
                if (!SoftPerformer.isUnnecessaryTransform(src.getTransform())) continue;
                src.setTransform(null);
            }
        }
    }

    private static boolean isUnnecessaryTransform(ModelTransform transform) {
        if (transform == null) {
            return false;
        }
        if (!(transform instanceof ModelStandardTransform)) {
            return false;
        }
        ModelStandardTransform stransform = (ModelStandardTransform)transform;
        if (stransform.getDirection()) {
            return false;
        }
        if (stransform.getPolarity()) {
            return false;
        }
        if (stransform.getTransform() != 0) {
            return false;
        }
        return false;
    }

    static {
        int o = 0;
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("noteon", "on", 0), false, false, 0), 1.0, new ModelDestination(new ModelIdentifier("eg", "on", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("noteon", "on", 0), false, false, 0), 1.0, new ModelDestination(new ModelIdentifier("eg", "on", 1)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("eg", "active", 0), false, false, 0), 1.0, new ModelDestination(new ModelIdentifier("mixer", "active", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("eg", 0), true, false, 0), -960.0, new ModelDestination(new ModelIdentifier("mixer", "gain")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("noteon", "velocity"), true, false, 1), -960.0, new ModelDestination(new ModelIdentifier("mixer", "gain")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi", "pitch"), false, true, 0), new ModelSource(new ModelIdentifier("midi_rpn", "0"), new ModelTransform(){

            @Override
            public double transform(double value) {
                int v = (int)(value * 16384.0);
                int msb = v >> 7;
                int lsb = v & 0x7F;
                return msb * 100 + lsb;
            }
        }), new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("noteon", "keynumber"), false, false, 0), 12800.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "7"), true, false, 1), -960.0, new ModelDestination(new ModelIdentifier("mixer", "gain")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "8"), false, false, 0), 1000.0, new ModelDestination(new ModelIdentifier("mixer", "balance")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "10"), false, false, 0), 1000.0, new ModelDestination(new ModelIdentifier("mixer", "pan")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "11"), true, false, 1), -960.0, new ModelDestination(new ModelIdentifier("mixer", "gain")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "91"), false, false, 0), 1000.0, new ModelDestination(new ModelIdentifier("mixer", "reverb")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "93"), false, false, 0), 1000.0, new ModelDestination(new ModelIdentifier("mixer", "chorus")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "71"), false, true, 0), 200.0, new ModelDestination(new ModelIdentifier("filter", "q")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "74"), false, true, 0), 9600.0, new ModelDestination(new ModelIdentifier("filter", "freq")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "72"), false, true, 0), 6000.0, new ModelDestination(new ModelIdentifier("eg", "release2")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "73"), false, true, 0), 2000.0, new ModelDestination(new ModelIdentifier("eg", "attack2")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "75"), false, true, 0), 6000.0, new ModelDestination(new ModelIdentifier("eg", "decay2")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "67"), false, false, 3), -50.0, new ModelDestination(ModelDestination.DESTINATION_GAIN));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "67"), false, false, 3), -2400.0, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_rpn", "1"), false, true, 0), 100.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_rpn", "2"), false, true, 0), 12800.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("master", "fine_tuning"), false, true, 0), 100.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("master", "coarse_tuning"), false, true, 0), 12800.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(13500.0, new ModelDestination(new ModelIdentifier("filter", "freq", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "delay", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "attack", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "hold", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "decay", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(1000.0, new ModelDestination(new ModelIdentifier("eg", "sustain", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "release", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(1200.0 * Math.log(0.015) / Math.log(2.0), new ModelDestination(new ModelIdentifier("eg", "shutdown", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "delay", 1)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "attack", 1)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "hold", 1)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "decay", 1)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(1000.0, new ModelDestination(new ModelIdentifier("eg", "sustain", 1)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "release", 1)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(-8.51318, new ModelDestination(new ModelIdentifier("lfo", "freq", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("lfo", "delay", 0)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(-8.51318, new ModelDestination(new ModelIdentifier("lfo", "freq", 1)));
        SoftPerformer.defaultconnections[o++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("lfo", "delay", 1)));
        keySortComparator = new KeySortComparator();
    }

    private static class KeySortComparator
    implements Comparator<ModelSource> {
        private KeySortComparator() {
        }

        @Override
        public int compare(ModelSource o1, ModelSource o2) {
            return o1.getIdentifier().toString().compareTo(o2.getIdentifier().toString());
        }
    }
}

