/*
 * Decompiled with CFR 0.152.
 */
package media.sound;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import media.sound.AudioFloatConverter;
import media.sound.RIFFReader;

public class WaveFloatFileReader
extends AudioFileReader {
    @Override
    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format;
        stream.mark(200);
        try {
            format = this.internal_getAudioFileFormat(stream);
        }
        finally {
            stream.reset();
        }
        return format;
    }

    private AudioFileFormat internal_getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        RIFFReader riffiterator = new RIFFReader(stream);
        if (!riffiterator.getFormat().equals("RIFF")) {
            throw new UnsupportedAudioFileException();
        }
        if (!riffiterator.getType().equals("WAVE")) {
            throw new UnsupportedAudioFileException();
        }
        boolean fmt_found = false;
        boolean data_found = false;
        int channels = 1;
        long samplerate = 1L;
        int framesize = 1;
        int bits = 1;
        while (riffiterator.hasNextChunk()) {
            RIFFReader chunk = riffiterator.nextChunk();
            if (chunk.getFormat().equals("fmt ")) {
                fmt_found = true;
                int format = chunk.readUnsignedShort();
                if (format != 3) {
                    throw new UnsupportedAudioFileException();
                }
                channels = chunk.readUnsignedShort();
                samplerate = chunk.readUnsignedInt();
                chunk.readUnsignedInt();
                framesize = chunk.readUnsignedShort();
                bits = chunk.readUnsignedShort();
            }
            if (!chunk.getFormat().equals("data")) continue;
            data_found = true;
            break;
        }
        if (!fmt_found) {
            throw new UnsupportedAudioFileException();
        }
        if (!data_found) {
            throw new UnsupportedAudioFileException();
        }
        AudioFormat audioformat = new AudioFormat(AudioFloatConverter.PCM_FLOAT, samplerate, bits, channels, framesize, samplerate, false);
        AudioFileFormat fileformat = new AudioFileFormat(AudioFileFormat.Type.WAVE, audioformat, -1);
        return fileformat;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format = this.getAudioFileFormat(stream);
        RIFFReader riffiterator = new RIFFReader(stream);
        if (!riffiterator.getFormat().equals("RIFF")) {
            throw new UnsupportedAudioFileException();
        }
        if (!riffiterator.getType().equals("WAVE")) {
            throw new UnsupportedAudioFileException();
        }
        while (riffiterator.hasNextChunk()) {
            RIFFReader chunk = riffiterator.nextChunk();
            if (!chunk.getFormat().equals("data")) continue;
            return new AudioInputStream(chunk, format.getFormat(), chunk.getSize());
        }
        throw new UnsupportedAudioFileException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format;
        try (InputStream stream = url.openStream();){
            format = this.getAudioFileFormat(new BufferedInputStream(stream));
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format;
        try (FileInputStream stream = new FileInputStream(file);){
            format = this.getAudioFileFormat(new BufferedInputStream(stream));
        }
        return format;
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new BufferedInputStream(url.openStream()));
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new BufferedInputStream(new FileInputStream(file)));
    }
}

