/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.tools.custom.tuner;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.tools.custom.tuner.TGTuner;
import app.tuxguitar.app.tools.custom.tuner.TGTunerFineWidget;
import app.tuxguitar.app.tools.custom.tuner.TGTunerListener;
import app.tuxguitar.app.tools.custom.tuner.TGTunerRoughWidget;
import app.tuxguitar.app.tools.custom.tuner.TGTunerSettingsDialog;
import app.tuxguitar.app.tools.custom.tuner.TGTuningString;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGSynchronizer;
import app.tuxguitar.util.error.TGErrorManager;
import java.util.ArrayList;
import java.util.List;

public class TGTunerDialog
implements TGTunerListener {
    private TGContext context;
    private TGTuner tuner = null;
    private int[] tuning = null;
    private UILabel currentFrequency = null;
    private UIWindow dialog = null;
    private TGTunerRoughWidget roughTuner = null;
    private List<TGTuningString> allStringButtons = null;
    private TGTunerFineWidget fineTuner = null;

    public TGTunerDialog(TGContext context, int[] tuning) {
        this.context = context;
        this.tuning = tuning;
    }

    public void show() {
        UIFactory uiFactory = this.getUIFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.dialog.setText(TuxGuitar.getProperty((String)"tuner.instrument-tuner"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)this.dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty((String)"tuner.tuner"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(400.0f), null, null);
        UITableLayout specialLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel specialComposite = uiFactory.createPanel((UIContainer)group, false);
        specialComposite.setLayout((UILayout)specialLayout);
        groupLayout.set((UIControl)specialComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.allStringButtons = new ArrayList<TGTuningString>(this.tuning.length);
        this.fineTuner = new TGTunerFineWidget(this.context, uiFactory, (UILayoutContainer)specialComposite);
        specialLayout.set(this.fineTuner.getControl(), Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        UITableLayout stringButtonsLayout = new UITableLayout();
        UIPanel stringButtonsComposite = uiFactory.createPanel((UIContainer)specialComposite, false);
        stringButtonsComposite.setLayout((UILayout)stringButtonsLayout);
        specialLayout.set((UIControl)stringButtonsComposite, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        for (int i = 0; i < this.tuning.length; ++i) {
            this.createTuningString(uiFactory, (UILayoutContainer)stringButtonsComposite, i);
        }
        UITableLayout tunLayout = new UITableLayout();
        UIPanel tunComposite = uiFactory.createPanel((UIContainer)group, false);
        tunComposite.setLayout((UILayout)tunLayout);
        groupLayout.set((UIControl)tunComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.currentFrequency = uiFactory.createLabel((UIContainer)tunComposite);
        tunLayout.set((UIControl)this.currentFrequency, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.roughTuner = new TGTunerRoughWidget(this.context, uiFactory, (UILayoutContainer)group);
        groupLayout.set(this.roughTuner.getControl(), Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(600.0f), null, null);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonSettings = uiFactory.createButton((UIContainer)buttons);
        buttonSettings.setText(TuxGuitar.getProperty((String)"settings"));
        buttonSettings.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTunerDialog.this.getTuner().pause();
                new TGTunerSettingsDialog(TGTunerDialog.this).show();
            }
        });
        buttonsLayout.set((UIControl)buttonSettings, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonExit = uiFactory.createButton((UIContainer)buttons);
        buttonExit.setText(TuxGuitar.getProperty((String)"close"));
        buttonExit.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTunerDialog.this.getTuner().setCanceled(true);
                TGTunerDialog.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonExit, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonExit, "margin_right", (Object)Float.valueOf(0.0f));
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGTunerDialog.this.getTuner().setCanceled(true);
                TGTunerDialog.this.dialog.dispose();
            }
        });
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
        this.tuner = new TGTuner(this);
        this.getTuner().start();
    }

    @Override
    public void fireFrequency(final double freq) {
        if (!this.dialog.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TGTunerDialog.this.dialog.isDisposed() && !TGTunerDialog.this.roughTuner.isDisposed()) {
                        TGTunerDialog.this.currentFrequency.setText(Math.floor(freq) + " Hz");
                        TGTunerDialog.this.roughTuner.setCurrentFrequency(freq);
                    }
                    if (!TGTunerDialog.this.dialog.isDisposed() && !TGTunerDialog.this.fineTuner.isDisposed()) {
                        TGTunerDialog.this.fineTuner.setCurrentFrequency(freq);
                    }
                }
            });
        }
    }

    public TGTuner getTuner() {
        return this.tuner;
    }

    @Override
    public int[] getTuning() {
        return this.tuning;
    }

    @Override
    public void fireException(Exception ex) {
        TGErrorManager.getInstance((TGContext)this.context).handleError((Throwable)ex);
    }

    @Override
    public void fireCurrentString(int string) {
        this.tuner.pause();
        if (string == 0) {
            this.tuner.setWantedRange();
            this.fineTuner.getControl().setEnabled(false);
        } else {
            this.tuner.setWantedNote(string);
            this.fineTuner.setWantedTone(string);
        }
        this.tuner.resumeFromPause();
    }

    private void createTuningString(UIFactory factory, UILayoutContainer parent, int index) {
        TGTuningString tempString = new TGTuningString(factory, (UIContainer)parent, this, this.tuning[index]);
        this.allStringButtons.add(tempString);
        tempString.getStringButton().addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTunerDialog.this.fineTuner.setCurrentFrequency(-1.0);
                for (TGTuningString tmp : TGTunerDialog.this.allStringButtons) {
                    tmp.getStringButton().setSelected(false);
                }
            }
        });
        tempString.addListener();
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)tempString.getStringButton(), Integer.valueOf(index + 1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance((TGContext)this.context).getFactory();
    }

    public UIWindow getWindow() {
        return this.dialog;
    }

    public TGContext getContext() {
        return this.context;
    }
}

