/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.midi.synth;

import app.tuxguitar.midi.synth.TGSynthExtension;
import app.tuxguitar.midi.synth.TGSynthManager;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.plugin.TGPlugin;
import app.tuxguitar.util.plugin.TGPluginException;
import java.util.List;

public abstract class TGSynthExtensionPlugin
implements TGPlugin {
    private List<TGSynthExtension<?>> extensions;

    public abstract List<TGSynthExtension<?>> createExtensions(TGContext var1) throws TGPluginException;

    public void connect(TGContext context) throws TGPluginException {
        try {
            if (this.extensions == null) {
                this.extensions = this.createExtensions(context);
                TGSynthManager synthManager = TGSynthManager.getInstance(context);
                for (TGSynthExtension<?> extension : this.extensions) {
                    synthManager.addExtension(extension.getExtensionClass(), extension.getExtension());
                }
            }
        }
        catch (Throwable throwable) {
            throw new TGPluginException(throwable.getMessage(), throwable);
        }
    }

    public void disconnect(TGContext context) throws TGPluginException {
        try {
            if (this.extensions != null) {
                TGSynthManager synthManager = TGSynthManager.getInstance(context);
                for (TGSynthExtension<?> extension : this.extensions) {
                    synthManager.removeExtension(extension.getExtensionClass(), extension.getExtension());
                }
                this.extensions = null;
            }
        }
        catch (Throwable throwable) {
            throw new TGPluginException(throwable.getMessage(), throwable);
        }
    }
}

