/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.impl.file;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionContextImpl;
import app.tuxguitar.app.document.TGDocumentFileManager;
import app.tuxguitar.app.util.TGMessageDialogUtil;
import app.tuxguitar.app.view.dialog.file.TGFileChooserHandler;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.editor.action.file.TGReadSongAction;
import app.tuxguitar.editor.event.TGUpdateEvent;
import app.tuxguitar.editor.template.TGTemplate;
import app.tuxguitar.editor.template.TGTemplateManager;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventManager;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatManager;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGAbstractContext;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGUserFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TGCustomTemplateSelectAction
extends TGActionBase {
    public static final String NAME = "action.custom-template.select";

    public TGCustomTemplateSelectAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext actionContext) {
        List<TGFileFormat> fileFormats = this.createFileFormats(actionContext);
        TGDocumentFileManager tgDocumentFileManager = TGDocumentFileManager.getInstance(this.getContext());
        tgDocumentFileManager.chooseFileNameForOpen(fileFormats, new TGFileChooserHandler(){

            @Override
            public void updateFileName(String fileName) {
                File file = new File(fileName);
                TGTemplate userTemplate = new TGTemplate();
                userTemplate.setName(new String());
                userTemplate.setResource(file.getAbsolutePath());
                userTemplate.setUserTemplate();
                TGSong song = TGTemplateManager.getInstance((TGContext)TGCustomTemplateSelectAction.this.getContext()).getTemplateAsSong(userTemplate);
                if (song == null) {
                    UIWindow window = TGWindow.getInstance(TGCustomTemplateSelectAction.this.getContext()).getWindow();
                    TGMessageDialogUtil.errorMessage(TGCustomTemplateSelectAction.this.getContext(), window, TuxGuitar.getProperty("file.custom-template.error"));
                } else {
                    TGUserFileUtils.setUserTemplate((File)file);
                    TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)TGCustomTemplateSelectAction.this.getContext());
                    tgActionManager.execute("action.song.new", (TGActionContext)new TGActionContextImpl());
                    TGEventManager.getInstance((TGContext)TGCustomTemplateSelectAction.this.getContext()).fireEvent((TGEvent)new TGUpdateEvent(6, (TGAbstractContext)TGCustomTemplateSelectAction.this.getContext()));
                }
            }
        });
    }

    public List<TGFileFormat> createFileFormats(TGActionContext context) {
        TGFileFormatManager fileFormatManager = TGFileFormatManager.getInstance((TGContext)this.getContext());
        TGFileFormat fileFormat = (TGFileFormat)context.getAttribute(TGReadSongAction.ATTRIBUTE_FORMAT);
        if (fileFormat == null) {
            return fileFormatManager.findReadFileFormats(Boolean.valueOf(true));
        }
        ArrayList<TGFileFormat> fileFormats = new ArrayList<TGFileFormat>();
        fileFormats.add(fileFormat);
        return fileFormats;
    }
}

