/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.impl.file;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionException;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.action.impl.file.TGReadURLAction;
import app.tuxguitar.app.document.TGDocumentFileManager;
import app.tuxguitar.app.view.dialog.file.TGFileChooserHandler;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.editor.action.file.TGReadSongAction;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatManager;
import app.tuxguitar.util.TGContext;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class TGOpenFileAction
extends TGActionBase {
    public static final String NAME = "action.file.open";

    public TGOpenFileAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(final TGActionContext context) {
        List<TGFileFormat> fileFormats = this.createFileFormats(context);
        TGDocumentFileManager tgDocumentFileManager = TGDocumentFileManager.getInstance(this.getContext());
        tgDocumentFileManager.chooseFileNameForOpen(fileFormats, new TGFileChooserHandler(){

            @Override
            public void updateFileName(String fileName) {
                final URL url = TGOpenFileAction.this.createUrl(fileName);
                if (url != null) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            context.setAttribute(TGReadURLAction.ATTRIBUTE_URL, (Object)url);
                            TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)TGOpenFileAction.this.getContext());
                            tgActionManager.execute("action.url.read", context);
                        }
                    }).start();
                }
            }
        });
    }

    public URL createUrl(String fileName) {
        try {
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                return file.toURI().toURL();
            }
            return null;
        }
        catch (Throwable e) {
            throw new TGActionException(e.getMessage(), e);
        }
    }

    public List<TGFileFormat> createFileFormats(TGActionContext context) {
        TGFileFormatManager fileFormatManager = TGFileFormatManager.getInstance((TGContext)this.getContext());
        TGFileFormat fileFormat = (TGFileFormat)context.getAttribute(TGReadSongAction.ATTRIBUTE_FORMAT);
        if (fileFormat == null) {
            return fileFormatManager.findReadFileFormats(Boolean.valueOf(true));
        }
        ArrayList<TGFileFormat> fileFormats = new ArrayList<TGFileFormat>();
        fileFormats.add(fileFormat);
        return fileFormats;
    }
}

