/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.impl.file;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.action.impl.view.TGOpenViewAction;
import app.tuxguitar.app.printer.PrintController;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.dialog.printer.TGPrintPreviewDialog;
import app.tuxguitar.app.view.dialog.printer.TGPrintPreviewDialogController;
import app.tuxguitar.app.view.dialog.printer.TGPrintSettingsDialog;
import app.tuxguitar.app.view.dialog.printer.TGPrintSettingsDialogController;
import app.tuxguitar.app.view.dialog.printer.TGPrintSettingsHandler;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.graphics.control.TGController;
import app.tuxguitar.graphics.control.TGFactoryImpl;
import app.tuxguitar.graphics.control.print.TGPrintDocument;
import app.tuxguitar.graphics.control.print.TGPrintLayout;
import app.tuxguitar.graphics.control.print.TGPrintPainter;
import app.tuxguitar.graphics.control.print.TGPrintSettings;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.resource.UIInset;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.resource.UIResourceFactory;
import app.tuxguitar.ui.resource.UISize;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class TGPrintPreviewAction
extends TGActionBase {
    public static final String NAME = "action.file.print-preview";
    private static final int PAGE_WIDTH = 850;
    private static final int PAGE_HEIGHT = 1050;
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 40;
    private static final int MARGIN_LEFT = 50;
    private static final int MARGIN_RIGHT = 20;

    public TGPrintPreviewAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        TGPrintSettings styles = (TGPrintSettings)context.getAttribute("attribute.print.settings.styles");
        if (styles == null) {
            this.configureStyles(context);
            return;
        }
        Integer zoomValue = (Integer)context.getAttribute("attribute.print.settings.zoom");
        if (zoomValue == null) {
            zoomValue = 100;
        }
        TGSongManager manager = new TGSongManager((TGFactory)new TGFactoryImpl());
        TGSong sourceSong = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGSong targetSong = sourceSong.clone(manager.getFactory());
        UISize pageSize = new UISize(850.0f, 1050.0f);
        UIInset pageMargins = new UIInset(20.0f, 50.0f, 20.0f, 40.0f);
        PrintController controller = new PrintController(this.getContext(), targetSong, manager, (UIResourceFactory)this.getUIFactory());
        TGPrintLayout printLayout = new TGPrintLayout((TGController)controller, styles);
        printLayout.loadStyles((float)zoomValue.intValue() / 100.0f);
        printLayout.updateSong();
        printLayout.makeDocument((TGPrintDocument)new PrintDocumentImpl(pageSize, pageMargins));
        printLayout.getResourceBuffer().disposeAllResources();
    }

    public void configureStyles(final TGActionContext context) {
        context.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPrintSettingsDialogController());
        context.setAttribute(TGPrintSettingsDialog.ATTRIBUTE_HANDLER, (Object)new TGPrintSettingsHandler(){

            @Override
            public void updatePrintSettings(TGPrintSettings styles, int zoomValue) {
                context.setAttribute("attribute.print.settings.styles", (Object)styles);
                context.setAttribute("attribute.print.settings.zoom", (Object)zoomValue);
                TGPrintPreviewAction.this.executeActionInNewThread(TGPrintPreviewAction.NAME, context);
            }
        });
        this.executeActionInNewThread("action.gui.open-view", context);
    }

    public void executeActionInNewThread(final String id, final TGActionContext context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TGActionManager.getInstance((TGContext)TGPrintPreviewAction.this.getContext()).execute(id, context);
            }
        }).start();
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.getContext()).getFactory();
    }

    private class PrintDocumentImpl
    implements TGPrintDocument {
        private TGPrintPainter painter;
        private UISize size;
        private UIInset margins;
        private List<UIImage> pages;

        public PrintDocumentImpl(UISize size, UIInset margins) {
            this.size = size;
            this.margins = margins;
            this.pages = new ArrayList<UIImage>();
            this.painter = new TGPrintPainter();
        }

        public UIPainter getPainter() {
            return this.painter;
        }

        public UISize getSize() {
            return this.size;
        }

        public UIInset getMargins() {
            return this.margins;
        }

        public void pageStart() {
            UIFactory factory = TGPrintPreviewAction.this.getUIFactory();
            UIImage page = factory.createImage(this.size.getWidth(), this.size.getHeight());
            this.painter.setHandle(page.createPainter());
            this.pages.add(page);
        }

        public void pageFinish() {
            this.painter.dispose();
        }

        public void start() {
        }

        public void finish() {
            UISize size = this.size;
            final List<UIImage> pages = this.pages;
            TGActionProcessor tgActionProcessor = new TGActionProcessor(TGPrintPreviewAction.this.getContext(), "action.gui.open-view");
            tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPrintPreviewDialogController());
            tgActionProcessor.setAttribute(TGPrintPreviewDialog.ATTRIBUTE_PAGES, pages);
            tgActionProcessor.setAttribute(TGPrintPreviewDialog.ATTRIBUTE_SIZE, (Object)size);
            tgActionProcessor.setAttribute(TGViewContext.ATTRIBUTE_DISPOSE_LISTENER, (Object)new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    for (UIImage uiImage : pages) {
                        uiImage.dispose();
                    }
                }
            });
            tgActionProcessor.process();
        }

        public boolean isTransparentBackground() {
            return false;
        }

        public boolean isPaintable(int page) {
            return true;
        }
    }
}

