/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.listener.save;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionException;
import app.tuxguitar.action.TGActionInterceptor;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.impl.view.TGOpenViewAction;
import app.tuxguitar.app.document.TGDocument;
import app.tuxguitar.app.document.TGDocumentListManager;
import app.tuxguitar.app.view.dialog.confirm.TGConfirmDialog;
import app.tuxguitar.app.view.dialog.confirm.TGConfirmDialogController;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class TGUnsavedDocumentInterceptor
implements TGActionInterceptor,
TGEventListener {
    private static final String UNSAVED_INTERCEPTOR_DOCUMENTS = "unsavedInterceptor_documents";
    private static final String UNSAVED_INTERCEPTOR_ACTION_ID = "unsavedInterceptor_actionId";
    public static final String UNSAVED_INTERCEPTOR_BY_PASS = "unsavedInterceptor_byPass";
    private TGContext context;
    private List<String> actionIds;

    public TGUnsavedDocumentInterceptor(TGContext context) {
        this.context = context;
        this.actionIds = new ArrayList<String>();
    }

    public boolean containsActionId(String id) {
        return this.actionIds.contains(id);
    }

    public void addActionId(String id) {
        this.actionIds.add(id);
    }

    public void removeActionId(String id) {
        this.actionIds.remove(id);
    }

    public boolean intercept(String id, final TGActionContext context) throws TGActionException {
        List<TGDocument> unsavedDocuments;
        if (!this.isByPassInContext(context) && this.containsActionId(id) && !(unsavedDocuments = this.findUnsavedDocuments(context)).isEmpty()) {
            TGDocument document = unsavedDocuments.remove(0);
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)document.getSong());
            context.setAttribute(UNSAVED_INTERCEPTOR_ACTION_ID, (Object)id);
            TGActionProcessor tgLoadSongAction = new TGActionProcessor(this.context, "action.song.load");
            tgLoadSongAction.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)document.getSong());
            tgLoadSongAction.setOnFinish(new Runnable(){

                @Override
                public void run() {
                    TGUnsavedDocumentInterceptor.this.openSaveDialog(context);
                }
            });
            tgLoadSongAction.process();
            return true;
        }
        return false;
    }

    public void openSaveDialog(TGActionContext context) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGConfirmDialogController());
        tgActionProcessor.setAttribute("message", (Object)TuxGuitar.getProperty("file.save-changes-question"));
        tgActionProcessor.setAttribute("style", (Object)(TGConfirmDialog.BUTTON_YES | TGConfirmDialog.BUTTON_NO | TGConfirmDialog.BUTTON_CANCEL));
        tgActionProcessor.setAttribute("defaultButton", (Object)TGConfirmDialog.BUTTON_YES);
        tgActionProcessor.setAttribute("yesRunnable", (Object)this.createThreadRunnable(this.createSaveActionRunnable(context)));
        tgActionProcessor.setAttribute("noRunnable", (Object)this.createThreadRunnable(this.createInterceptedActionRunnable(context)));
        tgActionProcessor.process();
    }

    public Runnable createThreadRunnable(final Runnable target) {
        return new Runnable(){

            @Override
            public void run() {
                new Thread(target).start();
            }
        };
    }

    public Runnable createSaveActionRunnable(final TGActionContext tgActionContext) {
        return new Runnable(){

            @Override
            public void run() {
                TGUnsavedDocumentInterceptor.this.executeSaveAction(tgActionContext);
            }
        };
    }

    public Runnable createInterceptedActionRunnable(final TGActionContext tgActionContext) {
        return new Runnable(){

            @Override
            public void run() {
                TGUnsavedDocumentInterceptor.this.executeInterceptedAction(tgActionContext);
            }
        };
    }

    private boolean isByPassInContext(TGActionContext context) {
        return Boolean.TRUE.equals(context.getAttribute(UNSAVED_INTERCEPTOR_BY_PASS));
    }

    private boolean containsUnsavedDocument(TGActionContext context) {
        return !this.findUnsavedDocuments(context).isEmpty();
    }

    private List<TGDocument> findUnsavedDocuments(TGActionContext context) {
        ArrayList<TGDocument> unsavedDocuments = (ArrayList<TGDocument>)context.getAttribute(UNSAVED_INTERCEPTOR_DOCUMENTS);
        if (unsavedDocuments == null) {
            unsavedDocuments = new ArrayList<TGDocument>();
            List<TGDocument> documents = this.findDocuments(context);
            for (TGDocument document : documents) {
                if (!document.isUnsaved()) continue;
                unsavedDocuments.add(document);
            }
            context.setAttribute(UNSAVED_INTERCEPTOR_DOCUMENTS, unsavedDocuments);
        }
        return unsavedDocuments;
    }

    private List<TGDocument> findDocuments(TGActionContext context) {
        List<TGDocument> documents = (List<TGDocument>)context.getAttribute("documents");
        if (documents == null) {
            documents = TGDocumentListManager.getInstance(this.context).getDocuments();
        }
        return documents;
    }

    public void executeInterceptedAction(TGActionContext context) {
        if (!this.containsUnsavedDocument(context)) {
            context.setAttribute(UNSAVED_INTERCEPTOR_BY_PASS, (Object)true);
        }
        String actionId = (String)context.getAttribute(UNSAVED_INTERCEPTOR_ACTION_ID);
        TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.context);
        tgActionManager.execute(actionId, context);
    }

    public void executeSaveAction(TGActionContext tgActionContext) {
        TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.context);
        tgActionManager.execute("action.file.save", tgActionContext);
    }

    public void checkForInterceptedAction(TGEvent event) {
        TGActionContext actionContext;
        if ("action.song.write".equals(event.getAttribute("actionId")) && (actionContext = (TGActionContext)event.getAttribute("sourceContext")).getAttribute(UNSAVED_INTERCEPTOR_ACTION_ID) != null) {
            this.createThreadRunnable(this.createInterceptedActionRunnable(actionContext)).run();
        }
    }

    public void processEvent(TGEvent event) {
        if ("action-post-execution".equals(event.getEventType())) {
            this.checkForInterceptedAction(event);
        }
    }
}

