/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.listener.undoable;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.app.action.TGActionMap;
import app.tuxguitar.app.action.listener.undoable.TGUndoableContext;
import app.tuxguitar.app.action.listener.undoable.TGUndoableJoined;
import app.tuxguitar.editor.undo.TGUndoableActionController;
import app.tuxguitar.editor.undo.TGUndoableEdit;
import app.tuxguitar.editor.undo.TGUndoableManager;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.util.TGContext;

public class TGUndoableActionListener
implements TGEventListener {
    private TGContext context;
    private TGActionMap<TGUndoableActionController> controllers;

    public TGUndoableActionListener(TGContext context) {
        this.context = context;
        this.controllers = new TGActionMap();
    }

    public TGActionMap<TGUndoableActionController> getControllers() {
        return this.controllers;
    }

    public void processPreExecution(String actionId, TGActionContext actionContext) {
        TGUndoableContext undoableContext = TGUndoableContext.getInstance(actionContext);
        TGUndoableActionController controller = this.controllers.get(actionId);
        if (controller != null) {
            TGUndoableEdit undoableEdit;
            if (undoableContext.getUndoable() == null) {
                undoableContext.setUndoable(new TGUndoableJoined(this.context));
            }
            if ((undoableEdit = controller.startUndoable(this.context, actionContext)) != null) {
                undoableContext.addUndoableToCurrentLevel(undoableEdit);
            }
        }
        undoableContext.incrementLevel();
    }

    public void processPostExecution(String actionId, TGActionContext actionContext) {
        TGUndoableActionController controller;
        TGUndoableContext undoableContext = TGUndoableContext.getInstance(actionContext);
        undoableContext.decrementLevel();
        TGUndoableEdit undoableEdit = undoableContext.getUndoableFromCurrentLevel();
        if (undoableEdit != null && (controller = this.controllers.get(actionId)) != null && (undoableEdit = controller.endUndoable(this.context, actionContext, undoableEdit)) != null) {
            undoableContext.getUndoable().addUndoableEdit(undoableEdit);
        }
        if (undoableContext.getLevel() == 0 && undoableContext.getUndoable() != null && !undoableContext.getUndoable().isEmpty()) {
            TGUndoableManager.getInstance((TGContext)this.context).addEdit((TGUndoableEdit)undoableContext.getUndoable().endUndo());
            undoableContext.reset();
        }
    }

    public void processPreExecution(TGEvent event) {
        String actionId = (String)event.getAttribute("actionId");
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        if (!this.isByPassUndoable(actionContext)) {
            this.processPreExecution(actionId, actionContext);
        }
    }

    public void processPostExecution(TGEvent event) {
        String actionId = (String)event.getAttribute("actionId");
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        if (!this.isByPassUndoable(actionContext)) {
            this.processPostExecution(actionId, actionContext);
        }
    }

    public boolean isByPassUndoable(TGActionContext actionContext) {
        return Boolean.TRUE.equals(actionContext.getAttribute("byPassUndoable"));
    }

    public void processEvent(TGEvent event) {
        if ("action-pre-execution".equals(event.getEventType())) {
            this.processPreExecution(event);
        } else if ("action-post-execution".equals(event.getEventType())) {
            this.processPostExecution(event);
        }
    }
}

