/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.listener.undoable;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.app.action.listener.undoable.TGUndoableCaretState;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.TGUndoableEdit;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class TGUndoableJoined
extends TGUndoableEditBase {
    private int doAction = 1;
    private TGUndoableCaretState undoableState;
    private List<Object> undoables;

    public TGUndoableJoined(TGContext context) {
        super(context);
        this.undoableState = new TGUndoableCaretState(context);
        this.undoables = new ArrayList<Object>();
    }

    public void addUndoableEdit(TGUndoableEdit undoable) {
        this.undoables.add(undoable);
    }

    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        TablatureEditor.getInstance(this.getContext()).getTablature().getSelector().clearSelection();
        int count = this.undoables.size();
        for (int i = 0; i < count; ++i) {
            TGUndoableEdit undoable = (TGUndoableEdit)this.undoables.get(i);
            undoable.redo(actionContext);
        }
        this.undoableState.redo(actionContext);
        this.doAction = 1;
    }

    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        TablatureEditor.getInstance(this.getContext()).getTablature().getSelector().clearSelection();
        int count = this.undoables.size();
        for (int i = count - 1; i >= 0; --i) {
            TGUndoableEdit undoable = (TGUndoableEdit)this.undoables.get(i);
            undoable.undo(actionContext);
        }
        this.undoableState.undo(actionContext);
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public TGUndoableJoined endUndo() {
        this.undoableState.endUndo();
        return this;
    }

    public boolean isEmpty() {
        return this.undoables.isEmpty();
    }
}

