/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.io.persistence;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionException;
import app.tuxguitar.action.TGActionInterceptor;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.io.persistence.TGPersistenceSettingsHandler;
import app.tuxguitar.app.io.persistence.TGPersistenceSettingsManager;
import app.tuxguitar.app.io.persistence.TGPersistenceSettingsMode;
import app.tuxguitar.editor.action.file.TGSongPersistenceActionBase;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGSongStreamContext;
import app.tuxguitar.util.TGAbstractContext;
import app.tuxguitar.util.TGContext;

public class TGPersistenceSettingsInterceptor
implements TGActionInterceptor {
    private static final String ATTRIBUTE_DONE = TGPersistenceSettingsInterceptor.class.getName() + "-done";
    private static final String ATTRIBUTE_FILE_FORMAT = TGFileFormat.class.getName();
    private static final String ATTRIBUTE_STREAM_CONTEXT = TGSongStreamContext.class.getName();
    private static final String[] INTERCEPTABLE_READ_ACTIONS = new String[]{"action.song.read"};
    private static final String[] INTERCEPTABLE_WRITE_ACTIONS = new String[]{"action.file.write", "action.file.save-as", "action.file.save"};
    private TGContext context;

    public TGPersistenceSettingsInterceptor(TGContext context) {
        this.context = context;
    }

    public TGContext getContext() {
        return this.context;
    }

    public boolean isInterceptable(String id, String[] actionIds) {
        for (String actionId : actionIds) {
            if (!actionId.equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean intercept(String id, TGActionContext context) throws TGActionException {
        if (!this.isDone(context)) {
            if (this.isInterceptable(id, INTERCEPTABLE_READ_ACTIONS)) {
                return this.processSettingsHandler(id, context, TGPersistenceSettingsMode.READ);
            }
            if (this.isInterceptable(id, INTERCEPTABLE_WRITE_ACTIONS)) {
                return this.processSettingsHandler(id, context, TGPersistenceSettingsMode.WRITE);
            }
        }
        return false;
    }

    private boolean isDone(TGActionContext context) {
        return Boolean.TRUE.equals(context.hasAttribute(ATTRIBUTE_DONE));
    }

    public boolean processSettingsHandler(String id, TGActionContext actionContext, TGPersistenceSettingsMode mode) {
        TGPersistenceSettingsHandler handler;
        actionContext.setAttribute(ATTRIBUTE_DONE, (Object)Boolean.TRUE);
        TGFileFormat fileFormat = (TGFileFormat)actionContext.getAttribute(ATTRIBUTE_FILE_FORMAT);
        if (fileFormat != null && (handler = TGPersistenceSettingsManager.getInstance(this.context).findSettingsHandler(fileFormat, mode)) != null) {
            TGSongStreamContext streamContext = (TGSongStreamContext)actionContext.getAttribute(ATTRIBUTE_STREAM_CONTEXT);
            if (streamContext == null) {
                streamContext = new TGSongStreamContext();
                streamContext.addContext((TGAbstractContext)actionContext);
                actionContext.setAttribute(ATTRIBUTE_STREAM_CONTEXT, (Object)streamContext);
            }
            handler.handleSettings(streamContext, this.createCallBackThread(id, actionContext));
            return true;
        }
        return false;
    }

    public void overrideAttributes(TGActionContext actionContext) {
        TGSongStreamContext streamContext = (TGSongStreamContext)actionContext.getAttribute(ATTRIBUTE_STREAM_CONTEXT);
        if (streamContext != null) {
            this.overrideAttribute(streamContext, actionContext, TGSongPersistenceActionBase.ATTRIBUTE_FORMAT);
            this.overrideAttribute(streamContext, actionContext, "formatCode");
            this.overrideAttribute(streamContext, actionContext, "mimeType");
        }
    }

    public void overrideAttribute(TGSongStreamContext streamContext, TGActionContext actionContext, String attribute) {
        if (streamContext.hasAttribute(attribute)) {
            actionContext.setAttribute(attribute, streamContext.getAttribute(attribute));
        }
    }

    public Runnable createCallBackThread(final String id, final TGActionContext context) {
        return new Runnable(){

            @Override
            public void run() {
                new Thread(TGPersistenceSettingsInterceptor.this.createCallBackRunnable(id, context)).start();
            }
        };
    }

    public Runnable createCallBackRunnable(final String id, final TGActionContext context) {
        return new Runnable(){

            @Override
            public void run() {
                TGPersistenceSettingsInterceptor.this.overrideAttributes(context);
                TGPersistenceSettingsInterceptor.this.executeAction(id, context);
            }
        };
    }

    public void executeAction(String id, TGActionContext context) {
        TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
        tgActionManager.execute(id, context);
    }
}

