/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.io.persistence;

import app.tuxguitar.action.TGActionInterceptor;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.io.persistence.TGPersistenceSettingsHandler;
import app.tuxguitar.app.io.persistence.TGPersistenceSettingsInterceptor;
import app.tuxguitar.app.io.persistence.TGPersistenceSettingsMode;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.ArrayList;
import java.util.List;

public class TGPersistenceSettingsManager {
    private TGContext context;
    private List<TGPersistenceSettingsHandler> handlers;

    private TGPersistenceSettingsManager(TGContext context) {
        this.context = context;
        this.handlers = new ArrayList<TGPersistenceSettingsHandler>();
        this.appendListeners();
    }

    public TGContext getContext() {
        return this.context;
    }

    public void addSettingsHandler(TGPersistenceSettingsHandler handler) {
        this.handlers.add(handler);
    }

    public void removeSettingsHandler(TGPersistenceSettingsHandler handler) {
        if (this.handlers.contains(handler)) {
            this.handlers.remove(handler);
        }
    }

    public TGPersistenceSettingsHandler findSettingsHandler(TGFileFormat fileFormat, TGPersistenceSettingsMode mode) {
        for (TGPersistenceSettingsHandler handler : this.handlers) {
            if (!handler.getFileFormat().equals((Object)fileFormat) || !handler.getMode().supports(mode)) continue;
            return handler;
        }
        return null;
    }

    public void appendListeners() {
        TGActionManager.getInstance((TGContext)this.getContext()).addInterceptor((TGActionInterceptor)new TGPersistenceSettingsInterceptor(this.context));
    }

    public static TGPersistenceSettingsManager getInstance(TGContext context) {
        return (TGPersistenceSettingsManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGPersistenceSettingsManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGPersistenceSettingsManager>(){

            public TGPersistenceSettingsManager createInstance(TGContext context) {
                return new TGPersistenceSettingsManager(context);
            }
        });
    }
}

