/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.component.table;

import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.view.component.tab.Caret;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.app.view.component.table.TGTable;
import app.tuxguitar.app.view.component.table.TGTableHeader;
import app.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import app.tuxguitar.app.view.util.TGBufferedPainterLocked;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UIPaintListener;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.widget.UICanvas;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;

public class TGTableHeaderMeasures
implements TGTableHeader,
TGBufferedPainterLocked.TGBufferedPainterHandle {
    private TGTable table;
    private UICanvas canvas;
    private UIImage imgMarker;

    public TGTableHeaderMeasures(TGTable table) {
        this.table = table;
        this.canvas = this.table.getUIFactory().createCanvas((UIContainer)this.table.getColumnControl(), false);
        this.canvas.addPaintListener((UIPaintListener)new TGBufferedPainterListenerLocked(this.table.getContext(), this));
        this.canvas.addMouseMoveListener(this::headerMouseOver);
        this.canvas.addMouseExitListener(this::headerMouseExit);
        this.canvas.addMouseDownListener(this::headerClicked);
        this.table.appendListeners((UIControl)this.canvas);
        this.loadIcons();
    }

    public UICanvas getControl() {
        return this.canvas;
    }

    private void headerMouseOver(UIMouseEvent event) {
        TGMeasureHeader header = this.getMeasureHeaderAt(event.getPosition().getX());
        if (header != null && header.hasMarker()) {
            this.canvas.setToolTipText(header.getMarker().getTitle());
        } else {
            this.canvas.setToolTipText(null);
        }
        this.canvas.redraw();
    }

    private void headerMouseExit(UIMouseEvent event) {
        this.canvas.redraw();
    }

    private void headerClicked(UIMouseEvent event) {
        TGMeasureHeader header;
        if (event.getButton() == 1 && (header = this.getMeasureHeaderAt(event.getPosition().getX())) != null) {
            Tablature tablature = this.table.getViewer().getEditor().getTablature();
            Caret caret = tablature.getCaret();
            TGMeasure measure = caret.getTrack().getMeasure(header.getNumber() - 1);
            TGBeat beat = tablature.getSongManager().getMeasureManager().getFirstBeat(measure.getBeats());
            TGActionProcessor processor = new TGActionProcessor(this.table.getContext(), "action.caret.move-to");
            processor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)caret.getTrack());
            processor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
            processor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
            processor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)caret.getSelectedString());
            processor.process();
        }
    }

    private TGMeasureHeader getMeasureHeaderAt(float x) {
        Tablature tablature = this.table.getViewer().getEditor().getTablature();
        int scrollX = this.table.getViewer().getHScrollSelection();
        float cellSize = this.table.getRowHeight();
        int index = (int)Math.floor((x + (float)scrollX) / cellSize);
        return tablature.getSongManager().getMeasureHeader(tablature.getSong(), index + 1);
    }

    @Override
    public void paintControl(UIPainter painter) {
        if (!this.table.rowsAreInitialized()) {
            return;
        }
        int scrollX = this.table.getViewer().getHScrollSelection();
        float cellSize = this.table.getRowHeight();
        float width = this.canvas.getBounds().getWidth();
        Tablature tablature = this.table.getViewer().getEditor().getTablature();
        TGSong song = tablature.getSong();
        float markerMargin = 1.0f;
        float markerSize = cellSize - 2.0f * markerMargin;
        UIColor colorBackground = this.table.getViewer().getColorModel().getColor(2);
        painter.setLineWidth(0.0f);
        painter.setBackground(colorBackground);
        painter.initPath(2);
        painter.setAntialias(false);
        painter.addRectangle(0.0f, 0.0f, width, cellSize);
        painter.closePath();
        painter.setAntialias(true);
        int count = song.countMeasureHeaders();
        int j = (int)Math.floor((float)scrollX / cellSize);
        for (float x = (float)(-scrollX) + (float)j * cellSize; j < count && x < width; ++j, x += cellSize) {
            TGMeasureHeader header = song.getMeasureHeader(j);
            if (!header.hasMarker() || this.imgMarker == null || !(markerSize > 10.0f)) continue;
            painter.drawImage(this.imgMarker, 0.0f, 0.0f, this.imgMarker.getWidth(), this.imgMarker.getHeight(), x + markerMargin, markerMargin, markerSize, markerSize);
        }
    }

    @Override
    public UICanvas getPaintableControl() {
        return this.getControl();
    }

    public void loadIcons() {
        TGIconManager iconManager = TGIconManager.getInstance(this.table.getViewer().getContext());
        this.imgMarker = iconManager.getMarker();
    }
}

