/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.chord;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.dialog.chord.TGChordDialog;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UIMouseUpListener;
import app.tuxguitar.ui.event.UIPaintEvent;
import app.tuxguitar.ui.event.UIPaintListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.resource.UIPosition;
import app.tuxguitar.ui.resource.UIRectangle;
import app.tuxguitar.ui.widget.UICanvas;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIScrollBar;
import app.tuxguitar.ui.widget.UIScrollBarPanel;
import app.tuxguitar.ui.widget.UISeparator;
import app.tuxguitar.ui.widget.UITextField;
import java.util.ArrayList;
import java.util.List;

public class TGChordEditor {
    public static final int STRING_SPACING = 30;
    public static final int FRET_SPACING = 30;
    public static final short MIN_FRET = 1;
    public static final short MAX_FRET = 24;
    private TGChordDialog dialog;
    private UIPanel control;
    private UIScrollBarPanel scrollBarPanel;
    private UICanvas canvas;
    private UITextField chordName;
    private List<UIPosition> points;
    private boolean[] firstFrets;
    private int[] strings;
    private int[] frets;
    private short fret;
    private short maxStrings;
    private int width;
    private int height;
    private TGTrack currentTrack;

    public TGChordEditor(TGChordDialog dialog, UIContainer parent, short maxStrings) {
        this.dialog = dialog;
        this.createControl(parent, maxStrings);
    }

    public void createControl(UIContainer parent, short maxStrings) {
        int i;
        UIFactory uiFactory = this.dialog.getUIFactory();
        UITableLayout layout = new UITableLayout(Float.valueOf(0.0f));
        this.control = uiFactory.createPanel(parent, true);
        this.control.setLayout((UILayout)layout);
        this.fret = 1;
        this.maxStrings = maxStrings;
        this.firstFrets = new boolean[this.maxStrings];
        this.strings = new int[this.maxStrings];
        this.frets = new int[6];
        this.width = 30 * this.maxStrings - 30;
        this.height = 150;
        this.points = new ArrayList<UIPosition>();
        for (i = 0; i < this.firstFrets.length; ++i) {
            this.firstFrets[i] = false;
        }
        for (i = 0; i < this.strings.length; ++i) {
            this.strings[i] = (i + 1) * 30;
        }
        for (i = 0; i < this.frets.length; ++i) {
            this.frets[i] = (i + 1) * 30;
        }
        UITableLayout compositeLayout = new UITableLayout();
        UIPanel composite = uiFactory.createPanel((UIContainer)this.control, false);
        composite.setLayout((UILayout)compositeLayout);
        layout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout scrollBarLayout = new UITableLayout(Float.valueOf(0.0f));
        this.scrollBarPanel = uiFactory.createScrollBarPanel((UIContainer)composite, true, false, true);
        this.scrollBarPanel.setLayout((UILayout)scrollBarLayout);
        compositeLayout.set((UIControl)this.scrollBarPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.canvas = uiFactory.createCanvas((UIContainer)this.scrollBarPanel, false);
        float minimumWidth = (float)this.getWidth() + 60.0f;
        float minimumHeight = (float)this.getHeight() + 60.0f;
        scrollBarLayout.set((UIControl)this.canvas, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(minimumWidth), Float.valueOf(minimumHeight), Float.valueOf(0.0f));
        UITableLayout nameLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel nameComposite = uiFactory.createPanel((UIContainer)composite, false);
        nameComposite.setLayout((UILayout)nameLayout);
        compositeLayout.set((UIControl)nameComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        UISeparator separator = uiFactory.createHorizontalSeparator((UIContainer)nameComposite);
        nameLayout.set((UIControl)separator, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel chordNameLabel = uiFactory.createLabel((UIContainer)nameComposite);
        chordNameLabel.setText(TuxGuitar.getProperty("chord.name"));
        nameLayout.set((UIControl)chordNameLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false));
        this.chordName = uiFactory.createTextField((UIContainer)nameComposite);
        nameLayout.set((UIControl)this.chordName, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false));
        this.canvas.setBgColor(this.dialog.getColor("widget.chordEditor.backgroundColor"));
        this.canvas.addPaintListener(new UIPaintListener(){

            public void onPaint(UIPaintEvent event) {
                TGChordEditor.this.paintEditor(event.getPainter());
            }
        });
        this.canvas.addMouseUpListener(new UIMouseUpListener(){

            public void onMouseUp(UIMouseEvent event) {
                TGChordEditor.this.getComposite().setFocus();
                TGChordEditor.this.checkPoint(event.getPosition().getX(), event.getPosition().getY());
                TGChordEditor.this.redraw();
            }
        });
        final UIScrollBar uiScrollBar = this.scrollBarPanel.getVScroll();
        uiScrollBar.setIncrement(1);
        uiScrollBar.setMaximum(21);
        uiScrollBar.setMinimum(1);
        uiScrollBar.setThumb(1);
        uiScrollBar.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordEditor.this.setFret((short)uiScrollBar.getValue(), false, true);
                TGChordEditor.this.redraw();
            }
        });
    }

    private void paintEditor(UIPainter painter) {
        int i;
        int noteSize = 15;
        painter.setLineWidth(0.0f);
        UIRectangle bounds = this.canvas.getBounds();
        painter.setBackground(this.dialog.getColor("widget.chordEditor.backgroundColor"));
        painter.initPath(2);
        painter.addRectangle(0.0f, 0.0f, bounds.getWidth(), bounds.getHeight());
        painter.closePath();
        painter.setForeground(this.dialog.getColor("widget.chordEditor.foregroundColor"));
        painter.initPath();
        painter.setAntialias(false);
        painter.moveTo(20.0f, 20.0f);
        painter.lineTo((float)(30 + (this.width + 10)), 20.0f);
        painter.closePath();
        painter.drawString(Integer.toString(this.getFret()), 5.0f, 30.0f);
        painter.initPath();
        painter.setAntialias(false);
        for (i = 0; i < this.strings.length; ++i) {
            painter.moveTo((float)this.strings[i], 30.0f);
            painter.lineTo((float)this.strings[i], (float)(30 + this.height));
        }
        painter.closePath();
        painter.initPath();
        painter.setAntialias(false);
        for (i = 0; i < this.frets.length; ++i) {
            painter.moveTo(30.0f, (float)this.frets[i]);
            painter.lineTo((float)(30 + this.width), (float)this.frets[i]);
        }
        painter.closePath();
        painter.setBackground(this.dialog.getColor("widget.chordEditor.foregroundColor"));
        for (UIPosition point : this.points) {
            painter.initPath(2);
            painter.addCircle(point.getX(), point.getY() + 15.0f, (float)noteSize);
            painter.closePath();
        }
        for (int i2 = 0; i2 < this.firstFrets.length; ++i2) {
            int y;
            int x;
            if (this.hasPoints(i2)) continue;
            painter.initPath();
            if (this.firstFrets[i2]) {
                x = this.strings[i2];
                y = 30 - (noteSize - 1) / 2 - 12;
                painter.addCircle((float)x, (float)y, (float)(noteSize - 1));
            } else {
                x = this.strings[i2];
                y = 30 - noteSize - 4;
                painter.moveTo((float)(x - (noteSize / 2 - 1)), (float)(y + (noteSize / 2 - 1)));
                painter.lineTo((float)(x + (noteSize / 2 - 1)), (float)(y - (noteSize / 2 - 1)));
                painter.moveTo((float)(x - (noteSize / 2 - 1)), (float)(y - (noteSize / 2 - 1)));
                painter.lineTo((float)(x + (noteSize / 2 - 1)), (float)(y + (noteSize / 2 - 1)));
            }
            painter.closePath();
        }
    }

    private void checkPoint(float x, float y) {
        int stringIndex = this.getStringIndex(x);
        int fretIndex = this.getFretIndex(y);
        if (y < 30.0f) {
            this.firstFrets[stringIndex] = !this.firstFrets[stringIndex];
            this.removePointsAtStringLine(this.strings[stringIndex]);
        } else if (y < 180.0f) {
            UIPosition point = new UIPosition((float)this.strings[stringIndex], (float)this.frets[fretIndex]);
            if (!this.removePoint(point)) {
                this.firstFrets[stringIndex] = false;
                this.removePointsAtStringLine(this.strings[stringIndex]);
                this.addPoint(point);
                this.orderPoints();
            }
        } else {
            return;
        }
        this.dialog.getRecognizer().recognize(this.getChord(), true, false);
    }

    private boolean removePoint(UIPosition point) {
        for (UIPosition currPoint : this.points) {
            if (currPoint.getX() != point.getX() || currPoint.getY() != point.getY()) continue;
            this.points.remove(point);
            return true;
        }
        return false;
    }

    private void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            UIPosition minPoint = null;
            for (int noteIdx = i; noteIdx < this.points.size(); ++noteIdx) {
                UIPosition point = this.points.get(noteIdx);
                if (minPoint != null && !(point.getX() < minPoint.getX())) continue;
                minPoint = point;
            }
            this.points.remove(minPoint);
            this.points.add(i, minPoint);
        }
    }

    private void removePointsAtStringLine(float x) {
        for (UIPosition point : this.points) {
            if (point.getX() != x) continue;
            this.points.remove(point);
            break;
        }
    }

    private void addPoint(UIPosition point) {
        this.points.add(point);
    }

    private int getStringIndex(float x) {
        int index = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (index < 0) {
                index = i;
                continue;
            }
            float distanceX = Math.abs(x - (float)this.strings[index]);
            float currDistanceX = Math.abs(x - (float)this.strings[i]);
            if (!(currDistanceX < distanceX)) continue;
            index = i;
        }
        return index;
    }

    private int getFretIndex(float y) {
        int index = -1;
        for (int i = 0; i < this.frets.length; ++i) {
            if (index < 0) {
                index = i;
                continue;
            }
            float distanceX = Math.abs(y - (float)(this.frets[index] + 15));
            float currDistanceX = Math.abs(y - (float)(this.frets[i] + 15));
            if (!(currDistanceX < distanceX)) continue;
            index = i;
        }
        return index;
    }

    private boolean hasPoints(int stringIndex) {
        for (UIPosition point : this.points) {
            if (point.getX() != (float)this.strings[stringIndex]) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public int getValue(int string) {
        int value = -1;
        if (this.firstFrets[this.maxStrings - string]) {
            value = 0;
        }
        if (value < 0) {
            for (UIPosition point : this.points) {
                if (string != this.maxStrings - this.getStringIndex(point.getX())) continue;
                value = this.getFretIndex(point.getY() + 15.0f) + 1;
                value += this.getFret() - 1;
            }
        }
        return value;
    }

    public void addValue(int value, int string) {
        int realValue = value;
        if (string >= 1 && string <= this.maxStrings) {
            this.firstFrets[this.maxStrings - string] = false;
            this.removePointsAtStringLine(this.strings[this.maxStrings - string]);
            if (realValue == 0) {
                this.firstFrets[this.maxStrings - string] = true;
            } else if (realValue >= 0 && (realValue -= this.getFret() - 1) > 0) {
                this.addPoint(new UIPosition((float)this.strings[this.maxStrings - string], (float)this.frets[realValue - 1]));
            }
        }
    }

    public short getFret() {
        return this.fret;
    }

    public void setFret(short fret) {
        this.setFret(fret, true, false);
    }

    private void setFret(short fret, boolean updateScroll, boolean recognize) {
        if (fret >= 1 && fret <= 24) {
            this.fret = fret;
        }
        if (updateScroll) {
            this.scrollBarPanel.getVScroll().setValue((int)this.fret);
        }
        if (recognize) {
            this.dialog.getRecognizer().recognize(this.getChord(), true, false);
        }
    }

    public TGChord getChord() {
        TGChord chord = TuxGuitar.getInstance().getSongManager().getFactory().newChord(this.strings.length);
        chord.setName(this.chordName.getText());
        chord.setFirstFret((int)this.fret);
        for (int i = 0; i < chord.getStrings().length; ++i) {
            chord.addFretValue(i, this.getValue(i + 1));
        }
        return chord;
    }

    public void setChord(TGChord chord) {
        if (chord != null) {
            this.setFret((short)chord.getFirstFret());
            for (int i = 0; i < chord.getStrings().length; ++i) {
                int fretValue = chord.getFretValue(i);
                if (fretValue - chord.getFirstFret() >= 5) continue;
                this.addValue(fretValue, i + 1);
            }
            String name = chord.getName();
            this.dialog.getRecognizer().recognize(this.getChord(), name == null, name == null);
            this.previewChord(chord);
            if (name != null) {
                this.setChordName(name);
            }
            this.redraw();
        }
    }

    public short getMaxStrings() {
        return this.maxStrings;
    }

    public void setMaxStrings(short maxStrings) {
        this.maxStrings = maxStrings;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public UICanvas getComposite() {
        return this.canvas;
    }

    public UITextField getChordName() {
        return this.chordName;
    }

    public void setChordName(String chordName) {
        this.chordName.setText(chordName);
    }

    public void redraw() {
        this.canvas.redraw();
    }

    public void setCurrentTrack(TGTrack track) {
        this.currentTrack = track;
    }

    public TGTrack getCurrentTrack() {
        return this.currentTrack;
    }

    public UIPanel getControl() {
        return this.control;
    }

    public void previewChord(final TGChord chord) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int playedStrings = 0;
                int stringCount = Math.min(TGChordEditor.this.getMaxStrings(), chord.countStrings());
                for (int i = 0; i < stringCount; ++i) {
                    if (chord.getFretValue(i) == -1) continue;
                    ++playedStrings;
                }
                int next = 0;
                int[][] beat = new int[playedStrings][2];
                for (int i = 0; i < stringCount; ++i) {
                    int string = stringCount - i;
                    int value = chord.getFretValue(string - 1);
                    if (value == -1) continue;
                    beat[next][0] = TGChordEditor.this.getCurrentTrack().getOffset() + TGChordEditor.this.getCurrentTrack().getString(string).getValue() + value;
                    beat[next][1] = 95;
                    ++next;
                }
                TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
                TGChannel channel = TuxGuitar.getInstance().getSongManager().getChannel(song, TGChordEditor.this.getCurrentTrack().getChannelId());
                if (channel != null) {
                    TuxGuitar.getInstance().getPlayer().playBeat(channel.getChannelId(), (int)channel.getBank(), (int)channel.getProgram(), (int)channel.getVolume(), (int)channel.getBalance(), (int)channel.getChorus(), (int)channel.getReverb(), (int)channel.getPhaser(), (int)channel.getTremolo(), beat, 200L, 200);
                }
            }
        }).start();
    }
}

