/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.chord;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.dialog.chord.TGChordSettings;
import app.tuxguitar.app.view.dialog.chord.TGChordSettingsHandler;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UICheckBox;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;

public class TGChordSettingsDialog {
    private TGContext context;
    private UIWindow dialog;
    private UICheckBox emptyStringChords;
    private UISpinner chordsToDisplay;
    private UIDropDownSelect<Integer> typeCombo;
    private UISpinner minFret;
    private UISpinner maxFret;

    public TGChordSettingsDialog(TGContext context) {
        this.context = context;
    }

    public void open(UIWindow parent, final TGChordSettingsHandler handler) {
        UIFactory uiFactory = TGApplication.getInstance(this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(parent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("settings"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)this.dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("chord.settings.tip"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.initTypeCombo(uiFactory, (UILayoutContainer)group, 1);
        this.initChordsToDisplay(uiFactory, (UILayoutContainer)group, 2);
        this.initEmptyStringChords(uiFactory, (UILayoutContainer)group, 3);
        this.initFretSearch(uiFactory, (UILayoutContainer)group, 4);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordSettingsDialog.this.updateAndDispose(handler);
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordSettingsDialog.this.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    private void initTypeCombo(UIFactory factory, UILayoutContainer parent, int row) {
        UILabel label = factory.createLabel((UIContainer)parent);
        label.setText(TuxGuitar.getProperty("chord.settings.type") + ":");
        this.typeCombo = factory.createDropDownSelect((UIContainer)parent);
        this.typeCombo.addItem(new UISelectItem(TuxGuitar.getProperty("chord.settings.type.most-common"), (Object)0));
        this.typeCombo.addItem(new UISelectItem(TuxGuitar.getProperty("chord.settings.type.inversions"), (Object)1));
        this.typeCombo.addItem(new UISelectItem(TuxGuitar.getProperty("chord.settings.type.close-voiced"), (Object)2));
        this.typeCombo.addItem(new UISelectItem(TuxGuitar.getProperty("chord.settings.type.open-voiced"), (Object)3));
        this.typeCombo.setSelectedValue((Object)TGChordSettings.instance().getChordTypeIndex());
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)label, Integer.valueOf(row), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        uiLayout.set(this.typeCombo, Integer.valueOf(row), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(200.0f), null, null);
    }

    private void initChordsToDisplay(UIFactory factory, UILayoutContainer parent, int row) {
        UILabel label = factory.createLabel((UIContainer)parent);
        label.setText(TuxGuitar.getProperty("chord.settings.chords-to-display") + ":");
        this.chordsToDisplay = factory.createSpinner((UIContainer)parent);
        this.chordsToDisplay.setMinimum(1);
        this.chordsToDisplay.setMaximum(100);
        this.chordsToDisplay.setValue(TGChordSettings.instance().getChordsToDisplay());
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)label, Integer.valueOf(row), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        uiLayout.set((UIControl)this.chordsToDisplay, Integer.valueOf(row), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(200.0f), null, null);
    }

    private void initEmptyStringChords(UIFactory factory, UILayoutContainer parent, int row) {
        this.emptyStringChords = factory.createCheckBox((UIContainer)parent);
        this.emptyStringChords.setSelected(TGChordSettings.instance().isEmptyStringChords());
        this.emptyStringChords.setText(TuxGuitar.getProperty("chord.settings.open-chords"));
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)this.emptyStringChords, Integer.valueOf(row), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
    }

    private void initFretSearch(UIFactory factory, UILayoutContainer parent, int row) {
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = factory.createLegendPanel((UIContainer)parent);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("chord.settings.search-frets"));
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)group, Integer.valueOf(row), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        UILabel minFretLabel = factory.createLabel((UIContainer)group);
        minFretLabel.setText(TuxGuitar.getProperty("chord.settings.minimum-fret") + ":");
        this.minFret = factory.createSpinner((UIContainer)group);
        this.minFret.setMinimum(0);
        this.minFret.setMaximum(15);
        this.minFret.setValue(TGChordSettings.instance().getFindChordsMin());
        UILabel maxFretLabel = factory.createLabel((UIContainer)group);
        maxFretLabel.setText(TuxGuitar.getProperty("chord.settings.maximum-fret") + ":");
        this.maxFret = factory.createSpinner((UIContainer)group);
        this.maxFret.setMinimum(2);
        this.maxFret.setMaximum(25);
        this.maxFret.setValue(TGChordSettings.instance().getFindChordsMax());
        this.minFret.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordSettingsDialog.this.checkMinimumFretValue();
            }
        });
        this.maxFret.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordSettingsDialog.this.checkMaximumFretValue();
            }
        });
        groupLayout.set((UIControl)minFretLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        groupLayout.set((UIControl)this.minFret, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        groupLayout.set((UIControl)maxFretLabel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        groupLayout.set((UIControl)this.maxFret, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    private void checkMinimumFretValue() {
        int minSelection;
        int maxSelection = this.maxFret.getValue();
        if (maxSelection < (minSelection = this.minFret.getValue())) {
            this.maxFret.setValue(minSelection);
        }
    }

    private void checkMaximumFretValue() {
        int minSelection;
        int maxSelection = this.maxFret.getValue();
        if (maxSelection < (minSelection = this.minFret.getValue())) {
            this.maxFret.setValue(minSelection);
        }
    }

    private void update() {
        Integer type = (Integer)this.typeCombo.getSelectedValue();
        TGChordSettings.instance().setChordTypeIndex(type != null ? type : 0);
        TGChordSettings.instance().setEmptyStringChords(this.emptyStringChords.isSelected());
        TGChordSettings.instance().setChordsToDisplay(this.chordsToDisplay.getValue());
        TGChordSettings.instance().setFindChordsMax(this.maxFret.getValue());
        TGChordSettings.instance().setFindChordsMin(this.minFret.getValue());
    }

    private void dispose() {
        this.dialog.dispose();
    }

    private void updateAndDispose(TGChordSettingsHandler handler) {
        this.update();
        this.dispose();
        if (handler != null) {
            handler.onSettingsUpdated();
        }
    }
}

