/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.marker;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.util.TGProcess;
import app.tuxguitar.editor.util.TGSyncProcess;
import app.tuxguitar.editor.util.TGSyncProcessLocked;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.song.models.TGMarker;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UIMouseDoubleClickListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UITable;
import app.tuxguitar.ui.widget.UITableItem;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.List;

public class TGMarkerList
implements TGEventListener {
    private TGContext context;
    private UIWindow dialog;
    private UITable<TGMarker> table;
    private List<TGMarker> markers;
    private UIPanel compositeTable;
    private UIPanel compositeButtons;
    private UIButton buttonAdd;
    private UIButton buttonEdit;
    private UIButton buttonDelete;
    private UIButton buttonGo;
    private UIButton buttonClose;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateProcess;

    private TGMarkerList(TGContext context) {
        this.context = context;
        this.createSyncProcesses();
    }

    public void show(TGViewContext context) {
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        UITableLayout tableLayout = new UITableLayout();
        this.compositeTable = uiFactory.createPanel((UIContainer)this.dialog, false);
        this.compositeTable.setLayout((UILayout)tableLayout);
        dialogLayout.set((UIControl)this.compositeTable, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.table = uiFactory.createTable((UIContainer)this.compositeTable, true);
        this.table.setColumns(2);
        this.table.addMouseDoubleClickListener(new UIMouseDoubleClickListener(){

            public void onMouseDoubleClick(UIMouseEvent event) {
                TGMarkerList.this.goToSelectedMarker();
            }
        });
        tableLayout.set(this.table, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        tableLayout.set(this.table, "packed_width", (Object)Float.valueOf(250.0f));
        tableLayout.set(this.table, "packed_height", (Object)Float.valueOf(200.0f));
        this.loadTableItems();
        UITableLayout buttonsLayout = new UITableLayout();
        this.compositeButtons = uiFactory.createPanel((UIContainer)this.dialog, false);
        this.compositeButtons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)this.compositeButtons, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.buttonAdd = uiFactory.createButton((UIContainer)this.compositeButtons);
        this.buttonAdd.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMarkerList.this.openMarkerEditor(null);
            }
        });
        this.buttonEdit = uiFactory.createButton((UIContainer)this.compositeButtons);
        this.buttonEdit.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMarkerList.this.openMarkerEditor(TGMarkerList.this.getSelectedMarker());
            }
        });
        this.buttonDelete = uiFactory.createButton((UIContainer)this.compositeButtons);
        this.buttonDelete.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMarkerList.this.removeMarker(TGMarkerList.this.getSelectedMarker());
            }
        });
        this.buttonGo = uiFactory.createButton((UIContainer)this.compositeButtons);
        this.buttonGo.setDefaultButton();
        this.buttonGo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMarkerList.this.goToSelectedMarker();
            }
        });
        this.buttonClose = uiFactory.createButton((UIContainer)this.compositeButtons);
        this.buttonClose.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMarkerList.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)this.buttonAdd, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)this.buttonEdit, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)this.buttonDelete, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)this.buttonGo, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)this.buttonClose, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        this.loadIcons();
        this.loadProperties(false);
        this.addListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGMarkerList.this.removeListeners();
            }
        });
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getSkinManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getSkinManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public void update() {
        if (!this.isDisposed()) {
            this.loadTableItems();
        }
    }

    public void fireUpdateProcess() {
        this.updateProcess.process();
    }

    protected void loadTableItems() {
        TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
        TGMarker selection = (TGMarker)this.table.getSelectedValue();
        this.table.removeItems();
        this.markers = TuxGuitar.getInstance().getSongManager().getMarkers(song);
        for (TGMarker marker : this.markers) {
            UITableItem item = new UITableItem((Object)marker);
            item.setText(0, Integer.toString(marker.getMeasure()));
            item.setText(1, marker.getTitle());
            this.table.addItem(item);
        }
        if (selection != null) {
            this.table.setSelectedValue((Object)selection);
        }
    }

    protected TGMarker getSelectedMarker() {
        return (TGMarker)this.table.getSelectedValue();
    }

    public void goToSelectedMarker() {
        TGMarker marker = this.getSelectedMarker();
        if (marker != null) {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.marker.go-to");
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, (Object)marker);
            tgActionProcessor.process();
        }
    }

    public void openMarkerEditor(TGMarker marker) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.gui.open-marker-editor-dialog");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, (Object)marker);
        tgActionProcessor.process();
    }

    public void removeMarker(TGMarker marker) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.marker.remove");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, (Object)marker);
        tgActionProcessor.process();
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        }
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("marker.list"));
            this.table.setColumnName(0, TuxGuitar.getProperty("measure"));
            this.table.setColumnName(1, TuxGuitar.getProperty("title"));
            this.buttonAdd.setText(TuxGuitar.getProperty("add"));
            this.buttonEdit.setText(TuxGuitar.getProperty("edit"));
            this.buttonDelete.setText(TuxGuitar.getProperty("remove"));
            this.buttonGo.setText(TuxGuitar.getProperty("go"));
            this.buttonClose.setText(TuxGuitar.getProperty("close"));
            if (layout) {
                this.dialog.pack();
            }
        }
    }

    public void createSyncProcesses() {
        this.updateProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGMarkerList.this.update();
            }
        });
        this.loadIconsProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGMarkerList.this.loadIcons();
            }
        });
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGMarkerList.this.loadProperties();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 4) {
            this.fireUpdateProcess();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        } else if ("ui-skin".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        }
    }

    public static TGMarkerList getInstance(TGContext context) {
        return (TGMarkerList)TGSingletonUtil.getInstance((TGContext)context, (String)TGMarkerList.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGMarkerList>(){

            public TGMarkerList createInstance(TGContext context) {
                return new TGMarkerList(context);
            }
        });
    }
}

