/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.piano;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.editor.TGExternalBeatViewerManager;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.dialog.piano.TGPiano;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGSynchronizer;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;

public class TGPianoEditor
implements TGEventListener {
    private TGContext context;
    private TGPiano piano;
    private UIWindow window;

    public TGPianoEditor(TGContext context) {
        this.context = context;
    }

    public TGPiano getPiano() {
        return this.piano;
    }

    private UIWindow getPianoWindow() {
        return this.window;
    }

    public void show() {
        UIWindow parent = TGWindow.getInstance(this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        this.window = TGApplication.getInstance(this.context).getFactory().createWindow(parent, false, false);
        this.window.setText(TuxGuitar.getProperty("piano.editor"));
        this.window.setLayout((UILayout)dialogLayout);
        this.piano = new TGPiano(this.context, this.window);
        dialogLayout.set((UIControl)this.piano.getControl(), Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.addListeners();
        this.window.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGPianoEditor.this.removeListeners();
                TuxGuitar.getInstance().updateCache(true);
            }
        });
        TGDialogUtil.openDialog(this.window, 5);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getSkinManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getScaleManager().addListener(this);
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
        TGExternalBeatViewerManager.getInstance(this.context).addBeatViewerListener(this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getSkinManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getScaleManager().removeListener(this);
        TuxGuitar.getInstance().getEditorManager().removeRedrawListener((TGEventListener)this);
        TGExternalBeatViewerManager.getInstance(this.context).removeBeatViewerListener(this);
    }

    public boolean isDisposed() {
        return this.isWindowDisposed() || this.isPianoDisposed();
    }

    public boolean isWindowDisposed() {
        return this.window == null || this.window.isDisposed();
    }

    public boolean isPianoDisposed() {
        return this.piano == null || this.piano.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getPianoWindow().dispose();
        }
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.getPiano().redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !TuxGuitar.getInstance().isLocked()) {
            this.getPiano().redrawPlayingMode();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.getPiano().loadProperties();
            this.getPianoWindow().setText(TuxGuitar.getProperty("piano.editor"));
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.getPiano().loadIcons();
            this.getPianoWindow().setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        }
    }

    public void loadScale() {
        if (!this.isDisposed()) {
            this.getPiano().loadScale();
        }
    }

    public void showExternalBeat(TGBeat beat) {
        if (!this.isDisposed()) {
            this.getPiano().setExternalBeat(beat);
        }
    }

    public void hideExternalBeat() {
        if (!this.isDisposed()) {
            this.getPiano().setExternalBeat(null);
        }
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redraw();
        } else if (type == 3) {
            this.redrawPlayingMode();
        }
    }

    public void processExternalBeatEvent(TGEvent event) {
        if ("show".equals(event.getAttribute("action"))) {
            this.showExternalBeat((TGBeat)event.getAttribute("beat"));
        } else if ("hide".equals(event.getAttribute("action"))) {
            this.hideExternalBeat();
        }
    }

    public void processEvent(final TGEvent event) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            @Override
            public void run() {
                if ("ui-skin".equals(event.getEventType())) {
                    TGPianoEditor.this.loadIcons();
                } else if ("language".equals(event.getEventType())) {
                    TGPianoEditor.this.loadProperties();
                } else if ("ui-redraw".equals(event.getEventType())) {
                    TGPianoEditor.this.processRedrawEvent(event);
                } else if ("ui-external-beat-viewer".equals(event.getEventType())) {
                    TGPianoEditor.this.processExternalBeatEvent(event);
                } else if ("ui-scale-changed".equals(event.getEventType())) {
                    TGPianoEditor.this.loadScale();
                }
            }
        });
    }

    public static TGPianoEditor getInstance(TGContext context) {
        return (TGPianoEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TGPianoEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGPianoEditor>(){

            public TGPianoEditor createInstance(TGContext context) {
                return new TGPianoEditor(context);
            }
        });
    }
}

