/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.toolbar;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.config.TGConfigManager;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBar;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarConfig;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarConfigManager;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarConfigMap;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemConfig;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UITable;
import app.tuxguitar.ui.widget.UITableItem;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import java.util.Collections;
import java.util.List;

public class TGMainToolBarDialog {
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private TGContext context;
    private UIWindow dialog;
    private TGIconManager iconManager;
    private TGMainToolBarConfigManager configMgr;
    private TGMainToolBarConfigMap configMap = new TGMainToolBarConfigMap();
    private TGMainToolBarConfig config;
    private TGMainToolBar mainToolBar;
    private UIDropDownSelect<Integer> selectToolbarName;
    private UITextField newToolBarName;
    private UIDropDownSelect<String> selectGroup;
    private UITable<Integer> tableControls;
    private UITable<Integer> tableAreaControls;
    private UIDropDownSelect<Integer> selectArea;
    private boolean modified;
    private UIButton saveButton;
    private UIButton saveAsButton;
    private UIButton deleteButton;
    private UIButton leftButton;
    private UIButton rightButton;
    private UIButton upButton;
    private UIButton downButton;

    public TGMainToolBarDialog() {
        this.configMgr = new TGMainToolBarConfigManager();
        this.iconManager = TuxGuitar.getInstance().getIconManager();
    }

    public void show(TGViewContext context) {
        this.context = context.getContext();
        this.mainToolBar = TGMainToolBar.getInstance(this.context);
        this.config = this.mainToolBar.getConfig().clone();
        UIFactory uiFactory = TGApplication.getInstance(this.context).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("toolbar.settings"));
        UIPanel header = uiFactory.createPanel((UIContainer)this.dialog, true);
        UITableLayout headerLayout = new UITableLayout();
        header.setLayout((UILayout)headerLayout);
        this.initHeader(header, headerLayout, uiFactory);
        dialogLayout.set((UIControl)header, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIPanel controlsPanel = uiFactory.createPanel((UIContainer)this.dialog, true);
        UITableLayout controlsLayout = new UITableLayout();
        controlsPanel.setLayout((UILayout)controlsLayout);
        this.initControls(controlsPanel, controlsLayout, uiFactory);
        dialogLayout.set((UIControl)controlsPanel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIPanel buttonsPanel = uiFactory.createPanel((UIContainer)this.dialog, false);
        UITableLayout buttonsLayout = new UITableLayout();
        buttonsPanel.setLayout((UILayout)buttonsLayout);
        this.initButtons(buttonsPanel, buttonsLayout, uiFactory);
        dialogLayout.set((UIControl)buttonsPanel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.fillToolBarNames();
        this.updateButtons();
        this.addDropDownSelectionListeners();
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    private void initHeader(UIPanel panel, UITableLayout layout, UIFactory uiFactory) {
        UILabel toolbarNameLabel = uiFactory.createLabel((UIContainer)panel);
        toolbarNameLabel.setText(TuxGuitar.getProperty("toolbar.settings.toolbar-name") + ":");
        layout.set((UIControl)toolbarNameLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        this.selectToolbarName = uiFactory.createDropDownSelect((UIContainer)panel);
        layout.set(this.selectToolbarName, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.saveButton = uiFactory.createButton((UIContainer)panel);
        this.saveButton.setImage(this.iconManager.getImageByName("save.png"));
        this.saveButton.setToolTipText(TuxGuitar.getProperty("file.save"));
        this.saveButton.setEnabled(false);
        this.saveButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.save();
            }
        });
        layout.set((UIControl)this.saveButton, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        this.deleteButton = uiFactory.createButton((UIContainer)panel);
        this.deleteButton.setImage(this.iconManager.getImageByName("list_remove.png"));
        this.deleteButton.setToolTipText(TuxGuitar.getProperty("toolbar.settings.delete"));
        this.deleteButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.delete();
            }
        });
        layout.set((UIControl)this.deleteButton, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        this.newToolBarName = uiFactory.createTextField((UIContainer)panel);
        layout.set((UIControl)this.newToolBarName, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.saveAsButton = uiFactory.createButton((UIContainer)panel);
        this.saveAsButton.setToolTipText(TuxGuitar.getProperty("file.save-as"));
        this.saveAsButton.setImage(this.iconManager.getImageByName("save-as.png"));
        this.saveAsButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.saveAs();
            }
        });
        layout.set((UIControl)this.saveAsButton, Integer.valueOf(2), Integer.valueOf(3), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
    }

    private void initControls(UIPanel panel, UITableLayout layout, UIFactory uiFactory) {
        UISelectItem item;
        this.tableAreaControls = uiFactory.createTable((UIContainer)panel, false);
        this.tableAreaControls.setColumns(1);
        this.tableAreaControls.setColumnName(0, TuxGuitar.getProperty("toolbar.settings.controls-assigned"));
        boolean first = true;
        this.selectGroup = uiFactory.createDropDownSelect((UIContainer)panel);
        for (String groupName : this.configMap.getToolBarGroupsNames()) {
            String displayed = groupName == "" ? "" : TuxGuitar.getProperty(groupName);
            item = new UISelectItem(displayed, (Object)groupName);
            this.selectGroup.addItem(item);
            if (!first) continue;
            this.selectGroup.setSelectedItem(item);
            first = false;
        }
        layout.set(this.selectGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.selectArea = uiFactory.createDropDownSelect((UIContainer)panel);
        first = true;
        for (int i = 0; i < TGMainToolBar.AREAS.length; ++i) {
            int areaIndex = TGMainToolBar.AREAS[i];
            String areaName = TGMainToolBar.AREA_NAMES[i];
            item = new UISelectItem(TuxGuitar.getProperty(areaName), (Object)areaIndex);
            this.selectArea.addItem(item);
            if (!first) continue;
            this.selectArea.setSelectedItem(item);
            first = false;
        }
        layout.set(this.selectArea, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.tableControls = uiFactory.createTable((UIContainer)panel, false);
        this.tableControls.setColumns(1);
        this.tableControls.setColumnName(0, TuxGuitar.getProperty("toolbar.settings.controls"));
        this.fillControlsList();
        Float controlsListsWidth = Float.valueOf(250.0f);
        layout.set(this.tableControls, "packed_width", (Object)controlsListsWidth);
        layout.set(this.tableControls, "packed_height", (Object)Float.valueOf(450.0f));
        layout.set(this.tableControls, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIPanel leftRightPanel = uiFactory.createPanel((UIContainer)panel, false);
        UITableLayout leftRightLayout = new UITableLayout();
        leftRightPanel.setLayout((UILayout)leftRightLayout);
        this.leftButton = uiFactory.createButton((UIContainer)leftRightPanel);
        this.leftButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.removeControl();
            }
        });
        this.leftButton.setImage(this.iconManager.getImageByName("arrow_left.png"));
        leftRightLayout.set((UIControl)this.leftButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        this.rightButton = uiFactory.createButton((UIContainer)leftRightPanel);
        this.rightButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.addControl();
            }
        });
        this.rightButton.setImage(this.iconManager.getImageByName("arrow_right.png"));
        leftRightLayout.set((UIControl)this.rightButton, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        layout.set((UIControl)leftRightPanel, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.tableAreaControls.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.updateButtons();
            }
        });
        layout.set(this.tableAreaControls, "packed_width", (Object)controlsListsWidth);
        layout.set(this.tableAreaControls, "packed_height", (Object)Float.valueOf(450.0f));
        layout.set(this.tableAreaControls, Integer.valueOf(2), Integer.valueOf(3), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIPanel upDownPanel = uiFactory.createPanel((UIContainer)panel, false);
        UITableLayout upDownLayout = new UITableLayout();
        upDownPanel.setLayout((UILayout)upDownLayout);
        this.upButton = uiFactory.createButton((UIContainer)upDownPanel);
        this.upButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.moveControl(true);
            }
        });
        this.upButton.setImage(this.iconManager.getImageByName("arrow_up.png"));
        upDownLayout.set((UIControl)this.upButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        this.downButton = uiFactory.createButton((UIContainer)upDownPanel);
        this.downButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.moveControl(false);
            }
        });
        this.downButton.setImage(this.iconManager.getImageByName("arrow_down.png"));
        upDownLayout.set((UIControl)this.downButton, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        layout.set((UIControl)upDownPanel, Integer.valueOf(2), Integer.valueOf(4), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    private void initButtons(UIPanel panel, UITableLayout layout, UIFactory uiFactory) {
        UIButton buttonDefaults = uiFactory.createButton((UIContainer)panel);
        buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
        buttonDefaults.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.setDefaults();
            }
        });
        layout.set((UIControl)buttonDefaults, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        layout.set((UIControl)buttonDefaults, "minimum_packed_width", (Object)Float.valueOf(80.0f));
        UIButton buttonApply = uiFactory.createButton((UIContainer)panel);
        buttonApply.setText(TuxGuitar.getProperty("apply"));
        buttonApply.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.apply();
            }
        });
        layout.set((UIControl)buttonApply, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        layout.set((UIControl)buttonApply, "minimum_packed_width", (Object)Float.valueOf(80.0f));
        UIButton buttonOK = uiFactory.createButton((UIContainer)panel);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.OK();
            }
        });
        layout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        layout.set((UIControl)buttonOK, "minimum_packed_width", (Object)Float.valueOf(80.0f));
        UIButton buttonCancel = uiFactory.createButton((UIContainer)panel);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.dialog.dispose();
            }
        });
        layout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        layout.set((UIControl)buttonCancel, "minimum_packed_width", (Object)Float.valueOf(80.0f));
    }

    private void addDropDownSelectionListeners() {
        this.selectGroup.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.fillControlsList();
            }
        });
        this.selectArea.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.fillAreaControlsList();
            }
        });
        this.selectToolbarName.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMainToolBarDialog.this.chooseToolBar();
            }
        });
    }

    private void chooseToolBar() {
        int toolBarIndex = (Integer)this.selectToolbarName.getSelectedValue();
        String toolBarName = this.configMgr.getConfigNames().get(toolBarIndex);
        TGMainToolBarConfig config = this.configMgr.getConfig(toolBarName).clone();
        if (config != null) {
            this.modified = false;
            this.config = config;
            this.fillAreaControlsList();
        }
    }

    private void fillToolBarNames() {
        this.selectToolbarName.removeItems();
        Integer index = 0;
        for (String toolBarName : this.configMgr.getConfigNames()) {
            String displayedToolBarName = toolBarName.equals("") ? TuxGuitar.getProperty("toolbar.settings.default-maintoolbar-name") : toolBarName;
            UISelectItem item = new UISelectItem(displayedToolBarName, (Object)index);
            Integer n = index;
            index = index + 1;
            this.selectToolbarName.addItem(item);
            if (!toolBarName.equals(this.config.getName())) continue;
            this.selectToolbarName.setSelectedItem(item);
            this.fillAreaControlsList((Integer)this.selectArea.getSelectedValue());
            this.updateButtons();
        }
    }

    private void fillControlsList() {
        this.tableControls.removeItems();
        String group = (String)this.selectGroup.getSelectedValue();
        List<String> controlNames = this.configMap.getToolBarItemNames();
        for (int i = 0; i < controlNames.size(); ++i) {
            String controlName = controlNames.get(i);
            TGMainToolBarItemConfig toolBarItemConfig = this.configMap.getToolBarItemConfig(controlName);
            if (!group.equals("") && !toolBarItemConfig.getGroupName().equals("") && !group.equals(toolBarItemConfig.getGroupName())) continue;
            UITableItem uiTableItem = new UITableItem((Object)i);
            uiTableItem.setText(0, " " + TuxGuitar.getProperty(controlName));
            uiTableItem.setImage(this.iconManager.getImageByName(toolBarItemConfig.getIconFileName()));
            this.tableControls.addItem(uiTableItem);
            if (i != 0) continue;
            this.tableControls.setSelectedItem(uiTableItem);
        }
    }

    private void fillAreaControlsList() {
        int areaIndex = (Integer)this.selectArea.getSelectedValue();
        this.fillAreaControlsList(areaIndex);
    }

    private void fillAreaControlsList(int areaIndex) {
        this.fillAreaControlsList(areaIndex, 0);
    }

    private void fillAreaControlsList(int areaIndex, int selectedIndex) {
        this.tableAreaControls.removeItems();
        List<String> areaContent = this.config.getAreaContent(areaIndex);
        Integer i = 0;
        while (i < areaContent.size()) {
            String areaControlName = areaContent.get(i);
            TGMainToolBarItemConfig areaItemConfig = this.configMap.getToolBarItemConfig(areaControlName);
            if (areaItemConfig != null) {
                UITableItem uiTableItem = new UITableItem((Object)i);
                uiTableItem.setText(0, " " + TuxGuitar.getProperty(areaControlName));
                if (areaItemConfig.getIconFileName() != null) {
                    uiTableItem.setImage(this.iconManager.getImageByName(areaItemConfig.getIconFileName()));
                }
                this.tableAreaControls.addItem(uiTableItem);
                if (i == selectedIndex) {
                    this.tableAreaControls.setSelectedItem(uiTableItem);
                }
            }
            Integer n = i;
            i = i + 1;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.newToolBarName.setEnabled(true);
        String selectedToolBarName = this.configMgr.getConfigNames().get((Integer)this.selectToolbarName.getSelectedValue());
        if (this.newToolBarName.getText().equals("")) {
            this.setUntitledToolBarName();
        }
        this.saveButton.setEnabled(this.modified && !selectedToolBarName.equals(""));
        this.saveAsButton.setEnabled(true);
        this.deleteButton.setEnabled(!this.config.getName().equals(""));
        Integer areaIndex = (Integer)this.selectArea.getSelectedValue();
        Integer areaControlIndex = (Integer)this.tableAreaControls.getSelectedValue();
        int nbAreaControls = this.config.getAreaContent(areaIndex).size();
        boolean lastRightItem = this.selectArea.getSelectedValue() == TGMainToolBar.RIGHT_AREA && this.tableAreaControls.getSelectedItem() != null && (Integer)this.tableAreaControls.getSelectedValue() == this.tableAreaControls.getItemCount() - 1;
        this.leftButton.setEnabled(this.tableAreaControls.getSelectedItem() != null && !lastRightItem);
        this.rightButton.setEnabled(this.tableControls.getSelectedItem() != null);
        this.upButton.setEnabled(areaControlIndex != null && areaControlIndex != 0 && !lastRightItem);
        this.downButton.setEnabled(areaControlIndex != null && areaControlIndex < nbAreaControls - 1 && nbAreaControls > 1 && (this.selectArea.getSelectedValue() != TGMainToolBar.RIGHT_AREA || areaControlIndex < nbAreaControls - 2));
    }

    private void setUntitledToolBarName() {
        String newName = TuxGuitar.getProperty("file.save.default-name") + " ";
        int n = 1;
        List<String> toolBarNames = this.configMgr.getConfigNames();
        while (toolBarNames.contains(newName + String.valueOf(n))) {
            ++n;
        }
        this.newToolBarName.setText(newName + String.valueOf(n));
    }

    private void moveControl(boolean upDirection) {
        Integer areaIndex = (Integer)this.selectArea.getSelectedValue();
        Integer areaControlIndex = (Integer)this.tableAreaControls.getSelectedValue();
        if (areaControlIndex == null) {
            return;
        }
        int nbAreaControls = this.config.getAreaContent(areaIndex).size();
        if (!upDirection && areaControlIndex >= nbAreaControls - 1) {
            return;
        }
        if (upDirection && areaControlIndex == 0) {
            return;
        }
        this.modified = true;
        int swapped = areaControlIndex + (upDirection ? -1 : 1);
        Collections.swap(this.config.getAreaContent(areaIndex), (int)areaControlIndex, swapped);
        this.fillAreaControlsList(areaIndex, swapped);
    }

    private void removeControl() {
        Integer areaIndex = (Integer)this.selectArea.getSelectedValue();
        Integer areaControlIndex = (Integer)this.tableAreaControls.getSelectedValue();
        if (areaControlIndex == null) {
            return;
        }
        List<String> listControls = this.config.getAreaContent(areaIndex);
        listControls.remove(areaControlIndex);
        this.modified = true;
        this.fillAreaControlsList(areaIndex, Math.max(0, Math.max(0, areaControlIndex - 1)));
    }

    private void addControl() {
        Integer areaIndex = (Integer)this.selectArea.getSelectedValue();
        Integer areaControlIndex = (Integer)this.tableAreaControls.getSelectedValue();
        Integer controlIndex = (Integer)this.tableControls.getSelectedValue();
        if (controlIndex == null) {
            return;
        }
        String controlName = this.configMap.getToolBarItemNames().get(controlIndex);
        if (areaControlIndex == null || this.tableAreaControls.getItemCount() == 0) {
            areaControlIndex = 0;
        }
        this.config.getAreaContent(areaIndex).add(areaControlIndex, controlName);
        this.modified = true;
        this.fillAreaControlsList(areaIndex, areaControlIndex);
    }

    private void save() {
        this.configMgr.saveConfig(this.config);
        this.modified = false;
        this.updateButtons();
    }

    private void saveAs() {
        String newName = this.newToolBarName.getText();
        if (!newName.equals("")) {
            this.config.setName(newName);
            this.configMgr.saveConfig(this.config);
            this.modified = false;
            this.fillToolBarNames();
            this.fillAreaControlsList();
            this.setUntitledToolBarName();
        }
    }

    private void delete() {
        boolean apply = this.mainToolBar.getConfig().getName().equals(this.config.getName());
        this.configMgr.deleteConfig(this.config);
        this.setDefaults();
        if (apply) {
            this.apply();
        }
    }

    private void setDefaults() {
        this.config = this.configMgr.getDefaultConfig().clone();
        this.modified = false;
        this.fillToolBarNames();
        this.fillAreaControlsList();
    }

    private void apply() {
        this.mainToolBar.setConfig(this.config);
        this.mainToolBar.layout();
        this.mainToolBar.updateItems();
        TGConfigManager.getInstance(this.context).setValue("main-toolbar.name", this.config.getName());
    }

    private void OK() {
        this.apply();
        if (this.modified) {
            if (this.mainToolBar.getConfig().getName().equals("")) {
                this.saveAs();
                TGConfigManager.getInstance(this.context).setValue("main-toolbar.name", this.config.getName());
            } else {
                this.save();
            }
        }
        this.dialog.dispose();
    }
}

