/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.track;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionProcessorListener;
import app.tuxguitar.app.action.impl.view.TGOpenViewAction;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.dialog.confirm.TGConfirmDialog;
import app.tuxguitar.app.view.dialog.confirm.TGConfirmDialogController;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.util.TGProcess;
import app.tuxguitar.editor.util.TGSyncProcessLocked;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGColor;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.chooser.UIColorChooser;
import app.tuxguitar.ui.chooser.UIColorChooserHandler;
import app.tuxguitar.ui.event.UICloseEvent;
import app.tuxguitar.ui.event.UICloseListener;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UIFocusEvent;
import app.tuxguitar.ui.event.UIFocusLostListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIColorModel;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIReadOnlyTextField;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGMusicKeyUtils;
import java.util.List;

public class TGTrackPropertiesDialog
implements TGEventListener {
    private static final float MINIMUM_LEFT_CONTROLS_WIDTH = 180.0f;
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private static final float MINIMUM_BUTTON_HEIGHT = 25.0f;
    private static final int MIN_MAXFRET_NUMER = 12;
    private static final int MAX_MAXFRET_NUMBER = 39;
    private TGViewContext context;
    private UIWindow dialog;
    private UITextField nameText;
    private UIButton colorButton;
    private UIColor colorButtonBg;
    private UIDropDownSelect<Integer> channelSelect;
    private UIReadOnlyTextField tuningText;
    private UISpinner maxFretNumber;
    private TGProcess updateItemsProcess;

    public TGTrackPropertiesDialog(TGViewContext context) {
        this.context = context;
        this.createSyncProcesses();
    }

    public void show() {
        TGTrack track = this.findTrack();
        UIFactory factory = this.getUIFactory();
        UIWindow parent = (UIWindow)this.context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = factory.createWindow(parent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("track.properties"));
        this.initTrackInfo(track);
        this.initButtons();
        this.initListeners();
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    private void initListeners() {
        this.addListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGTrackPropertiesDialog.this.removeListeners();
            }
        });
        this.dialog.addCloseListener(new UICloseListener(){

            public void onClose(UICloseEvent event) {
                TGTrackPropertiesDialog.this.updateTrackNameMaxfret();
                TGTrackPropertiesDialog.this.dialog.dispose();
            }
        });
    }

    private void initTrackInfo(TGTrack track) {
        final UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout legendLayout = new UITableLayout();
        UILegendPanel legendPanel = factory.createLegendPanel((UIContainer)this.dialog);
        legendPanel.setLayout((UILayout)legendLayout);
        legendPanel.setText(TuxGuitar.getProperty("track.properties.general"));
        dialogLayout.set((UIControl)legendPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel nameLabel = factory.createLabel((UIContainer)legendPanel);
        nameLabel.setText(TuxGuitar.getProperty("track.name") + ":");
        legendLayout.set((UIControl)nameLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.nameText = factory.createTextField((UIContainer)legendPanel);
        this.nameText.setText(track.getName());
        this.nameText.addFocusLostListener(new UIFocusLostListener(){

            public void onFocusLost(UIFocusEvent event) {
                TGTrackPropertiesDialog.this.updateTrackNameMaxfret();
            }
        });
        legendLayout.set((UIControl)this.nameText, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UILabel colorLabel = factory.createLabel((UIContainer)legendPanel);
        colorLabel.setText(TuxGuitar.getProperty("track.color") + ":");
        legendLayout.set((UIControl)colorLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.colorButton = factory.createButton((UIContainer)legendPanel);
        this.colorButton.setText(TuxGuitar.getProperty("choose"));
        this.colorButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGColor tgColor = TGTrackPropertiesDialog.this.findTrack().getColor();
                UIColorModel colorModel = new UIColorModel();
                colorModel.setRed(tgColor.getR());
                colorModel.setGreen(tgColor.getG());
                colorModel.setBlue(tgColor.getB());
                UIColorChooser colorChooser = factory.createColorChooser(TGTrackPropertiesDialog.this.dialog);
                colorChooser.setDefaultModel(colorModel);
                colorChooser.setText(TuxGuitar.getProperty("choose-color"));
                colorChooser.choose(new UIColorChooserHandler(){

                    public void onSelectColor(UIColorModel selection) {
                        if (selection != null) {
                            TGTrackPropertiesDialog.this.updateTrackColor(selection);
                        }
                    }
                });
            }
        });
        this.colorButton.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGTrackPropertiesDialog.this.disposeColorButtonBackground();
            }
        });
        legendLayout.set((UIControl)this.colorButton, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UILabel instrumentLabel = factory.createLabel((UIContainer)legendPanel);
        instrumentLabel.setText(TuxGuitar.getProperty("instrument") + ":");
        legendLayout.set((UIControl)instrumentLabel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.channelSelect = factory.createDropDownSelect((UIContainer)legendPanel);
        this.channelSelect.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackPropertiesDialog.this.updateTrackChannel();
            }
        });
        this.updateChannelSelect();
        legendLayout.set(this.channelSelect, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton settings = factory.createButton((UIContainer)legendPanel);
        settings.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("settings.png"));
        settings.setToolTipText(TuxGuitar.getProperty("settings"));
        settings.addSelectionListener((UISelectionListener)this.createOpenViewAction("action.gui.toggle-channels-dialog"));
        legendLayout.set((UIControl)settings, Integer.valueOf(3), Integer.valueOf(3), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UILabel tuningLabel = factory.createLabel((UIContainer)legendPanel);
        tuningLabel.setText(TuxGuitar.getProperty("tuning") + ":");
        legendLayout.set((UIControl)tuningLabel, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.tuningText = factory.createReadOnlyTextField((UIContainer)legendPanel);
        legendLayout.set((UIControl)this.tuningText, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton tuningSettings = factory.createButton((UIContainer)legendPanel);
        tuningSettings.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("settings.png"));
        tuningSettings.setToolTipText(TuxGuitar.getProperty("settings"));
        tuningSettings.addSelectionListener((UISelectionListener)this.createOpenViewAction("action.gui.open-track-tuning-dialog"));
        legendLayout.set((UIControl)tuningSettings, Integer.valueOf(4), Integer.valueOf(3), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UILabel maxFretLabel = factory.createLabel((UIContainer)legendPanel);
        maxFretLabel.setText(TuxGuitar.getProperty("track.maxFret") + ":");
        legendLayout.set((UIControl)maxFretLabel, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.maxFretNumber = factory.createSpinner((UIContainer)legendPanel);
        this.maxFretNumber.setMinimum(12);
        this.maxFretNumber.setMaximum(39);
        this.maxFretNumber.setValue(track.getMaxFret());
        legendLayout.set((UIControl)this.maxFretNumber, Integer.valueOf(5), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    public TGActionProcessorListener createOpenViewAction(String actionId) {
        TGActionProcessorListener tgActionProcessor = new TGActionProcessorListener(this.context.getContext(), actionId);
        tgActionProcessor.setAttribute("parent", this.dialog);
        return tgActionProcessor;
    }

    private void initButtons() {
        UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = factory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonClose = factory.createButton((UIContainer)buttons);
        buttonClose.setText(TuxGuitar.getProperty("close"));
        buttonClose.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackPropertiesDialog.this.updateTrackNameMaxfret();
                TGTrackPropertiesDialog.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonClose, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonClose, "margin_right", (Object)Float.valueOf(0.0f));
    }

    public void updateItems() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.updateChannelSelect();
            this.updateTuningText();
            this.updateColorButton();
            this.updateMaxFretControl();
        }
    }

    private void updateColorButton() {
        TGColor tgColor = this.findTrack().getColor();
        this.colorButton.setFgColor(null);
        this.disposeColorButtonBackground();
        this.colorButtonBg = this.getUIFactory().createColor(tgColor.getR(), tgColor.getG(), tgColor.getB());
        this.colorButton.setFgColor(this.colorButtonBg);
    }

    private void disposeColorButtonBackground() {
        if (this.colorButtonBg != null && !this.colorButtonBg.isDisposed()) {
            this.colorButtonBg.dispose();
            this.colorButtonBg = null;
        }
    }

    private void updateTuningText() {
        StringBuilder label = new StringBuilder();
        boolean isValid = true;
        List tuning = this.findTrack().getStrings();
        for (int i = 0; i < tuning.size(); ++i) {
            String noteName;
            if (i > 0) {
                label.append(" ");
            }
            isValid &= (noteName = TGMusicKeyUtils.sharpNoteName((int)((TGString)tuning.get(tuning.size() - i - 1)).getValue())) != null;
            label.append(noteName);
        }
        boolean enabled = !this.isPercussionChannel();
        this.tuningText.setText(enabled && isValid ? label.toString() : "");
        this.tuningText.setEnabled(enabled);
    }

    private void updateChannelSelect() {
        this.channelSelect.setIgnoreEvents(true);
        this.channelSelect.removeItems();
        this.channelSelect.addItem(new UISelectItem(TuxGuitar.getProperty("track.instrument.default-select-option"), null));
        List channels = this.findSongManager().getChannels(this.findSong());
        for (TGChannel channel : channels) {
            this.channelSelect.addItem(new UISelectItem(channel.getName(), (Object)channel.getChannelId()));
        }
        this.channelSelect.setSelectedValue((Object)this.findTrack().getChannelId());
        this.channelSelect.setIgnoreEvents(false);
    }

    private void updateMaxFretControl() {
        this.maxFretNumber.setVisible(!this.findTrack().isPercussion());
    }

    private int getSelectedChannelId() {
        Integer selectedValue = (Integer)this.channelSelect.getSelectedValue();
        return selectedValue != null ? selectedValue : -1;
    }

    private void updateTrackNameMaxfret() {
        this.updateTrackInfo(this.nameText.getText(), this.findTrack().getColor(), this.maxFretNumber.getValue());
    }

    private void updateTrackColor(UIColorModel selection) {
        TGColor tgColor = this.findSongManager().getFactory().newColor();
        tgColor.setR(selection.getRed());
        tgColor.setG(selection.getGreen());
        tgColor.setB(selection.getBlue());
        this.updateTrackInfo(this.findTrack().getName(), tgColor, this.findTrack().getMaxFret());
    }

    private void updateTrackInfo(String name, TGColor color, int maxFret) {
        TGSong song = this.findSong();
        TGTrack track = this.findTrack();
        if (this.hasInfoChanges(name, color, maxFret)) {
            final TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.track.set-info");
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
            tgActionProcessor.setAttribute("name", (Object)name);
            tgActionProcessor.setAttribute("color", (Object)color);
            tgActionProcessor.setAttribute("offset", (Object)track.getOffset());
            tgActionProcessor.setAttribute("maxFret", (Object)maxFret);
            if (maxFret < track.getMaxFret() && maxFret < track.getHighestFret()) {
                TGActionProcessor tgActionProcessorConfirm = new TGActionProcessor(this.context.getContext(), "action.gui.open-view");
                tgActionProcessorConfirm.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGConfirmDialogController());
                tgActionProcessorConfirm.setAttribute("message", (Object)TuxGuitar.getProperty("track.confirm.reduce-fret-number", new String[]{String.valueOf(maxFret)}));
                tgActionProcessorConfirm.setAttribute("style", (Object)(TGConfirmDialog.BUTTON_YES | TGConfirmDialog.BUTTON_CANCEL));
                tgActionProcessorConfirm.setAttribute("defaultButton", (Object)TGConfirmDialog.BUTTON_CANCEL);
                tgActionProcessorConfirm.setAttribute("yesRunnable", (Object)new Runnable(){

                    @Override
                    public void run() {
                        tgActionProcessor.process();
                    }
                });
                tgActionProcessorConfirm.process();
            } else {
                tgActionProcessor.process();
            }
        }
    }

    private void updateTrackChannel() {
        TGSong song = this.findSong();
        TGTrack track = this.findTrack();
        Integer channelId = this.getSelectedChannelId();
        if (channelId > 0 && this.hasChannelChanges(channelId)) {
            TGChannel channel = this.findSongManager().getChannel(song, channelId.intValue());
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.track.set-channel");
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, (Object)channel);
            tgActionProcessor.process();
        }
    }

    private boolean hasInfoChanges(String name, TGColor color, int maxFret) {
        TGTrack track = this.findTrack();
        if (!name.equals(track.getName())) {
            return true;
        }
        if (!color.isEqual(track.getColor())) {
            return true;
        }
        return maxFret != track.getMaxFret();
    }

    private boolean hasChannelChanges(int channelId) {
        return this.findTrack().getChannelId() != channelId;
    }

    private boolean isPercussionChannel() {
        return this.findSongManager().isPercussionChannel(this.findSong(), this.findTrack().getChannelId());
    }

    public void addListeners() {
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    public TGSongManager findSongManager() {
        return (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
    }

    public TGSong findSong() {
        return (TGSong)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
    }

    public TGTrack findTrack() {
        return (TGTrack)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context.getContext()).getFactory();
    }

    public void createSyncProcesses() {
        this.updateItemsProcess = new TGSyncProcessLocked(this.context.getContext(), new Runnable(){

            @Override
            public void run() {
                TGTrackPropertiesDialog.this.updateItems();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }
}

