/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.track;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.util.TGMessageDialogUtil;
import app.tuxguitar.app.view.dialog.track.TGTrackTuningChooserHandler;
import app.tuxguitar.app.view.dialog.track.TGTrackTuningDialog;
import app.tuxguitar.app.view.dialog.track.TGTrackTuningModel;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIReadOnlyTextField;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGMusicKeyUtils;

public class TGTrackTuningChooserDialog {
    private TGTrackTuningDialog tuningDialog;

    public TGTrackTuningChooserDialog(TGTrackTuningDialog tuningDialog) {
        this.tuningDialog = tuningDialog;
    }

    public void select(TGTrackTuningChooserHandler handler) {
        this.select(handler, null);
    }

    public void select(final TGTrackTuningChooserHandler handler, TGTrackTuningModel model) {
        UIFactory uiFactory = this.tuningDialog.getUIFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(this.tuningDialog.getDialog(), true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("tuning"));
        UITableLayout panelLayout = new UITableLayout();
        UILegendPanel panel = uiFactory.createLegendPanel((UIContainer)dialog);
        panel.setLayout((UILayout)panelLayout);
        panel.setText(TuxGuitar.getProperty("tuning"));
        dialogLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel tuningValueLabel = uiFactory.createLabel((UIContainer)panel);
        tuningValueLabel.setText(TuxGuitar.getProperty("tuning.value") + ":");
        panelLayout.set((UIControl)tuningValueLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_RIGHT, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect tuningValueControl = uiFactory.createDropDownSelect((UIContainer)panel);
        tuningValueControl.addItem(new UISelectItem(TuxGuitar.getProperty("tuning.value.select")));
        for (int value = 12; value <= 127; ++value) {
            tuningValueControl.addItem(new UISelectItem(TGMusicKeyUtils.sharpNoteFullName((int)value), (Object)value));
        }
        tuningValueControl.setSelectedValue((Object)(model != null ? model.getValue() : null));
        panelLayout.set((UIControl)tuningValueControl, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        UILabel tuningSpinnerLabel = uiFactory.createLabel((UIContainer)panel);
        tuningSpinnerLabel.setText(TuxGuitar.getProperty("tuning.midi-note") + ":");
        panelLayout.set((UIControl)tuningSpinnerLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_RIGHT, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner tuningValueSpinner = uiFactory.createSpinner((UIContainer)panel);
        tuningValueSpinner.setMinimum(12);
        tuningValueSpinner.setMaximum(127);
        tuningValueSpinner.setValue(model != null ? model.getValue() : 0);
        panelLayout.set((UIControl)tuningValueSpinner, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        UILabel tuningLabelLabel = uiFactory.createLabel((UIContainer)panel);
        tuningLabelLabel.setText(TuxGuitar.getProperty("tuning.label") + ":");
        panelLayout.set((UIControl)tuningLabelLabel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_RIGHT, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIReadOnlyTextField tuningLabelControl = uiFactory.createReadOnlyTextField((UIContainer)panel);
        if (model != null) {
            tuningLabelControl.setText(TGMusicKeyUtils.sharpNoteName((int)model.getValue()));
        }
        panelLayout.set((UIControl)tuningLabelControl, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        tuningValueControl.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int noteValue = -1;
                try {
                    noteValue = (Integer)tuningValueControl.getSelectedValue();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                String noteName = TGMusicKeyUtils.sharpNoteName((int)noteValue);
                if (noteName != null) {
                    tuningLabelControl.setText(noteName);
                    tuningValueSpinner.setValue(((Integer)tuningValueControl.getSelectedValue()).intValue());
                }
            }
        });
        tuningValueSpinner.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                tuningValueControl.setSelectedValue((Object)tuningValueSpinner.getValue());
                tuningLabelControl.setText(TGMusicKeyUtils.sharpNoteName((int)((Integer)tuningValueControl.getSelectedValue())));
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGTrackTuningChooserDialog.this.handleSelection(handler, dialog, (UIDropDownSelect<Integer>)tuningValueControl)) {
                    dialog.dispose();
                }
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public boolean handleSelection(TGTrackTuningChooserHandler handler, UIWindow dialog, UIDropDownSelect<Integer> value) {
        TGTrackTuningModel model = new TGTrackTuningModel();
        model.setValue((Integer)value.getSelectedValue());
        if (model.getValue() == null) {
            TGMessageDialogUtil.errorMessage(this.tuningDialog.getContext().getContext(), dialog, TuxGuitar.getProperty("tuning.value.empty-error"));
            return false;
        }
        handler.handleSelection(model);
        return true;
    }
}

