/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.trill;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.action.effect.TGChangeTrillNoteAction;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.effects.TGEffectTrill;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIRadioButton;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGNoteRange;
import java.util.Iterator;

public class TGTrillDialog {
    private UISpinner fretSpinner;
    private UIRadioButton sixtyFourthButton;
    private UIRadioButton thirtySecondButton;
    private UIRadioButton sixTeenthButton;
    private UIRadioButton eighthButton;
    private UIRadioButton quarterButton;

    public void show(final TGViewContext context) {
        final TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
        TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        if (noteRange != null && !noteRange.isEmpty()) {
            UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
            UIWindow uiParent = (UIWindow)context.getAttribute("parent");
            UITableLayout dialogLayout = new UITableLayout();
            final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
            dialog.setLayout((UILayout)dialogLayout);
            dialog.setText(TuxGuitar.getProperty("effects.trill-editor"));
            int fret = 0;
            int duration = 0;
            Iterator it = noteRange.getNotes().iterator();
            while (it.hasNext() && duration == 0) {
                TGNote n = (TGNote)it.next();
                if (!n.getEffect().isTrill()) continue;
                fret = n.getEffect().getTrill().getFret();
                duration = n.getEffect().getTrill().getDuration().getValue();
            }
            if (duration == 0) {
                fret = ((TGNote)noteRange.getNotes().get(0)).getValue();
                duration = 16;
            }
            UITableLayout noteLayout = new UITableLayout();
            UILegendPanel noteGroup = uiFactory.createLegendPanel((UIContainer)dialog);
            noteGroup.setText(TuxGuitar.getProperty("note"));
            noteGroup.setLayout((UILayout)noteLayout);
            dialogLayout.set((UIControl)noteGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UILabel fretLabel = uiFactory.createLabel((UIContainer)noteGroup);
            fretLabel.setText(TuxGuitar.getProperty("fret") + ": ");
            noteLayout.set((UIControl)fretLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
            this.fretSpinner = uiFactory.createSpinner((UIContainer)noteGroup);
            this.fretSpinner.setValue(fret);
            this.fretSpinner.setMaximum(track.getMaxFret());
            this.fretSpinner.setMinimum(0);
            noteLayout.set((UIControl)this.fretSpinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout durationLayout = new UITableLayout();
            UILegendPanel durationGroup = uiFactory.createLegendPanel((UIContainer)dialog);
            durationGroup.setText(TuxGuitar.getProperty("duration"));
            durationGroup.setLayout((UILayout)durationLayout);
            dialogLayout.set((UIControl)durationGroup, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.sixtyFourthButton = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.sixtyFourthButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(64));
            this.sixtyFourthButton.setSelected(duration == 64);
            durationLayout.set((UIControl)this.sixtyFourthButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.thirtySecondButton = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.thirtySecondButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
            this.thirtySecondButton.setSelected(duration == 32);
            durationLayout.set((UIControl)this.thirtySecondButton, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.sixTeenthButton = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.sixTeenthButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
            this.sixTeenthButton.setSelected(duration == 16);
            durationLayout.set((UIControl)this.sixTeenthButton, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.eighthButton = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.eighthButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(8));
            this.eighthButton.setSelected(duration == 8);
            durationLayout.set((UIControl)this.eighthButton, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.quarterButton = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.quarterButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(4));
            this.quarterButton.setSelected(duration == 4);
            durationLayout.set((UIControl)this.quarterButton, Integer.valueOf(1), Integer.valueOf(5), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
            UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
            buttons.setLayout((UILayout)buttonsLayout);
            dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setDefaultButton();
            buttonOK.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGTrillDialog.this.changeTrill(context.getContext(), noteRange, TGTrillDialog.this.getTrill());
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonClean = uiFactory.createButton((UIContainer)buttons);
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            buttonClean.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGTrillDialog.this.changeTrill(context.getContext(), noteRange, null);
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonClean, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
            TGDialogUtil.openDialog(dialog, 5);
        }
    }

    public TGEffectTrill getTrill() {
        TGEffectTrill tgEffect = TuxGuitar.getInstance().getSongManager().getFactory().newEffectTrill();
        tgEffect.setFret(this.fretSpinner.getValue());
        if (this.sixtyFourthButton.isSelected()) {
            tgEffect.getDuration().setValue(64);
        } else if (this.thirtySecondButton.isSelected()) {
            tgEffect.getDuration().setValue(32);
        } else if (this.sixTeenthButton.isSelected()) {
            tgEffect.getDuration().setValue(16);
        } else if (this.eighthButton.isSelected()) {
            tgEffect.getDuration().setValue(8);
        } else if (this.eighthButton.isSelected()) {
            tgEffect.getDuration().setValue(4);
        } else {
            return null;
        }
        return tgEffect;
    }

    public void changeTrill(TGContext context, TGNoteRange noteRange, TGEffectTrill effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-trill");
        tgActionProcessor.setAttribute("note-range", (Object)noteRange);
        tgActionProcessor.setAttribute(TGChangeTrillNoteAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }
}

