/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.menu.impl;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.component.tab.Caret;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.app.view.menu.TGMenuItem;
import app.tuxguitar.app.view.menu.impl.ChordMenuItem;
import app.tuxguitar.app.view.menu.impl.DurationMenuItem;
import app.tuxguitar.app.view.menu.impl.DynamicMenuItem;
import app.tuxguitar.app.view.menu.impl.NoteEffectsMenuItem;
import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.graphics.control.TGTrackImpl;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenu;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuCheckableItem;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.menu.UIMenuSubMenuItem;
import app.tuxguitar.util.TGNoteRange;

public class BeatMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem noteMenuItem;
    private UIMenuActionItem insertRestBeat;
    private UIMenuActionItem deleteNoteOrRest;
    private UIMenuActionItem cleanBeat;
    private UIMenuActionItem insertText;
    private UIMenuActionItem voiceAuto;
    private UIMenuActionItem voiceUp;
    private UIMenuActionItem voiceDown;
    private UIMenuCheckableItem strokeUp;
    private UIMenuCheckableItem strokeDown;
    private UIMenuCheckableItem pickStrokeUp;
    private UIMenuCheckableItem pickStrokeDown;
    private UIMenuActionItem shiftUp;
    private UIMenuActionItem shiftDown;
    private UIMenuCheckableItem altEnharmonic;
    private UIMenuActionItem semitoneUp;
    private UIMenuActionItem semitoneDown;
    private UIMenuActionItem moveBeatsLeft;
    private UIMenuActionItem moveBeatsRight;
    private UIMenuActionItem moveBeatsCustom;
    private DurationMenuItem durationMenuItem;
    private DynamicMenuItem dynamicMenuItem;
    private NoteEffectsMenuItem effectMenuItem;
    private ChordMenuItem chordMenuItem;

    public BeatMenuItem(UIMenu parent) {
        this.noteMenuItem = parent.createSubMenuItem();
    }

    @Override
    public void showItems() {
        this.insertRestBeat = this.noteMenuItem.getMenu().createActionItem();
        this.insertRestBeat.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.insert-rest"));
        this.deleteNoteOrRest = this.noteMenuItem.getMenu().createActionItem();
        this.deleteNoteOrRest.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.delete-note-or-rest"));
        this.cleanBeat = this.noteMenuItem.getMenu().createActionItem();
        this.cleanBeat.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.clean-beat"));
        this.noteMenuItem.getMenu().createSeparator();
        this.durationMenuItem = new DurationMenuItem(this.noteMenuItem.getMenu().createSubMenuItem());
        this.durationMenuItem.showItems();
        this.dynamicMenuItem = new DynamicMenuItem(this.noteMenuItem.getMenu().createSubMenuItem());
        this.dynamicMenuItem.showItems();
        this.effectMenuItem = new NoteEffectsMenuItem(this.noteMenuItem.getMenu().createSubMenuItem());
        this.effectMenuItem.showItems();
        this.chordMenuItem = new ChordMenuItem(this.noteMenuItem.getMenu().createSubMenuItem());
        this.chordMenuItem.showItems();
        this.noteMenuItem.getMenu().createSeparator();
        this.insertText = this.noteMenuItem.getMenu().createActionItem();
        this.insertText.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-text-dialog"));
        this.noteMenuItem.getMenu().createSeparator();
        this.voiceAuto = this.noteMenuItem.getMenu().createActionItem();
        this.voiceAuto.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.voice-auto"));
        this.voiceUp = this.noteMenuItem.getMenu().createActionItem();
        this.voiceUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.voice-up"));
        this.voiceDown = this.noteMenuItem.getMenu().createActionItem();
        this.voiceDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.voice-down"));
        this.noteMenuItem.getMenu().createSeparator();
        this.strokeUp = this.noteMenuItem.getMenu().createCheckItem();
        this.strokeUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-stroke-up-dialog"));
        this.strokeDown = this.noteMenuItem.getMenu().createCheckItem();
        this.strokeDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-stroke-down-dialog"));
        this.pickStrokeDown = this.noteMenuItem.getMenu().createCheckItem();
        this.pickStrokeDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.change-pick-stroke-down"));
        this.pickStrokeUp = this.noteMenuItem.getMenu().createCheckItem();
        this.pickStrokeUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.change-pick-stroke-up"));
        this.noteMenuItem.getMenu().createSeparator();
        this.altEnharmonic = this.noteMenuItem.getMenu().createCheckItem();
        this.altEnharmonic.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.toggle-enharmonic"));
        this.noteMenuItem.getMenu().createSeparator();
        this.semitoneUp = this.noteMenuItem.getMenu().createActionItem();
        this.semitoneUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.increment-semitone"));
        this.semitoneDown = this.noteMenuItem.getMenu().createActionItem();
        this.semitoneDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.decrement-semitone"));
        this.noteMenuItem.getMenu().createSeparator();
        this.shiftUp = this.noteMenuItem.getMenu().createActionItem();
        this.shiftUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.shift-up"));
        this.shiftDown = this.noteMenuItem.getMenu().createActionItem();
        this.shiftDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.shift-down"));
        this.noteMenuItem.getMenu().createSeparator();
        this.moveBeatsLeft = this.noteMenuItem.getMenu().createActionItem();
        this.moveBeatsLeft.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.move-left"));
        this.moveBeatsRight = this.noteMenuItem.getMenu().createActionItem();
        this.moveBeatsRight.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.move-right"));
        this.moveBeatsCustom = this.noteMenuItem.getMenu().createActionItem();
        this.moveBeatsCustom.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-beat-move-dialog"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        Tablature tablature = TuxGuitar.getInstance().getTablatureEditor().getTablature();
        Caret caret = tablature.getCaret();
        TGBeatImpl beat = caret.getSelectedBeat();
        TGNote note = caret.getSelectedNote();
        boolean restBeat = caret.isRestBeatSelected();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        TGTrackImpl track = caret.getTrack();
        TGNoteRange noteRange = tablature.getCurrentNoteRange();
        boolean atLeastOneNoteSelected = note != null || noteRange != null && !noteRange.isEmpty();
        int style = tablature.getViewLayout().getStyle();
        this.insertRestBeat.setEnabled(!running);
        this.deleteNoteOrRest.setEnabled(!running);
        this.cleanBeat.setEnabled(!running);
        this.voiceAuto.setEnabled(!running && !restBeat);
        this.voiceUp.setEnabled(!running && !restBeat);
        this.voiceDown.setEnabled(!running && !restBeat);
        this.strokeUp.setEnabled(!running && !restBeat && !track.isPercussion());
        this.strokeUp.setChecked(beat != null && beat.getStroke().getDirection() == 1);
        this.strokeDown.setEnabled(!running && !restBeat && !track.isPercussion());
        this.strokeDown.setChecked(beat != null && beat.getStroke().getDirection() == -1);
        this.pickStrokeUp.setEnabled(!running && !restBeat);
        this.pickStrokeUp.setChecked(beat != null && beat.getPickStroke().getDirection() == 1);
        this.pickStrokeDown.setEnabled(!running && !restBeat);
        this.pickStrokeDown.setChecked(beat != null && beat.getPickStroke().getDirection() == -1);
        this.altEnharmonic.setEnabled(!running && (style & 4) != 0 && !restBeat);
        this.altEnharmonic.setChecked(note != null && note.isAltEnharmonic());
        this.semitoneUp.setEnabled(!running && atLeastOneNoteSelected);
        this.semitoneDown.setEnabled(!running && atLeastOneNoteSelected);
        this.shiftUp.setEnabled(!running && atLeastOneNoteSelected);
        this.shiftDown.setEnabled(!running && atLeastOneNoteSelected);
        this.insertText.setEnabled(!running);
        this.moveBeatsLeft.setEnabled(!running);
        this.moveBeatsRight.setEnabled(!running);
        this.moveBeatsCustom.setEnabled(!running);
        this.durationMenuItem.update();
        this.effectMenuItem.update();
        if (track.isPercussion()) {
            this.chordMenuItem.setEnabled(false);
        } else {
            this.chordMenuItem.setEnabled(true);
            this.chordMenuItem.update();
        }
        this.dynamicMenuItem.update();
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.noteMenuItem, "beat", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.cleanBeat, "beat.clean", "action.note.general.clean-beat");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.insertRestBeat, "beat.insert-rest", "action.beat.general.insert-rest");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.deleteNoteOrRest, "beat.delete-note-or-rest", "action.beat.general.delete-note-or-rest");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voiceAuto, "beat.voice-auto", "action.beat.general.voice-auto");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voiceUp, "beat.voice-up", "action.beat.general.voice-up");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voiceDown, "beat.voice-down", "action.beat.general.voice-down");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.strokeUp, "beat.stroke-up", "action.gui.open-stroke-up-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.strokeDown, "beat.stroke-down", "action.gui.open-stroke-down-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.pickStrokeUp, "beat.pick-stroke-up", "action.beat.general.change-pick-stroke-up");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.pickStrokeDown, "beat.pick-stroke-down", "action.beat.general.change-pick-stroke-down");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.altEnharmonic, "note.alternative-enharmonic", "action.note.general.toggle-enharmonic");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.semitoneUp, "note.semitone-up", "action.note.general.increment-semitone");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.semitoneDown, "note.semitone-down", "action.note.general.decrement-semitone");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.shiftUp, "note.shift-up", "action.note.general.shift-up");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.shiftDown, "note.shift-down", "action.note.general.shift-down");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.insertText, "text.insert", "action.gui.open-text-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.moveBeatsLeft, "beat.move-left", "action.beat.general.move-left");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.moveBeatsRight, "beat.move-right", "action.beat.general.move-right");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.moveBeatsCustom, "beat.move-custom", "action.gui.open-beat-move-dialog");
        this.durationMenuItem.loadProperties();
        this.chordMenuItem.loadProperties();
        this.effectMenuItem.loadProperties();
        this.dynamicMenuItem.loadProperties();
    }

    public void loadIcons() {
        this.insertText.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("text.png"));
        this.strokeUp.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("stroke_up.png"));
        this.strokeDown.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("stroke_down.png"));
        this.pickStrokeUp.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("pick_stroke_up.png"));
        this.pickStrokeDown.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("pick_stroke_down.png"));
        this.altEnharmonic.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("alt_enharmonic.png"));
    }
}

