/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.menu.impl;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.menu.TGMenuItem;
import app.tuxguitar.editor.clipboard.TGClipboard;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenu;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuCheckableItem;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.menu.UIMenuSubMenuItem;
import app.tuxguitar.util.TGContext;

public class MeasureMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem measureMenuItem;
    private UIMenuCheckableItem lineBreak;
    private UIMenuActionItem first;
    private UIMenuActionItem last;
    private UIMenuActionItem next;
    private UIMenuActionItem previous;
    private UIMenuActionItem addMeasure;
    private UIMenuActionItem cleanMeasure;
    private UIMenuActionItem removeMeasure;
    private UIMenuActionItem copyMeasure;
    private UIMenuActionItem pasteMeasure;
    private UIMenuActionItem removeVoice;

    public MeasureMenuItem(UIMenu parent) {
        this.measureMenuItem = parent.createSubMenuItem();
    }

    @Override
    public void showItems() {
        this.lineBreak = this.measureMenuItem.getMenu().createCheckItem();
        this.lineBreak.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.toggle-linebreak"));
        this.measureMenuItem.getMenu().createSeparator();
        this.first = this.measureMenuItem.getMenu().createActionItem();
        this.first.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.go-first"));
        this.previous = this.measureMenuItem.getMenu().createActionItem();
        this.previous.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.go-previous"));
        this.next = this.measureMenuItem.getMenu().createActionItem();
        this.next.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.go-next"));
        this.last = this.measureMenuItem.getMenu().createActionItem();
        this.last.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.go-last"));
        this.measureMenuItem.getMenu().createSeparator();
        this.addMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.addMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-add-dialog"));
        this.cleanMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.cleanMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-clean-dialog"));
        this.removeMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.removeMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-remove-dialog"));
        this.measureMenuItem.getMenu().createSeparator();
        this.copyMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.copyMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-copy-dialog"));
        this.pasteMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.pasteMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-paste-dialog"));
        this.measureMenuItem.getMenu().createSeparator();
        this.removeVoice = this.measureMenuItem.getMenu().createActionItem();
        this.removeVoice.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.general.remove-unused-voice"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        TGMeasureImpl measure = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        boolean isFirst = measure.getNumber() == 1;
        boolean isLast = measure.getNumber() == measure.getTrack().countMeasures();
        this.lineBreak.setEnabled(!running);
        this.lineBreak.setChecked(measure.isLineBreak());
        this.first.setEnabled(!isFirst);
        this.previous.setEnabled(!isFirst);
        this.next.setEnabled(!isLast);
        this.last.setEnabled(!isLast);
        this.addMeasure.setEnabled(!running);
        this.cleanMeasure.setEnabled(!running);
        this.removeMeasure.setEnabled(!running);
        this.copyMeasure.setEnabled(!running);
        this.pasteMeasure.setEnabled(!running && TGClipboard.getInstance((TGContext)this.findContext()).getSegment() != null);
        this.removeVoice.setEnabled(!running);
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.measureMenuItem, "measure", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.lineBreak, "measure.linebreak", "action.measure.toggle-linebreak");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.first, "measure.first", "action.measure.go-first");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.last, "measure.last", "action.measure.go-last");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.previous, "measure.previous", "action.measure.go-previous");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.next, "measure.next", "action.measure.go-next");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.addMeasure, "measure.add", "action.gui.open-measure-add-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.cleanMeasure, "measure.clean", "action.gui.open-measure-clean-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.removeMeasure, "measure.remove", "action.gui.open-measure-remove-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.copyMeasure, "measure.copy", "action.gui.open-measure-copy-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.pasteMeasure, "measure.paste", "action.gui.open-measure-paste-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.removeVoice, "measure.voice.remove-unused", "action.measure.general.remove-unused-voice");
    }

    public void loadIcons() {
        this.first.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("measure_first.png"));
        this.last.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("measure_last.png"));
        this.previous.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("measure_previous.png"));
        this.next.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("measure_next.png"));
        this.addMeasure.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("measure_add.png"));
        this.cleanMeasure.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("measure_clean.png"));
        this.removeMeasure.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("measure_remove.png"));
        this.copyMeasure.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("measure_copy.png"));
        this.pasteMeasure.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("measure_paste.png"));
    }
}

