/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.edit;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionProcessorListener;
import app.tuxguitar.app.view.dialog.chord.TGCustomChordManager;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenu;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.toolbar.UIToolActionMenuItem;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.toolbar.UIToolCheckableItem;
import app.tuxguitar.util.TGContext;
import java.util.List;

public class TGEditToolBarSectionBeat
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "beat";
    private UIToolActionMenuItem chordMenu;
    private UIToolCheckableItem text;
    private UIToolCheckableItem strokeUp;
    private UIToolCheckableItem strokeDown;
    private UIToolCheckableItem pickStrokeUp;
    private UIToolCheckableItem pickStrokeDown;

    public TGEditToolBarSectionBeat(TGEditToolBar toolBar) {
        super(toolBar, SECTION_TITLE);
    }

    @Override
    public void createSectionToolBars() {
        UIToolBar toolBar = this.createToolBar();
        this.chordMenu = toolBar.createActionMenuItem();
        this.chordMenu.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-chord-dialog"));
        toolBar.createSeparator();
        this.text = toolBar.createCheckItem();
        this.text.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-text-dialog"));
        toolBar.createSeparator();
        this.strokeUp = toolBar.createCheckItem();
        this.strokeUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-stroke-up-dialog"));
        this.strokeDown = toolBar.createCheckItem();
        this.strokeDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-stroke-down-dialog"));
        toolBar = this.createToolBar();
        this.pickStrokeDown = toolBar.createCheckItem();
        this.pickStrokeDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.change-pick-stroke-down"));
        this.pickStrokeUp = toolBar.createCheckItem();
        this.pickStrokeUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.change-pick-stroke-up"));
    }

    @Override
    public void loadSectionProperties() {
        this.chordMenu.setToolTipText(this.getText("insert.chord"));
        this.text.setToolTipText(this.getText("text.insert"));
        this.strokeUp.setToolTipText(this.getText("beat.stroke-up"));
        this.strokeDown.setToolTipText(this.getText("beat.stroke-down"));
        this.pickStrokeUp.setToolTipText(this.getText("beat.pick-stroke-up"));
        this.pickStrokeDown.setToolTipText(this.getText("beat.pick-stroke-down"));
    }

    @Override
    public void loadSectionIcons() {
        this.chordMenu.setImage(this.getIconManager().getImageByName("chord.png"));
        this.text.setImage(this.getIconManager().getImageByName("text.png"));
        this.strokeUp.setImage(this.getIconManager().getImageByName("stroke_up.png"));
        this.strokeDown.setImage(this.getIconManager().getImageByName("stroke_down.png"));
        this.pickStrokeUp.setImage(this.getIconManager().getImageByName("pick_stroke_up.png"));
        this.pickStrokeDown.setImage(this.getIconManager().getImageByName("pick_stroke_down.png"));
    }

    @Override
    public void updateSectionItems() {
        TGBeatImpl beat = this.getTablature().getCaret().getSelectedBeat();
        boolean isPercussion = this.getTablature().getCaret().getTrack().isPercussion();
        boolean running = MidiPlayer.getInstance((TGContext)this.getToolBar().getContext()).isRunning();
        this.chordMenu.setEnabled(!running && !isPercussion);
        this.text.setEnabled(!running);
        this.text.setChecked(beat.isTextBeat());
        this.strokeUp.setEnabled(!running && !beat.isRestBeat() && !isPercussion);
        this.strokeUp.setChecked(beat != null && beat.getStroke().getDirection() == 1);
        this.strokeDown.setEnabled(!running && !beat.isRestBeat() && !isPercussion);
        this.strokeDown.setChecked(beat != null && beat.getStroke().getDirection() == -1);
        this.pickStrokeUp.setEnabled(!running && !beat.isRestBeat());
        this.pickStrokeUp.setChecked(beat != null && beat.getPickStroke().getDirection() == 1);
        this.pickStrokeDown.setEnabled(!running && !beat.isRestBeat());
        this.pickStrokeDown.setChecked(beat != null && beat.getPickStroke().getDirection() == -1);
        this.updateMenuItems();
    }

    public void updateMenuItems() {
        int i;
        TGCustomChordManager customChordManager = TuxGuitar.getInstance().getCustomChordManager();
        UIMenu uiMenu = this.chordMenu.getMenu();
        List uiMenuItems = this.chordMenu.getMenu().getItems();
        for (i = customChordManager.countChords(); i < uiMenuItems.size(); ++i) {
            ((UIMenuItem)uiMenuItems.get(i)).dispose();
        }
        for (i = 0; i < customChordManager.countChords(); ++i) {
            UIMenuItem uiMenuItem;
            TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(i);
            UIMenuItem uIMenuItem = uiMenuItem = uiMenu.getItemCount() > i ? uiMenu.getItem(i) : null;
            if (uiMenuItem == null) {
                UIMenuActionItem uiMenuActionItem = uiMenu.createActionItem();
                uiMenuActionItem.addSelectionListener(new UISelectionListener(){

                    public void onSelect(UISelectionEvent event) {
                        TGEditToolBarSectionBeat.this.processInsertChordAction((TGChord)event.getComponent().getData(TGChord.class.getName()));
                    }
                });
                uiMenuItem = uiMenuActionItem;
            }
            uiMenuItem.setText(chord.getName());
            uiMenuItem.setData(TGChord.class.getName(), (Object)chord);
        }
    }

    public void processInsertChordAction(TGChord chord) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.beat.general.insert-chord");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHORD, chord);
        tgActionProcessor.process();
    }
}

