/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.main;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.view.component.tab.Caret;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.component.table.TGTableViewer;
import app.tuxguitar.app.view.dialog.channel.TGChannelManagerDialog;
import app.tuxguitar.app.view.dialog.fretboard.TGFretBoardEditor;
import app.tuxguitar.app.view.dialog.transport.TGTransportDialog;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemConfig;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemUpdater;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.editor.action.duration.TGSetDivisionTypeDurationAction;
import app.tuxguitar.editor.clipboard.TGClipboard;
import app.tuxguitar.editor.undo.TGUndoableManager;
import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.graphics.control.TGLayout;
import app.tuxguitar.graphics.control.TGLayoutHorizontal;
import app.tuxguitar.graphics.control.TGLayoutVertical;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.graphics.control.TGTrackImpl;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.song.models.TGDivisionType;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGNoteEffect;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGNoteRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TGMainToolBarConfigMap {
    private Map<String, TGMainToolBarItemConfig> mapItems = new HashMap<String, TGMainToolBarItemConfig>();
    private List<String> itemNames = new ArrayList<String>();
    private String groupName;
    private List<String> groupNames = new ArrayList<String>();

    public TGMainToolBarConfigMap() {
        TGMainToolBarItemUpdater DISABLE_ON_PLAY = new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }
        };
        this.groupName = "";
        this.registerItem("toolbar.separator", 0, 2, "separator.png");
        this.groupName = "file";
        this.registerButton("file.new", "action.song.new", "new.png");
        this.registerButton("file.open", "action.file.open", "open.png");
        this.registerButton("file.save", "action.file.save", "save.png");
        this.registerButton("file.save-as", "action.file.save-as", "save-as.png");
        this.registerButton("file.print-preview", "action.file.print-preview", "print-preview.png");
        this.registerButton("file.print", "action.file.print", "print.png");
        this.registerButton("file.close", "action.file.close-current", "close.png");
        this.groupName = "edit";
        this.registerButton("edit.cut", "action.edit.cut", "edit_cut.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning && TuxGuitar.getInstance().getTablatureEditor().getTablature().getSelector().isActive();
            }
        });
        this.registerButton("edit.copy", "action.edit.copy", "edit_copy.png", DISABLE_ON_PLAY);
        this.registerButton("edit.paste", "action.edit.paste", "edit_paste.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning && TGClipboard.getInstance((TGContext)context).hasContents();
            }
        });
        this.registerButton("edit.repeat", "action.edit.repeat", "edit_repeat.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning && TuxGuitar.getInstance().getTablatureEditor().getTablature().getSelector().isActive();
            }
        });
        this.registerButton("edit.undo", "action.edit.undo", "edit_undo.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning && TGUndoableManager.getInstance((TGContext)context).canUndo();
            }
        });
        this.registerButton("edit.redo", "action.edit.redo", "edit_redo.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning && TGUndoableManager.getInstance((TGContext)context).canRedo();
            }
        });
        this.registerCheckable("edit.mouse-mode-selection", "action.edit.set-mouse-mode-selection", "edit_mode_selection.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getTablatureEditor().getTablature().getEditorKit().getMouseMode() == 1;
            }
        });
        this.registerCheckable("edit.mouse-mode-edition", "action.edit.set-mouse-mode-edition", "edit_mode_edition.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getTablatureEditor().getTablature().getEditorKit().getMouseMode() == 2;
            }
        });
        this.registerCheckable("edit.not-natural-key", "action.edit.set-natural-key", "edit_mode_edition_no_natural.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning && TuxGuitar.getInstance().getTablatureEditor().getTablature().getEditorKit().getMouseMode() == 2;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return !TuxGuitar.getInstance().getTablatureEditor().getTablature().getEditorKit().isNatural();
            }
        });
        this.registerCheckable("edit.free-edition-mode", "action.edit.toggle-free-edition-mode", "edit_mode_free.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                Tablature tablature = TuxGuitar.getInstance().getTablatureEditor().getTablature();
                return tablature.getSongManager().isFreeEditionMode((TGMeasure)tablature.getCaret().getMeasure());
            }
        });
        this.registerButton("edit.measure-errors-dialog", "action.edit.display-errors", "measure_status_check.png", DISABLE_ON_PLAY);
        this.registerCheckable("edit.voice-1", "action.edit.voice-1", "edit_voice_1.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getTablatureEditor().getTablature().getEditorKit().getTablature().getCaret().getVoice() == 0;
            }
        });
        this.registerCheckable("edit.voice-2", "action.edit.voice-2", "edit_voice_2.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getTablatureEditor().getTablature().getEditorKit().getTablature().getCaret().getVoice() == 1;
            }
        });
        this.groupName = "view";
        this.registerCheckable("view.show-edit-toolbar", "action.gui.toggle-edit-toolbar", "toolbar_edit.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TGEditToolBar.getInstance(context).isVisible();
            }
        });
        this.registerCheckable("view.show-table-viewer", "action.gui.toggle-table-viewer", "table_viewer.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TGTableViewer.getInstance(context).isVisible();
            }
        });
        this.registerCheckable("view.show-fretboard", "action.gui.toggle-fretboard-editor", "fretboard.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TGFretBoardEditor.getInstance(context).isVisible();
            }
        });
        this.registerCheckable("view.show-instruments", "action.gui.toggle-channels-dialog", "mixer.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return !TGChannelManagerDialog.getInstance(context).isDisposed();
            }
        });
        this.registerCheckable("view.layout.page", "action.view.layout-set-page", "layout_page.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGLayout layout = TablatureEditor.getInstance(context).getTablature().getViewLayout();
                return layout instanceof TGLayoutVertical;
            }
        });
        this.registerCheckable("view.layout.linear", "action.view.layout-set-linear", "layout_linear.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGLayout layout = TablatureEditor.getInstance(context).getTablature().getViewLayout();
                return layout instanceof TGLayoutHorizontal;
            }
        });
        this.registerCheckable("view.layout.multitrack", "action.view.layout-set-multitrack", "layout_multitrack.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                int style = TablatureEditor.getInstance(context).getTablature().getViewLayout().getStyle();
                return (style & 2) != 0;
            }
        });
        this.registerCheckable("view.layout.score-enabled", "action.view.layout-set-score-enabled", "layout_score.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                int style = TablatureEditor.getInstance(context).getTablature().getViewLayout().getStyle();
                return (style & 4) != 0;
            }
        });
        this.registerCheckable("view.layout.tablature-enabled", "action.view.layout-set-tablature-enabled", "layout_tablature.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                int style = TablatureEditor.getInstance(context).getTablature().getViewLayout().getStyle();
                return (style & 8) != 0;
            }
        });
        this.registerCheckable("view.layout.compact", "action.view.layout-set-compact", "layout_compact.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                int style = TablatureEditor.getInstance(context).getTablature().getViewLayout().getStyle();
                TGSong song = TGDocumentManager.getInstance((TGContext)context).getSong();
                return (style & 2) == 0 || song.countTracks() == 1;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                int style = TablatureEditor.getInstance(context).getTablature().getViewLayout().getStyle();
                return this.enabled(context, isRunning) && (style & 1) != 0;
            }
        });
        this.registerCheckable("view.show-transport", "action.gui.toggle-transport-dialog", "transport.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return !TGTransportDialog.getInstance(context).isDisposed();
            }
        });
        this.registerCheckable("view.show-piano", "action.gui.toggle-piano-editor", "piano.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return !TuxGuitar.getInstance().getPianoEditor().isDisposed();
            }
        });
        this.registerCheckable("view.show-matrix", "action.gui.toggle-matrix-editor", "matrix.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return !TuxGuitar.getInstance().getMatrixEditor().isDisposed();
            }
        });
        TGMainToolBarItemConfig menuLayout = this.newMenu("view.layout", "layout_score.png", false);
        menuLayout.addSubItem(this.mapItems.get("view.layout.page"));
        menuLayout.addSubItem(this.mapItems.get("view.layout.linear"));
        menuLayout.addSubItem(this.mapItems.get("view.layout.multitrack"));
        menuLayout.addSubItem(this.mapItems.get("view.layout.score-enabled"));
        menuLayout.addSubItem(this.mapItems.get("view.layout.compact"));
        this.registerItem(menuLayout);
        this.registerButton("view.zoom.out", "action.view.layout-decrement-scale", "zoom_out.png");
        this.registerButton("view.zoom.reset", "action.view.layout-reset-scale", "zoom_original.png");
        this.registerButton("view.zoom.in", "action.view.layout-increment-scale", "zoom_in.png");
        this.groupName = "composition";
        this.registerButton("composition.timesignature", "action.gui.open-time-signature-dialog", "timesignature.png", DISABLE_ON_PLAY);
        this.registerButton("composition.tempo", "action.gui.open-tempo-dialog", "tempoicon.png", DISABLE_ON_PLAY);
        this.registerButton("composition.clef", "action.gui.open-clef-dialog", "clef.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                boolean isPercussion = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().isPercussion();
                return !isRunning && !isPercussion;
            }
        });
        this.registerButton("composition.keysignature", "action.gui.open-key-signature-dialog", "keysignature.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                boolean isPercussion = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().isPercussion();
                return !isRunning && !isPercussion;
            }
        });
        this.registerButton("composition.tripletfeel", "action.gui.open-triplet-feel-dialog", "tripletfeel.png", DISABLE_ON_PLAY);
        this.registerButton("repeat.open", "action.insert.open-repeat", "openrepeat.png", DISABLE_ON_PLAY);
        this.registerButton("repeat.close", "action.gui.open-repeat-close-dialog", "closerepeat.png", DISABLE_ON_PLAY);
        this.registerButton("repeat.alternative", "action.gui.open-repeat-alternative-dialog", "repeat_alternative.png", DISABLE_ON_PLAY);
        this.registerButton("composition.properties", "action.gui.open-song-info-dialog", "song_properties.png", DISABLE_ON_PLAY);
        this.groupName = "track";
        this.registerButton("track.add", "action.track.add-new", "track_add.png", DISABLE_ON_PLAY);
        this.registerButton("track.remove", "action.track.remove", "track_remove.png", DISABLE_ON_PLAY);
        this.registerButton("track.first", "action.track.go-first", "track_first.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                TGTrackImpl track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
                boolean isFirst = track.getNumber() == 1;
                return !isFirst;
            }
        });
        this.registerButton("track.previous", "action.track.go-previous", "track_previous.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                TGTrackImpl track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
                boolean isFirst = track.getNumber() == 1;
                return !isFirst;
            }
        });
        this.registerButton("track.next", "action.track.go-next", "track_next.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                TGTrackImpl track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
                boolean isLast = track.getNumber() == track.getSong().countTracks();
                return !isLast;
            }
        });
        this.registerButton("track.last", "action.track.go-last", "track_last.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                TGTrackImpl track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
                boolean isLast = track.getNumber() == track.getSong().countTracks();
                return !isLast;
            }
        });
        this.registerButton("track.clone", "action.track.clone", "track_clone.png", DISABLE_ON_PLAY);
        this.registerButton("track.move-up", "action.track.move-up", "arrow_up.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                TGTrackImpl track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
                return !isRunning && track.getSong().countTracks() > 1;
            }
        });
        this.registerButton("track.move-down", "action.track.move-down", "arrow_down.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                TGTrackImpl track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
                return !isRunning && track.getSong().countTracks() > 1;
            }
        });
        this.registerCheckable("track.solo", "action.track.change-solo", "track_solo.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().isSolo();
            }
        });
        this.registerCheckable("track.mute", "action.track.change-mute", "track_mute.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().isMute();
            }
        });
        this.groupName = "measure";
        this.registerButton("measure.add", "action.gui.open-measure-add-dialog", "measure_add.png", DISABLE_ON_PLAY);
        this.registerButton("measure.clean", "action.gui.open-measure-clean-dialog", "measure_clean.png", DISABLE_ON_PLAY);
        this.registerButton("measure.remove", "action.gui.open-measure-remove-dialog", "measure_remove.png", DISABLE_ON_PLAY);
        this.registerButton("measure.copy", "action.gui.open-measure-copy-dialog", "measure_copy.png", DISABLE_ON_PLAY);
        this.registerButton("measure.paste", "action.gui.open-measure-paste-dialog", "measure_paste.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning && TGClipboard.getInstance((TGContext)context).getSegment() != null;
            }
        });
        this.groupName = "beat";
        this.registerButton("insert.chord", "action.gui.open-chord-dialog", "chord.png", DISABLE_ON_PLAY);
        this.registerButton("text.insert", "action.gui.open-text-dialog", "text.png", DISABLE_ON_PLAY);
        this.registerCheckable("beat.stroke-down", "action.gui.open-stroke-down-dialog", "stroke_down.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
                boolean restBeat = caret.isRestBeatSelected();
                return !isRunning && !restBeat && !caret.getTrack().isPercussion();
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGBeatImpl beat = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedBeat();
                return beat != null && beat.getStroke().getDirection() == -1;
            }
        });
        this.registerCheckable("beat.stroke-up", "action.gui.open-stroke-up-dialog", "stroke_up.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
                boolean restBeat = caret.isRestBeatSelected();
                return !isRunning && !restBeat && !caret.getTrack().isPercussion();
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGBeatImpl beat = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedBeat();
                return beat != null && beat.getStroke().getDirection() == 1;
            }
        });
        this.registerCheckable("beat.pick-stroke-down", "action.beat.general.change-pick-stroke-down", "pick_stroke_down.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                boolean restBeat = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().isRestBeatSelected();
                return !isRunning && !restBeat;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGBeatImpl beat = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedBeat();
                return beat != null && beat.getPickStroke().getDirection() == -1;
            }
        });
        this.registerCheckable("beat.pick-stroke-up", "action.beat.general.change-pick-stroke-up", "pick_stroke_up.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                boolean restBeat = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().isRestBeatSelected();
                return !isRunning && !restBeat;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGBeatImpl beat = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedBeat();
                return beat != null && beat.getPickStroke().getDirection() == 1;
            }
        });
        this.registerCheckable("note.alternative-enharmonic", "action.note.general.toggle-enharmonic", "alt_enharmonic.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                boolean restBeat = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().isRestBeatSelected();
                int style = TuxGuitar.getInstance().getTablatureEditor().getTablature().getViewLayout().getStyle();
                return !isRunning && (style & 4) != 0 && !restBeat;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGNote note = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
                return note != null && note.isAltEnharmonic();
            }
        });
        this.groupName = "duration";
        this.registerCheckable("duration.whole", "action.note.duration.set-whole", "1.png", this.getDurationUpdater(1));
        this.registerCheckable("duration.half", "action.note.duration.set-half", "2.png", this.getDurationUpdater(2));
        this.registerCheckable("duration.quarter", "action.note.duration.set-quarter", "4.png", this.getDurationUpdater(4));
        this.registerCheckable("duration.eighth", "action.note.duration.set-eighth", "8.png", this.getDurationUpdater(8));
        this.registerCheckable("duration.sixteenth", "action.note.duration.set-sixteenth", "16.png", this.getDurationUpdater(16));
        this.registerCheckable("duration.thirtysecond", "action.note.duration.set-thirty-second", "32.png", this.getDurationUpdater(32));
        this.registerCheckable("duration.sixtyfourth", "action.note.duration.set-sixty-fourth", "64.png", this.getDurationUpdater(64));
        TGMainToolBarItemConfig menuDuration = this.newMenu("duration", "duration.png", true);
        menuDuration.addSubItem(this.mapItems.get("duration.whole"));
        menuDuration.addSubItem(this.mapItems.get("duration.half"));
        menuDuration.addSubItem(this.mapItems.get("duration.quarter"));
        menuDuration.addSubItem(this.mapItems.get("duration.eighth"));
        menuDuration.addSubItem(this.mapItems.get("duration.sixteenth"));
        menuDuration.addSubItem(this.mapItems.get("duration.thirtysecond"));
        menuDuration.addSubItem(this.mapItems.get("duration.sixtyfourth"));
        this.registerItem(menuDuration);
        this.registerCheckable("duration.dotted", "action.note.duration.change-dotted", "dotted.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration().isDotted();
            }
        });
        this.registerCheckable("duration.doubledotted", "action.note.duration.change-double-dotted", "doubledotted.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration().isDoubleDotted();
            }
        });
        this.registerCheckable("duration.tiednote", "action.note.duration.tied", "tiednote.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGNote note = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
                return note != null && note.isTiedNote();
            }
        });
        TGMainToolBarItemConfig menuDivisionType = this.newMenu("duration.division-type", "division-type.png", true);
        for (int i = 0; i < TGDivisionType.DIVISION_TYPES.length; ++i) {
            this.registerItem(this.getCheckableDivision(i, menuDivisionType));
        }
        this.registerItem(menuDivisionType);
        this.groupName = "dynamic";
        this.registerItem(this.getCheckableVelocity("dynamic.piano-pianissimo", 15, "dynamic_ppp.png"));
        this.registerItem(this.getCheckableVelocity("dynamic.pianissimo", 31, "dynamic_pp.png"));
        this.registerItem(this.getCheckableVelocity("dynamic.piano", 47, "dynamic_p.png"));
        this.registerItem(this.getCheckableVelocity("dynamic.mezzo-piano", 63, "dynamic_mp.png"));
        this.registerItem(this.getCheckableVelocity("dynamic.mezzo-forte", 79, "dynamic_mf.png"));
        this.registerItem(this.getCheckableVelocity("dynamic.forte", 95, "dynamic_f.png"));
        this.registerItem(this.getCheckableVelocity("dynamic.fortissimo", 111, "dynamic_ff.png"));
        this.registerItem(this.getCheckableVelocity("dynamic.forte-fortissimo", 127, "dynamic_fff.png"));
        TGMainToolBarItemConfig menuDynamic = this.newMenu("dynamic", "dynamic.png", true);
        menuDynamic.addSubItem(this.mapItems.get("dynamic.piano-pianissimo"));
        menuDynamic.addSubItem(this.mapItems.get("dynamic.pianissimo"));
        menuDynamic.addSubItem(this.mapItems.get("dynamic.piano"));
        menuDynamic.addSubItem(this.mapItems.get("dynamic.mezzo-piano"));
        menuDynamic.addSubItem(this.mapItems.get("dynamic.mezzo-forte"));
        menuDynamic.addSubItem(this.mapItems.get("dynamic.forte"));
        menuDynamic.addSubItem(this.mapItems.get("dynamic.fortissimo"));
        menuDynamic.addSubItem(this.mapItems.get("dynamic.forte-fortissimo"));
        this.registerItem(menuDynamic);
        this.groupName = "effects";
        this.registerItem(this.getCheckableEffect("effects.vibrato", "action.note.effect.change-vibrato", "effect_vibrato.png", false, e -> e.isVibrato()));
        this.registerItem(this.getCheckableEffect("effects.bend", "action.gui.open-bend-dialog", "effect_bend.png", false, e -> e.isBend()));
        this.registerItem(this.getCheckableEffect("effects.tremolo-bar", "action.gui.open-tremolo-bar-dialog", "effect_tremolo_bar.png", false, e -> e.isTremoloBar()));
        this.registerItem(this.getCheckableEffect("effects.deadnote", "action.note.effect.change-dead", "effect_dead.png", false, e -> e.isDeadNote()));
        this.registerItem(this.getCheckableEffect("effects.slide", "action.note.effect.change-slide", "effect_slide.png", false, e -> e.isSlide()));
        this.registerItem(this.getCheckableEffect("effects.hammer", "action.note.effect.change-hammer", "effect_hammer.png", false, e -> e.isHammer()));
        this.registerItem(this.getCheckableEffect("effects.ghostnote", "action.note.effect.change-ghost", "effect_ghost.png", true, e -> e.isGhostNote()));
        this.registerItem(this.getCheckableEffect("effects.accentuatednote", "action.note.effect.change-accentuated", "effect_accentuated.png", true, e -> e.isAccentuatedNote()));
        this.registerItem(this.getCheckableEffect("effects.heavyaccentuatednote", "action.note.effect.change-heavy-accentuated", "effect_heavy_accentuated.png", true, e -> e.isHeavyAccentuatedNote()));
        this.registerItem(this.getCheckableEffect("effects.let-ring", "action.note.effect.change-let-ring", "effect_let_ring.png", false, e -> e.isLetRing()));
        this.registerItem(this.getCheckableEffect("effects.harmonic", "action.gui.open-harmonic-dialog", "effect_harmonic.png", false, e -> e.isHarmonic()));
        this.registerItem(this.getCheckableEffect("effects.grace", "action.gui.open-grace-dialog", "effect_grace.png", true, e -> e.isGrace()));
        this.registerItem(this.getCheckableEffect("effects.trill", "action.gui.open-trill-dialog", "effect_trill.png", false, e -> e.isTrill()));
        this.registerItem(this.getCheckableEffect("effects.tremolo-picking", "action.gui.open-tremolo-picking-dialog", "effect_tremolo_picking.png", true, e -> e.isTremoloPicking()));
        this.registerItem(this.getCheckableEffect("effects.palm-mute", "action.note.effect.change-palm-mute", "effect_palm_mute.png", false, e -> e.isPalmMute()));
        this.registerItem(this.getCheckableEffect("effects.staccato", "action.note.effect.change-staccato", "effect_staccato.png", false, e -> e.isStaccato()));
        this.registerItem(this.getCheckableEffect("effects.tapping", "action.note.effect.change-tapping", "effect_tapping.png", false, e -> e.isTapping()));
        this.registerItem(this.getCheckableEffect("effects.slapping", "action.note.effect.change-slapping", "effect_slapping.png", false, e -> e.isSlapping()));
        this.registerItem(this.getCheckableEffect("effects.popping", "action.note.effect.change-popping", "effect_popping.png", false, e -> e.isPopping()));
        this.registerItem(this.getCheckableEffect("effects.fade-in", "action.note.effect.change-fade-in", "effect_fade_in.png", false, e -> e.isFadeIn()));
        this.groupName = "marker";
        this.registerButton("marker.add", "action.gui.open-marker-editor-dialog", "marker_add.png");
        this.registerButton("marker.list", "action.gui.toggle-marker-list", "marker_list.png");
        this.registerButton("marker.first", "action.marker.go-first", "marker_first.png");
        this.registerButton("marker.previous", "action.marker.go-previous", "marker_previous.png");
        this.registerButton("marker.next", "action.marker.go-next", "marker_next.png");
        this.registerButton("marker.last", "action.marker.go-last", "marker_last.png");
        TGMainToolBarItemConfig menuMarker = this.newMenu("marker", "marker_list.png", false);
        menuMarker.addSubItem(this.mapItems.get("marker.add"));
        menuMarker.addSubItem(this.mapItems.get("marker.list"));
        menuMarker.addSubItem(this.mapItems.get("toolbar.separator"));
        menuMarker.addSubItem(this.mapItems.get("marker.first"));
        menuMarker.addSubItem(this.mapItems.get("marker.previous"));
        menuMarker.addSubItem(this.mapItems.get("marker.next"));
        menuMarker.addSubItem(this.mapItems.get("marker.last"));
        this.mapItems.put(menuMarker.getText(), menuMarker);
        this.registerItem(menuMarker);
        this.groupName = "transport";
        this.registerButton("transport.first", "action.measure.go-first", "transport_icon_first.png");
        this.registerButton("transport.previous", "action.measure.go-previous", "transport_icon_previous.png");
        this.registerButton("transport.start", "action.transport.play", "transport_icon_play.png", new TGMainToolBarItemUpdater(){

            @Override
            public String getIconName(TGContext context, boolean isRunning) {
                return isRunning ? "transport_icon_pause.png" : "transport_icon_play.png";
            }

            @Override
            public String getText(TGContext context, boolean isRunning) {
                return isRunning ? "transport.pause" : "transport.start";
            }
        });
        this.registerButton("transport.stop", "action.transport.stop", "transport_icon_stop.png");
        this.registerButton("transport.next", "action.measure.go-next", "transport_icon_next.png");
        this.registerButton("transport.last", "action.measure.go-last", "transport_icon_last.png");
        this.registerItem("toolbar.timeCounter", 4, 1, "transport_time_counter.png");
        this.registerItem("toolbar.tempoIndicator", 5, 3, "tempoindicator.png");
        this.registerCheckable("transport.metronome", "action.transport.metronome", "transport_metronome.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return MidiPlayer.getInstance((TGContext)context).isMetronomeEnabled();
            }
        });
        this.registerCheckable("transport.count-down", "action.transport.count-down", "transport_count_in.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                return MidiPlayer.getInstance((TGContext)context).getCountDown().isEnabled();
            }
        });
        this.registerButton("transport.mode", "action.gui.open-transport-mode-dialog", "transport_mode.png");
        this.registerCheckable("transport.set-loop-start", "action.transport.set-loop-start", "transport_loop_start.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getPlayer().getMode().isLoop();
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGMeasureImpl measure = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure();
                return measure != null && measure.getNumber() == TuxGuitar.getInstance().getPlayer().getMode().getLoopSHeader();
            }
        });
        this.registerCheckable("transport.set-loop-end", "action.transport.set-loop-end", "transport_loop_end.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return TuxGuitar.getInstance().getPlayer().getMode().isLoop();
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGMeasureImpl measure = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure();
                return measure != null && measure.getNumber() == TuxGuitar.getInstance().getPlayer().getMode().getLoopEHeader();
            }
        });
        this.registerCheckable("transport.highlight-played-beat", "action.transport.highlight-played-beat", "highlight_played_beat.png", new TGMainToolBarItemUpdater(){

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                int style = TablatureEditor.getInstance(context).getTablature().getViewLayout().getStyle();
                return (style & 0x80) != 0;
            }
        });
        this.groupName = "tools";
        this.registerButton("tools.plugins", "action.gui.open-plugin-list-dialog", "tools_plugins.png");
        this.registerButton("tools.shortcuts", "action.gui.open-key-binding-editor", "tools_shortcuts.png");
        this.registerButton("tools.settings", "action.gui.open-settings-editor", "tools_settings.png");
        this.groupName = "help";
        this.registerButton("help.doc", "action.gui.open-documentation-dialog", "help_doc.png");
        this.registerButton("help.about", "action.gui.open-about-dialog", "help_about.png");
        this.registerButton("help.goHome", "action.gui.go-to-homepage", "browser_root.png");
        this.groupName = "settings";
        this.registerButton("toolbar.settings", "action.gui.open-maintoolbar-settings-dialog", "settings.png", DISABLE_ON_PLAY);
    }

    private TGMainToolBarItemUpdater getDurationUpdater(final int value) {
        return new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGDuration duration = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration();
                return duration.getValue() == value;
            }
        };
    }

    private TGMainToolBarItemConfig getCheckableEffect(String text, String actionName, String iconFileName, final boolean forPercussion, final EffectApplied applied) {
        TGMainToolBarItemUpdater updater = new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                TGNoteRange noteRange = TablatureEditor.getInstance(context).getTablature().getCurrentNoteRange();
                boolean isPercussion = TablatureEditor.getInstance(context).getTablature().getCaret().getTrack().isPercussion();
                return !isRunning && !noteRange.isEmpty() && (forPercussion || !isPercussion);
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGNote note = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
                return note != null && note.getEffect() != null && applied.isEffectApplied(note.getEffect());
            }
        };
        TGMainToolBarItemConfig config = new TGMainToolBarItemConfig(this.groupName, text, 2, 2, actionName, iconFileName, updater, false);
        return config;
    }

    private TGMainToolBarItemConfig getCheckableVelocity(String text, final int value, String iconFileName) {
        String actionName = "action.note.general.velocity";
        TGMainToolBarItemUpdater updater = new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGNote note = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
                int velocity = note != null ? note.getVelocity() : TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getVelocity();
                return velocity == value;
            }
        };
        TGMainToolBarItemConfig config = new TGMainToolBarItemConfig(this.groupName, text, 2, 2, actionName, iconFileName, updater, false);
        config.setAttribute("velocity", value);
        return config;
    }

    private TGMainToolBarItemConfig getCheckableDivision(final int index, TGMainToolBarItemConfig menuDivisionType) {
        int enters = TGDivisionType.DIVISION_TYPES[index].getEnters();
        String text = "duration.division-type." + Integer.toString(enters);
        String actionName = "action.note.duration.set-division-type";
        String iconFileName = TGIconManager.getDivisionTypeIconFileName(enters);
        TGMainToolBarItemUpdater updater = new TGMainToolBarItemUpdater(){

            @Override
            public boolean enabled(TGContext context, boolean isRunning) {
                return !isRunning;
            }

            @Override
            public boolean checked(TGContext context, boolean isRunning) {
                TGDuration duration = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration();
                return duration.getDivision().isEqual(TGDivisionType.DIVISION_TYPES[index]);
            }
        };
        TGMainToolBarItemConfig config = new TGMainToolBarItemConfig(this.groupName, text, 2, 2, actionName, iconFileName, updater, false);
        config.setAttribute(TGSetDivisionTypeDurationAction.PROPERTY_DIVISION_TYPE, TGDivisionType.DIVISION_TYPES[index]);
        menuDivisionType.addSubItem(config);
        return config;
    }

    private void registerItem(TGMainToolBarItemConfig toolBarItemConfig) {
        this.mapItems.put(toolBarItemConfig.getText(), toolBarItemConfig);
        this.itemNames.add(toolBarItemConfig.getText());
        if (!this.groupNames.contains(this.groupName)) {
            this.groupNames.add(this.groupName);
        }
    }

    private void registerButton(String text, String actionName, String iconFileName, TGMainToolBarItemUpdater updater) {
        this.registerItem(new TGMainToolBarItemConfig(this.groupName, text, 1, 2, actionName, iconFileName, updater, false));
    }

    private void registerButton(String text, String actionName, String iconFileName) {
        this.registerItem(new TGMainToolBarItemConfig(this.groupName, text, 1, 2, actionName, iconFileName, null, false));
    }

    private void registerCheckable(String text, String actionName, String iconFileName, TGMainToolBarItemUpdater updater) {
        this.registerItem(new TGMainToolBarItemConfig(this.groupName, text, 2, 2, actionName, iconFileName, updater, false));
    }

    private TGMainToolBarItemConfig newMenu(String text, String iconFileName, boolean displaySelectedItemIcon) {
        return new TGMainToolBarItemConfig(this.groupName, text, 3, 2, null, iconFileName, null, displaySelectedItemIcon);
    }

    private void registerItem(String text, int type, int sectionType, String iconFileName) {
        this.registerItem(new TGMainToolBarItemConfig(this.groupName, text, type, sectionType, iconFileName));
    }

    public List<String> getToolBarGroupsNames() {
        return this.groupNames;
    }

    public List<String> getToolBarItemNames() {
        return this.itemNames;
    }

    public TGMainToolBarItemConfig getToolBarItemConfig(String name) {
        return this.mapItems.get(name);
    }

    private static interface EffectApplied {
        public boolean isEffectApplied(TGNoteEffect var1);
    }
}

