/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.ui.swt.appearance;

import app.tuxguitar.ui.appearance.UIAppearance;
import app.tuxguitar.ui.appearance.UIColorAppearance;
import app.tuxguitar.ui.resource.UIColorModel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class SWTAppearance
implements UIAppearance {
    private Display display;
    private Map<UIColorAppearance, UIColorModel> colorMap;

    public SWTAppearance(Display display) {
        this.display = display;
        this.createColorResolvers();
    }

    public void createColorResolvers() {
        this.colorMap = new HashMap<UIColorAppearance, UIColorModel>();
        this.colorMap.put(UIColorAppearance.WidgetBackground, this.createColorModel(22));
        this.colorMap.put(UIColorAppearance.WidgetForeground, this.createColorModel(21));
        this.colorMap.put(UIColorAppearance.WidgetLightBackground, this.createColorModel(22, 20));
        this.colorMap.put(UIColorAppearance.WidgetLightForeground, this.createColorModel(21));
        this.colorMap.put(UIColorAppearance.WidgetHighlightBackground, this.createColorModel(20));
        this.colorMap.put(UIColorAppearance.WidgetHighlightForeground, this.createColorModel(21));
        this.colorMap.put(UIColorAppearance.WidgetSelectedBackground, this.createColorModel(22, 18));
        this.colorMap.put(UIColorAppearance.WidgetSelectedForeground, this.createColorModel(27));
        this.colorMap.put(UIColorAppearance.InputBackground, this.createColorModel(25));
        this.colorMap.put(UIColorAppearance.InputForeground, this.createColorModel(24));
        this.colorMap.put(UIColorAppearance.InputSelectedBackground, this.createColorModel(26));
        this.colorMap.put(UIColorAppearance.InputSelectedForeground, this.createColorModel(27));
    }

    public UIColorModel createColorModel(int style) {
        Color color = this.display.getSystemColor(style);
        return new UIColorModel(color.getRed(), color.getGreen(), color.getBlue());
    }

    public UIColorModel createColorModel(int style1, int style2) {
        Color c1 = this.display.getSystemColor(style1);
        Color c2 = this.display.getSystemColor(style2);
        return new UIColorModel((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    public UIColorModel getColorModel(UIColorAppearance colorAppearance) {
        if (this.colorMap.containsKey(colorAppearance)) {
            return this.colorMap.get(colorAppearance);
        }
        return new UIColorModel(0, 0, 0);
    }
}

