/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.ui.swt.widget;

import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.swt.event.SWTSelectionListenerManager;
import app.tuxguitar.ui.swt.widget.SWTContainer;
import app.tuxguitar.ui.swt.widget.SWTControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UISelectItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class SWTDropDownSelect<T>
extends SWTControl<Combo>
implements UIDropDownSelect<T> {
    private List<UISelectItem<T>> uiItems;
    private SWTSelectionListenerManager selectionListener = new SWTSelectionListenerManager(this);

    public SWTDropDownSelect(SWTContainer<? extends Composite> parent) {
        super(new Combo(parent.getControl(), 12), parent);
        this.uiItems = new ArrayList<UISelectItem<T>>();
    }

    public T getSelectedValue() {
        UISelectItem<T> selectedItem = this.getSelectedItem();
        return (T)(selectedItem != null ? selectedItem.getValue() : null);
    }

    public void setSelectedValue(T value) {
        this.setSelectedItem(new UISelectItem(null, value));
    }

    public UISelectItem<T> getSelectedItem() {
        int index = ((Combo)this.getControl()).getSelectionIndex();
        return index >= 0 && index < this.uiItems.size() ? this.uiItems.get(index) : null;
    }

    public void setSelectedItem(UISelectItem<T> item) {
        int index = item != null ? this.uiItems.indexOf(item) : -1;
        ((Combo)this.getControl()).select(index);
    }

    public void addItem(UISelectItem<T> item) {
        this.uiItems.add(item);
        ((Combo)this.getControl()).add(item.getText());
    }

    public void removeItem(UISelectItem<T> item) {
        int index;
        int n = index = item != null ? this.uiItems.indexOf(item) : -1;
        if (index >= 0 && index < this.uiItems.size()) {
            ((Combo)this.getControl()).remove(index);
            this.uiItems.remove(item);
        }
    }

    public void removeItems() {
        ArrayList<UISelectItem<T>> uiItems = new ArrayList<UISelectItem<T>>(this.uiItems);
        for (UISelectItem uISelectItem : uiItems) {
            this.removeItem(uISelectItem);
        }
    }

    public int getItemCount() {
        return this.uiItems.size();
    }

    public void addSelectionListener(UISelectionListener listener) {
        if (this.selectionListener.isEmpty()) {
            ((Combo)this.getControl()).addSelectionListener((SelectionListener)this.selectionListener);
        }
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionListener.removeListener(listener);
        if (this.selectionListener.isEmpty()) {
            ((Combo)this.getControl()).removeSelectionListener((SelectionListener)this.selectionListener);
        }
    }
}

