/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.ui.swt.widget;

import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.resource.UIRectangle;
import app.tuxguitar.ui.swt.event.SWTSelectionListenerManager;
import app.tuxguitar.ui.swt.resource.SWTImage;
import app.tuxguitar.ui.swt.widget.SWTContainer;
import app.tuxguitar.ui.swt.widget.SWTControl;
import app.tuxguitar.ui.widget.UITable;
import app.tuxguitar.ui.widget.UITableItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SWTTable<T>
extends SWTControl<Table>
implements UITable<T> {
    public static final int TABLE_STYLE = 67588;
    public static final int TABLE_COLUMN_MARGIN = 4;
    private SWTSelectionListenerManager selectionListener = new SWTSelectionListenerManager(this);
    private SWTTableUpdateManager updateManager = new SWTTableUpdateManager(this);

    public SWTTable(SWTContainer<? extends Composite> parent, boolean headerVisible, int style) {
        super(new Table(parent.getControl(), style), parent);
        ((Table)this.getControl()).setHeaderVisible(false);
        ((Table)this.getControl()).addListener(9, (Listener)this.updateManager);
    }

    public SWTTable(SWTContainer<? extends Composite> parent, boolean headerVisible) {
        this(parent, headerVisible, 67588);
    }

    public void setColumns(int columns) {
        int count;
        int i;
        for (i = count = ((Table)this.getControl()).getColumnCount(); i < columns; ++i) {
            new TableColumn((Table)this.getControl(), 0);
        }
        for (i = columns; i < count; ++i) {
            ((Table)this.getControl()).getColumn(i).dispose();
        }
    }

    public int getColumns() {
        return ((Table)this.getControl()).getColumnCount();
    }

    public void setColumnName(int column, String name) {
        if (column >= 0 && column < this.getColumns()) {
            ((Table)this.getControl()).setHeaderVisible(true);
            TableColumn tableColumn = ((Table)this.getControl()).getColumn(column);
            tableColumn.setText(name);
            if (this.isVisible()) {
                this.updateManager.setUpdateRequired();
            }
        }
    }

    public String getColumnName(int column) {
        if (column >= 0 && column < this.getColumns()) {
            return ((Table)this.getControl()).getColumn(column).getText();
        }
        return null;
    }

    public T getSelectedValue() {
        UITableItem<T> selectedItem = this.getSelectedItem();
        return (T)(selectedItem != null ? selectedItem.getValue() : null);
    }

    public void setSelectedValue(T value) {
        this.setSelectedItem(new UITableItem(value));
    }

    public UITableItem<T> getSelectedItem() {
        TableItem[] tableItems = ((Table)this.getControl()).getSelection();
        return tableItems != null && tableItems.length > 0 ? (UITableItem)tableItems[0].getData() : null;
    }

    public void setSelectedItem(UITableItem<T> item) {
        TableItem tableItem = this.getTableItem(item);
        if (tableItem != null) {
            ((Table)this.getControl()).setSelection(tableItem);
        } else {
            ((Table)this.getControl()).deselectAll();
        }
    }

    public void addItem(UITableItem<T> item) {
        TableItem tableItem = new TableItem((Table)this.getControl(), 0);
        tableItem.setData(item);
        if (item.getImage() != null && !item.getImage().isDisposed()) {
            tableItem.setImage(((SWTImage)item.getImage()).getHandle());
        }
        int columns = this.getColumns();
        for (int i = 0; i < columns; ++i) {
            String text = item.getText(i);
            if (text == null) continue;
            tableItem.setText(i, text);
        }
        if (this.isVisible()) {
            this.updateManager.setUpdateRequired();
        }
    }

    public TableItem getTableItem(UITableItem<T> item) {
        if (item != null) {
            TableItem[] tableItems;
            for (TableItem tableItem : tableItems = ((Table)this.getControl()).getItems()) {
                if (tableItem.getData() == null || !tableItem.getData().equals(item)) continue;
                return tableItem;
            }
        }
        return null;
    }

    public void removeItem(UITableItem<T> item) {
        TableItem tableItem = this.getTableItem(item);
        if (tableItem != null) {
            tableItem.dispose();
        }
    }

    public void removeItems() {
        ((Table)this.getControl()).removeAll();
    }

    public UITableItem<T> getItem(int index) {
        TableItem tableItem;
        if (index >= 0 && index < this.getItemCount() && (tableItem = ((Table)this.getControl()).getItem(index)) != null) {
            return (UITableItem)tableItem.getData();
        }
        return null;
    }

    public T getItemValue(int index) {
        UITableItem<T> item = this.getItem(index);
        if (item != null) {
            return (T)item.getValue();
        }
        return null;
    }

    public int getItemCount() {
        return ((Table)this.getControl()).getItemCount();
    }

    @Override
    public void computePackedSize(Float fixedWidth, Float fixedHeight) {
        this.adjustColumnsWidth();
        super.computePackedSize(fixedWidth, fixedHeight);
    }

    @Override
    public void setBounds(UIRectangle bounds) {
        super.setBounds(bounds);
        this.fillAvailableWidth();
    }

    public void adjustColumnsWidth() {
        TableColumn[] tableColumns;
        for (TableColumn tableColumn : tableColumns = ((Table)this.getControl()).getColumns()) {
            this.adjustColumnWidth(tableColumn);
        }
    }

    public void adjustColumnWidth(TableColumn column) {
        int minimumWidth = 0;
        String headerText = column.getText();
        if (headerText != null && headerText.length() > 0) {
            GC gc = new GC((Drawable)this.getControl());
            minimumWidth = gc.stringExtent((String)headerText).x + 8;
            gc.dispose();
        }
        column.pack();
        if (column.getWidth() < minimumWidth) {
            column.setWidth(minimumWidth);
        }
    }

    public void fillAvailableWidth() {
        TableColumn[] columns = ((Table)this.getControl()).getColumns();
        if (columns.length > 0) {
            int availableWidth = ((Table)this.getControl()).getClientArea().width;
            for (TableColumn column : columns) {
                availableWidth -= column.getWidth();
            }
            if (availableWidth > 0) {
                TableColumn lastColumn = columns[columns.length - 1];
                lastColumn.setWidth(lastColumn.getWidth() + availableWidth);
            }
        }
    }

    public void addSelectionListener(UISelectionListener listener) {
        if (this.selectionListener.isEmpty()) {
            ((Table)this.getControl()).addSelectionListener((SelectionListener)this.selectionListener);
        }
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionListener.removeListener(listener);
        if (this.selectionListener.isEmpty()) {
            ((Table)this.getControl()).removeSelectionListener((SelectionListener)this.selectionListener);
        }
    }

    private class SWTTableUpdateManager
    implements Listener {
        private SWTTable<?> table;
        private boolean updateRequired;

        public SWTTableUpdateManager(SWTTable<?> table) {
            this.table = table;
        }

        public void handleEvent(Event e) {
            if (this.updateRequired) {
                this.updateRequired = false;
                this.table.adjustColumnsWidth();
            }
        }

        public void setUpdateRequired() {
            this.updateRequired = true;
        }
    }
}

