/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.lilypond;

import app.tuxguitar.app.io.persistence.TGPersistenceSettingsHandler;
import app.tuxguitar.app.io.persistence.TGPersistenceSettingsMode;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGSongStreamContext;
import app.tuxguitar.io.lilypond.LilypondSettings;
import app.tuxguitar.io.lilypond.LilypondSettingsDialog;
import app.tuxguitar.io.lilypond.LilypondSongWriter;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGSynchronizer;

public class LilypondSettingsHandler
implements TGPersistenceSettingsHandler {
    private TGContext context;

    public LilypondSettingsHandler(TGContext context) {
        this.context = context;
    }

    public TGFileFormat getFileFormat() {
        return LilypondSongWriter.FILE_FORMAT;
    }

    public TGPersistenceSettingsMode getMode() {
        return TGPersistenceSettingsMode.WRITE;
    }

    public void handleSettings(final TGSongStreamContext context, final Runnable callback) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            @Override
            public void run() {
                TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
                final LilypondSettings settings = LilypondSettings.getDefaults();
                new LilypondSettingsDialog(LilypondSettingsHandler.this.context, song).open(settings, new Runnable(){

                    @Override
                    public void run() {
                        if (settings != null) {
                            context.setAttribute(LilypondSettings.class.getName(), (Object)settings);
                            callback.run();
                        }
                    }
                });
            }
        });
    }
}

