/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.jack;

import app.tuxguitar.jack.JackPort;
import app.tuxguitar.jack.JackPortRegisterListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JackClient {
    private static final String JNI_LIBRARY_NAME = new String("tuxguitar-jack-jni");
    private long instance = this.malloc();
    private boolean openTransport;
    private List<JackPort> jackPorts = new ArrayList<JackPort>();
    private List<JackPortRegisterListener> jackPortRegisterListeners = new ArrayList<JackPortRegisterListener>();

    public void finalize() {
        if (this.instance != 0L) {
            this.free(this.instance);
            this.instance = 0L;
        }
    }

    public void open() {
        if (this.instance != 0L && !this.isOpen()) {
            this.open(this.instance);
        }
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean force) {
        if (force) {
            this.closePorts();
            this.closeTransport();
        }
        if (!this.isAnyJackPortOpen() && !this.isTransportOpen() && this.isOpen()) {
            this.close(this.instance);
        }
    }

    public boolean isOpen() {
        if (this.instance != 0L) {
            return this.isOpen(this.instance);
        }
        return false;
    }

    public JackPort openPort(String jackPortName) {
        if (this.isOpen()) {
            long jackPortId;
            JackPort jackPort = this.findPort(jackPortName);
            if (jackPort != null && !this.isPortOpen(jackPort)) {
                this.closePort(jackPort);
                jackPort = null;
            }
            if (jackPort == null && (jackPortId = this.openPort(this.instance, jackPortName)) != 0L) {
                jackPort = new JackPort(jackPortId, jackPortName);
                this.jackPorts.add(jackPort);
                this.onPortRegistered();
            }
            return jackPort;
        }
        return null;
    }

    public void closePort(JackPort jackPort) {
        JackPort jackPortToClose;
        if (this.isOpen() && (jackPortToClose = this.findPort(jackPort.getJackPortName())) != null) {
            this.closePort(this.instance, jackPortToClose.getJackPortId());
            this.jackPorts.remove(jackPortToClose);
        }
    }

    public void closePorts() {
        if (this.isOpen()) {
            ArrayList<JackPort> jackPorts = new ArrayList<JackPort>(this.jackPorts);
            Iterator it = jackPorts.iterator();
            while (it.hasNext()) {
                this.closePort((JackPort)it.next());
            }
        }
    }

    public JackPort findPort(String jackPortName) {
        if (this.isOpen()) {
            for (JackPort jackPort : this.jackPorts) {
                if (!jackPort.getJackPortName().equals(jackPortName)) continue;
                return jackPort;
            }
        }
        return null;
    }

    public boolean isPortOpen(JackPort jackPort) {
        if (this.isOpen()) {
            return this.isPortOpen(this.instance, jackPort.getJackPortId());
        }
        return false;
    }

    public boolean isAnyJackPortOpen() {
        return this.isOpen() && !this.jackPorts.isEmpty();
    }

    public boolean isTransportOpen() {
        return this.isOpen() && this.openTransport;
    }

    public void openTransport() {
        if (this.isOpen() && !this.openTransport) {
            this.openTransport = true;
        }
    }

    public void closeTransport() {
        if (this.isOpen() && this.openTransport) {
            this.openTransport = false;
        }
        this.close(false);
    }

    public void addEventToQueue(JackPort jackPort, byte[] data) {
        if (this.isOpen()) {
            this.addEventToQueue(this.instance, jackPort.getJackPortId(), data);
        }
    }

    public long getTransportUID() {
        if (this.isOpen()) {
            return this.getTransportUID(this.instance);
        }
        return 0L;
    }

    public long getTransportFrame() {
        if (this.isOpen()) {
            return this.getTransportFrame(this.instance);
        }
        return 0L;
    }

    public long getTransportFrameRate() {
        if (this.isOpen()) {
            return this.getTransportFrameRate(this.instance);
        }
        return 0L;
    }

    public void setTransportFrame(long frame) {
        if (this.isOpen()) {
            this.setTransportFrame(this.instance, frame);
        }
    }

    public void setTransportStart() {
        if (this.isOpen()) {
            this.setTransportStart(this.instance);
        }
    }

    public void setTransportStop() {
        if (this.isOpen()) {
            this.setTransportStop(this.instance);
        }
    }

    public boolean isTransportRunning() {
        if (this.isOpen()) {
            return this.isTransportRunning(this.instance);
        }
        return false;
    }

    public List<String> getPortNames(String type, long flags) {
        if (this.isOpen()) {
            return this.getPortNames(this.instance, type, flags);
        }
        return null;
    }

    public List<String> getPortConnections(String portName) {
        if (this.isOpen()) {
            return this.getPortConnections(this.instance, portName);
        }
        return null;
    }

    public void connectPorts(String srcPortName, String dstPortName) {
        if (this.isOpen()) {
            this.connectPorts(this.instance, srcPortName, dstPortName);
        }
    }

    public void onPortRegistered() {
        for (JackPortRegisterListener jackPortRegisterListener : this.jackPortRegisterListeners) {
            jackPortRegisterListener.onPortRegistered();
        }
    }

    public void addPortRegisterListener(JackPortRegisterListener listener) {
        if (!this.jackPortRegisterListeners.contains(listener)) {
            this.jackPortRegisterListeners.add(listener);
        }
    }

    public void removePortRegisterListener(JackPortRegisterListener listener) {
        if (this.jackPortRegisterListeners.contains(listener)) {
            this.jackPortRegisterListeners.remove(listener);
        }
    }

    private native long malloc();

    private native void free(long var1);

    private native void open(long var1);

    private native void close(long var1);

    private native long openPort(long var1, String var3);

    private native void closePort(long var1, long var3);

    private native long getTransportUID(long var1);

    private native long getTransportFrame(long var1);

    private native long getTransportFrameRate(long var1);

    private native void setTransportFrame(long var1, long var3);

    private native void setTransportStart(long var1);

    private native void setTransportStop(long var1);

    private native void addEventToQueue(long var1, long var3, byte[] var5);

    private native boolean isOpen(long var1);

    private native boolean isPortOpen(long var1, long var3);

    private native boolean isTransportRunning(long var1);

    private native void connectPorts(long var1, String var3, String var4);

    private native List<String> getPortNames(long var1, String var3, long var4);

    private native List<String> getPortConnections(long var1, String var3);

    static {
        System.loadLibrary(JNI_LIBRARY_NAME);
    }
}

