/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.jack.connection;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.jack.JackClient;
import app.tuxguitar.jack.JackPortTypes;
import app.tuxguitar.jack.connection.JackConnection;
import app.tuxguitar.jack.connection.JackConnectionConfig;
import app.tuxguitar.jack.connection.JackConnectionListener;
import app.tuxguitar.jack.provider.JackClientProvider;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JackConnectionManager {
    private JackClient jackClient;
    private JackClientProvider jackClientProvider;
    private JackConnectionListener jackConnectionListener;
    private JackConnectionConfig jackConnectionConfig;
    private List<JackConnection> jackConnections;
    private boolean autoConnectPorts;

    public JackConnectionManager(TGContext context, JackClientProvider jackClientProvider) {
        this.jackClientProvider = jackClientProvider;
        this.jackConnectionConfig = new JackConnectionConfig(context, this);
        this.jackConnectionListener = new JackConnectionListener(context, this);
        this.jackConnections = new ArrayList<JackConnection>();
    }

    public void initialize() {
        if (this.jackClient == null) {
            this.jackConnections.clear();
            this.jackClient = this.jackClientProvider.getJackClient();
            this.jackClient.addPortRegisterListener(this.jackConnectionListener);
            this.loadConfig();
            this.openJackClient(true);
            if (this.isAutoConnectPorts() && this.isJackClientOpen()) {
                this.connectAllPorts();
            }
        }
    }

    public void destroy() {
        if (this.jackClient != null) {
            this.jackConnections.clear();
            this.jackClient.removePortRegisterListener(this.jackConnectionListener);
            this.jackClient = null;
        }
    }

    public void openJackClient(boolean quiet) throws TGException {
        if (!this.isJackClientOpen() && this.jackClient != null) {
            this.jackClient.open();
        }
        if (!this.isJackClientOpen() && !quiet) {
            throw new TGException(TuxGuitar.getProperty((String)"jack.error.not-running"));
        }
    }

    public void loadConfig() {
        this.jackConnectionConfig.load();
    }

    public void saveConfig() {
        this.jackConnectionConfig.save();
    }

    public void connectAllPorts() {
        this.openJackClient(false);
        for (JackConnection jackConnection : this.jackConnections) {
            this.connectPorts(jackConnection);
        }
    }

    public void connectPorts(JackConnection jackConnection) {
        this.openJackClient(false);
        List<String> portNames = this.jackClient.getPortNames(JackPortTypes.JACK_ALL_TYPES, 0L);
        String srcPortName = this.findPortNameById(jackConnection.getSrcPortId(), portNames);
        String dstPortName = this.findPortNameById(jackConnection.getDstPortId(), portNames);
        if (srcPortName != null && dstPortName != null) {
            this.jackClient.connectPorts(srcPortName, dstPortName);
        }
    }

    public void loadExistingConnections() {
        this.openJackClient(false);
        ArrayList<JackConnection> existingConnections = new ArrayList<JackConnection>();
        List<String> existingPortNames = this.jackClient.getPortNames(JackPortTypes.JACK_ALL_TYPES, 0L);
        this.loadExistingConnections(existingConnections);
        this.loadPreviousConnectionsToExistingList(existingConnections, existingPortNames);
        this.jackConnections.clear();
        this.jackConnections.addAll(existingConnections);
    }

    public void loadExistingConnections(List<JackConnection> existingConnections) {
        this.openJackClient(false);
        List<String> srcPortNames = this.jackClient.getPortNames(JackPortTypes.JACK_ALL_TYPES, 2L);
        if (srcPortNames != null) {
            Iterator<String> it = srcPortNames.iterator();
            while (it.hasNext()) {
                this.loadExistingConnections(existingConnections, it.next());
            }
        }
    }

    public void loadExistingConnections(List<JackConnection> existingConnections, String srcPortName) {
        this.openJackClient(false);
        List<String> dstPortNames = this.jackClient.getPortConnections(srcPortName);
        if (dstPortNames != null) {
            Iterator<String> it = dstPortNames.iterator();
            while (it.hasNext()) {
                this.loadExistingConnection(existingConnections, srcPortName, it.next());
            }
        }
    }

    public void loadExistingConnection(List<JackConnection> existingConnections, String srcPortName, String dstPortName) {
        this.openJackClient(false);
        JackConnection jackConnection = new JackConnection(this.createPortId(srcPortName), this.createPortId(dstPortName));
        if (!existingConnections.contains(jackConnection)) {
            existingConnections.add(jackConnection);
        }
    }

    public void loadPreviousConnectionsToExistingList(List<JackConnection> existingConnections, List<String> existingPortNames) {
        this.openJackClient(false);
        for (JackConnection jackConnection : this.jackConnections) {
            String srcPortName = this.findPortNameById(jackConnection.getSrcPortId(), existingPortNames);
            String dstPortName = this.findPortNameById(jackConnection.getDstPortId(), existingPortNames);
            if (srcPortName != null && dstPortName != null) continue;
            existingConnections.add(jackConnection);
        }
    }

    public String findPortNameById(long portId) {
        this.openJackClient(false);
        return this.findPortNameById(portId, this.jackClient.getPortNames(JackPortTypes.JACK_ALL_TYPES, 0L));
    }

    public String findPortNameById(long portId, List<String> portNames) {
        this.openJackClient(false);
        if (portNames != null) {
            for (String portName : portNames) {
                if (portId != this.createPortId(portName)) continue;
                return portName;
            }
        }
        return null;
    }

    public long createPortId(String portName) {
        return portName.hashCode();
    }

    public boolean isJackClientOpen() {
        return this.jackClient != null && this.jackClient.isOpen();
    }

    public void clearJackConnections() {
        this.jackConnections.clear();
    }

    public void addJackConnection(JackConnection jackConnection) {
        if (!this.jackConnections.contains(jackConnection)) {
            this.jackConnections.add(jackConnection);
        }
    }

    public List<JackConnection> getJackConnections() {
        return this.jackConnections;
    }

    public boolean isAutoConnectPorts() {
        return this.autoConnectPorts;
    }

    public void setAutoConnectPorts(boolean autoConnectPorts) {
        this.autoConnectPorts = autoConnectPorts;
    }
}

