/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.jack.synthesizer;

import app.tuxguitar.jack.JackClient;
import app.tuxguitar.jack.JackPort;
import app.tuxguitar.player.base.MidiChannel;
import app.tuxguitar.player.base.MidiPlayerException;

public class JackChannel
implements MidiChannel {
    private int channel1;
    private int channel2;
    private JackPort jackPort;
    private JackClient jackClient;

    public JackChannel(JackClient jackClient, JackPort jackPort) {
        this.jackClient = jackClient;
        this.jackPort = jackPort;
        this.channel1 = 0;
        this.channel2 = 0;
    }

    public void sendAllNotesOff() throws MidiPlayerException {
        this.sendControlChange(123, 0);
    }

    public void sendNoteOn(int key, int velocity, int voice, boolean bendMode) throws MidiPlayerException {
        byte[] event = new byte[]{(byte)(0x90 | this.resolveChannel(bendMode)), (byte)key, (byte)velocity};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendNoteOff(int key, int velocity, int voice, boolean bendMode) throws MidiPlayerException {
        byte[] event = new byte[]{(byte)(0x80 | this.resolveChannel(bendMode)), (byte)key, (byte)velocity};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendPitchBend(int value, int voice, boolean bendMode) throws MidiPlayerException {
        byte[] event = new byte[]{(byte)(0xE0 | this.resolveChannel(bendMode)), 0, (byte)value};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendProgramChange(int value) throws MidiPlayerException {
        this.sendProgramChange(value, this.channel1);
        if (this.channel1 != this.channel2) {
            this.sendProgramChange(value, this.channel2);
        }
    }

    public void sendProgramChange(int value, int channel) throws MidiPlayerException {
        byte[] event = new byte[]{(byte)(0xC0 | channel), (byte)value};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendControlChange(int controller, int value) throws MidiPlayerException {
        this.sendControlChange(controller, value, this.channel1);
        if (this.channel1 != this.channel2) {
            this.sendControlChange(controller, value, this.channel2);
        }
    }

    public void sendControlChange(int controller, int value, int channel) throws MidiPlayerException {
        byte[] event = new byte[]{(byte)(0xB0 | channel), (byte)controller, (byte)value};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendParameter(String key, String value) throws MidiPlayerException {
        if ("gm-channel-1".equals(key)) {
            this.channel1 = Integer.parseInt(value);
        }
        if ("gm-channel-2".equals(key)) {
            this.channel2 = Integer.parseInt(value);
        }
    }

    private int resolveChannel(boolean bendMode) {
        return bendMode ? this.channel2 : this.channel1;
    }
}

