/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action.file;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionException;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.file.TGSongPersistenceActionBase;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatException;
import app.tuxguitar.io.base.TGFileFormatManager;
import app.tuxguitar.io.base.TGSongReaderHandle;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.util.TGContext;
import java.io.InputStream;

public class TGReadSongAction
extends TGSongPersistenceActionBase {
    public static final String NAME = "action.song.read";
    public static final String IS_NEWER_FILE_FORMAT = "action.song.read.newerFileFormat";
    public static final String ATTRIBUTE_INPUT_STREAM = InputStream.class.getName();

    public TGReadSongAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        try {
            InputStream stream = (InputStream)context.getAttribute(ATTRIBUTE_INPUT_STREAM);
            TGFileFormat tgFileFormat = (TGFileFormat)context.getAttribute(ATTRIBUTE_FORMAT);
            TGSongManager tgSongManager = this.getSongManager(context);
            TGSongReaderHandle tgSongLoaderHandle = new TGSongReaderHandle();
            tgSongLoaderHandle.setFactory(tgSongManager.getFactory());
            tgSongLoaderHandle.setFormat(tgFileFormat);
            tgSongLoaderHandle.setInputStream(stream);
            tgSongLoaderHandle.setContext(this.findSongStreamContext(context));
            tgSongLoaderHandle.getContext().setAttribute("mimeType", context.getAttribute("mimeType"));
            tgSongLoaderHandle.getContext().setAttribute("formatCode", context.getAttribute("formatCode"));
            TGFileFormatManager.getInstance((TGContext)this.getContext()).read(tgSongLoaderHandle);
            if (tgSongLoaderHandle.getSong() != null) {
                tgSongManager.updatePreciseStart(tgSongLoaderHandle.getSong());
            }
            context.setAttribute(IS_NEWER_FILE_FORMAT, (Object)tgSongLoaderHandle.isNewerFileFormatDetected());
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)tgSongLoaderHandle.getSong());
            context.setAttribute(ATTRIBUTE_FORMAT, (Object)tgSongLoaderHandle.getFormat());
            TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
            tgActionManager.execute("action.song.load", context);
        }
        catch (TGFileFormatException e) {
            throw new TGActionException((Throwable)e);
        }
    }
}

