/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.custom;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TGUndoableClef
extends TGUndoableEditBase {
    private int doAction;
    private long position;
    private int redoableClef;
    private int undoableClef;
    private List<Object> nextClefPositions;
    private boolean toEnd;
    private TGTrack track;

    private TGUndoableClef(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeClef(actionContext, this.track, this.getMeasureAt(this.track, this.position), this.redoableClef, this.toEnd);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeClef(actionContext, this.track, this.getMeasureAt(this.track, this.position), this.undoableClef, this.toEnd);
        if (this.toEnd) {
            for (ClefPosition clefPosition : this.nextClefPositions) {
                this.changeClef(actionContext, this.track, this.getMeasureAt(this.track, clefPosition.getPosition()), clefPosition.getClef(), true);
            }
        }
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableClef startUndo(TGContext context, TGTrack track, TGMeasure measure) {
        TGUndoableClef undoable = new TGUndoableClef(context);
        undoable.doAction = 1;
        undoable.position = measure.getStart();
        undoable.undoableClef = measure.getClef();
        undoable.track = track;
        undoable.nextClefPositions = new ArrayList<Object>();
        int prevClef = undoable.undoableClef;
        Iterator it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure nextMeasure = (TGMeasure)it.next();
            if (nextMeasure.getStart() <= undoable.position) continue;
            int currClef = nextMeasure.getClef();
            if (prevClef != currClef) {
                ClefPosition tsp = new ClefPosition(nextMeasure.getStart(), currClef);
                undoable.nextClefPositions.add(tsp);
            }
            prevClef = currClef;
        }
        return undoable;
    }

    public TGUndoableClef endUndo(int clef, boolean toEnd) {
        this.redoableClef = clef;
        this.toEnd = toEnd;
        return this;
    }

    public TGMeasure getMeasureAt(TGTrack track, Long start) {
        return this.getSongManager().getTrackManager().getMeasureAt(track, start.longValue());
    }

    public void changeClef(TGActionContext context, TGTrack track, TGMeasure measure, Integer clef, Boolean applyToEnd) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.composition.change-clef");
        tgActionProcessor.setAttribute("clef", clef);
        tgActionProcessor.setAttribute("applyToEnd", applyToEnd);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, measure);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    private static class ClefPosition {
        private long position;
        private int clef;

        public ClefPosition(long position, int clef) {
            this.position = position;
            this.clef = clef;
        }

        public long getPosition() {
            return this.position;
        }

        public int getClef() {
            return this.clef;
        }
    }
}

