/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.custom;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.util.TGContext;

public class TGUndoableOpenRepeat
extends TGUndoableEditBase {
    private int doAction;
    private long position;

    private TGUndoableOpenRepeat(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeOpenRepeat(actionContext, this.getMeasureHeaderAt(this.position));
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeOpenRepeat(actionContext, this.getMeasureHeaderAt(this.position));
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableOpenRepeat startUndo(TGContext context, TGMeasureHeader header) {
        TGUndoableOpenRepeat undoable = new TGUndoableOpenRepeat(context);
        undoable.doAction = 1;
        undoable.position = header.getStart();
        return undoable;
    }

    public TGUndoableOpenRepeat endUndo() {
        return this;
    }

    public TGMeasureHeader getMeasureHeaderAt(Long start) {
        return this.getSongManager().getMeasureHeaderAt(this.getSong(), start.longValue());
    }

    public void changeOpenRepeat(TGActionContext context, TGMeasureHeader header) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.insert.open-repeat");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

