/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.custom;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;

public class TGUndoableSongInfo
extends TGUndoableEditBase {
    private int doAction;
    private String undoName;
    private String undoArtist;
    private String undoAlbum;
    private String undoAuthor;
    private String undoDate;
    private String undoCopyright;
    private String undoWriter;
    private String undoTranscriber;
    private String undoComments;
    private String redoName;
    private String redoArtist;
    private String redoAlbum;
    private String redoAuthor;
    private String redoDate;
    private String redoCopyright;
    private String redoWriter;
    private String redoTranscriber;
    private String redoComments;

    private TGUndoableSongInfo(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeInfo(actionContext, this.getSong(), this.redoName, this.redoArtist, this.redoAlbum, this.redoAuthor, this.redoDate, this.redoCopyright, this.redoWriter, this.redoTranscriber, this.redoComments);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeInfo(actionContext, this.getSong(), this.undoName, this.undoArtist, this.undoAlbum, this.undoAuthor, this.undoDate, this.undoCopyright, this.undoWriter, this.undoTranscriber, this.undoComments);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableSongInfo startUndo(TGContext context) {
        TGSong song = TGUndoableSongInfo.getSong(context);
        TGUndoableSongInfo undoable = new TGUndoableSongInfo(context);
        undoable.doAction = 1;
        undoable.undoName = song.getName();
        undoable.undoArtist = song.getArtist();
        undoable.undoAlbum = song.getAlbum();
        undoable.undoAuthor = song.getAuthor();
        undoable.undoDate = song.getDate();
        undoable.undoCopyright = song.getCopyright();
        undoable.undoWriter = song.getWriter();
        undoable.undoTranscriber = song.getTranscriber();
        undoable.undoComments = song.getComments();
        return undoable;
    }

    public TGUndoableSongInfo endUndo() {
        TGSong song = this.getSong();
        this.redoName = song.getName();
        this.redoArtist = song.getArtist();
        this.redoAlbum = song.getAlbum();
        this.redoAuthor = song.getAuthor();
        this.redoDate = song.getDate();
        this.redoCopyright = song.getCopyright();
        this.redoWriter = song.getWriter();
        this.redoTranscriber = song.getTranscriber();
        this.redoComments = song.getComments();
        return this;
    }

    public void changeInfo(TGActionContext context, TGSong song, String name, String artist, String album, String author, String date, String copyright, String writer, String transcriber, String comments) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.composition.change-info");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("name", name);
        tgActionProcessor.setAttribute("artist", artist);
        tgActionProcessor.setAttribute("album", album);
        tgActionProcessor.setAttribute("author", author);
        tgActionProcessor.setAttribute("date", date);
        tgActionProcessor.setAttribute("copyright", copyright);
        tgActionProcessor.setAttribute("writer", writer);
        tgActionProcessor.setAttribute("transcriber", transcriber);
        tgActionProcessor.setAttribute("comments", comments);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

